package gh.nano;
import robocode.*;
import robocode.util.Utils;
import java.awt.Color;
import java.awt.geom.*;
//import java.util.*;

/**
 * Grofvuil - a nanorobot by Gert Heijenk (GrubbmGait)
 *
 * This is just a try to get a working and reasonable performing nanobot.
 * The focus is on melee, therefor it borrows the radar of micro.Gruweltje.
 * The gun is a sort-of linear thing, the movement is a distance-dependent oscillator.
 *
 * Revision information:
 * v0.1 20050518 Initial version. First attempt to make a nano.
 * v0.2	20050605 Go slightly towards enemy to avoid getting stuck in corners
 */

public class Grofvuil extends TeamRobot {

	static double direction = 0.5;
	static final double halfpi = Math.PI/2;

	// some info about the current locked opponent
	static private String	eName;		// enemy name
	static private double	eAttrac;	// enemy attractivity (less is better)

	/**
	 * run: Grofvuil's default behavior
	 */
	public void run() {
		// Give the robot an appealing look
//		setColors( Color.red.darker(), Color.white, Color.red.brighter());

		// Start with a very unattractive target (copied from mld.Infinity)
		onRobotDeath(null);

		// Let gun (and not radar) move independently
		setAdjustGunForRobotTurn( true);
//		setAdjustRadarForGunTurn( true);		// is this necessary ??
		turnRadarRight( Double.POSITIVE_INFINITY);

		// mainloop
//		while( true ) {
			// perform all actions previously set
//			execute();
//		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {

		double dist = e.getDistance();

		// first check attractivity of scanned robot
		if (!(e.getName().equals( eName))) {
			if (dist < (eAttrac * 0.8)) {
				eName = e.getName();	// new more attractive enemy
			}
			else {
				return;		// new not very appealing enemy
			}
		}
		eAttrac = dist;	// set new attractivity

		// If we've reached the end of the oscillation, go back again.
		if (getDistanceRemaining() == 0)
		{
			// oscillate half the enemydistance
			setAhead((direction = -direction) * dist);
		}
		// Stay approx perpendicular to the opponent when in lock-mode
//		setTurnRightRadians( Double.POSITIVE_INFINITY * Math.tan( e.getBearingRadians() + halfpi));
//		setTurnRightRadians( Math.tan( e.getBearingRadians() + halfpi));
		setTurnRightRadians( Utils.normalRelativeAngle( e.getBearingRadians() + halfpi - (dist > 140 ? direction : -direction) / 3.5));

		dist = (getEnergy() * 15) / dist;	// energy management

		// If the gun is cool and I do not disable myself: Fire !
		if ((getGunHeat() == 0.0) && (getEnergy() > 0.1)) {
			setFire( dist);
		}
		else {
			// when not firing, lock on target. After firing, perform a sweep
			setTurnRadarLeft(getRadarTurnRemaining());
		}
		// Turn gun after eventual firing
//		double tmpb = (dist = getHeadingRadians() + e.getBearingRadians()) - e.getHeadingRadians() + (e.getVelocity() < 0 ? -halfpi : halfpi);
//		setTurnGunRightRadians( Utils.normalRelativeAngle( dist - getGunHeadingRadians() + Math.atan2(Math.cos(tmpb) * Math.abs(e.getVelocity()), 14 + Math.sin(tmpb))));
		double tmpb = (dist = getHeadingRadians() + e.getBearingRadians()) - e.getHeadingRadians() + halfpi;
		setTurnGunRightRadians( Utils.normalRelativeAngle( dist - getGunHeadingRadians() + Math.atan2(Math.cos(tmpb) * e.getVelocity(), 14 + Math.sin(tmpb))));
	}

	/**
	 * onRobotDeath: What to do when someone else dies
	 */
	public void onRobotDeath(RobotDeathEvent e) {
		// Copied from mld.Infinity, a shortcut to 'forget' killed targets
		eAttrac = Double.POSITIVE_INFINITY;		// make least attractive
	}
}