package nz.jdc.nano;

import robocode.AdvancedRobot;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

/**
 * PatternAdept
 * With all due respect to Roger Zelazny.
 * 
 * A revised version of NeophytePattern with the new "Adept" style movement.
 * 
 * Firing: Pattern matching.
 * Movement: Orbit -> Oscillate -> Toggle on hit.
 * 
 * Credits: 
 * Gun is a slightly modified copy of Eric Simonton's nano pattern gun from WeekendObsession.
 * Movement is based on the very elegant movement strategy of dft.Freddie 1.32 by Alcatraz271,
 * with later modifications inspired by Yatagan (Sheldor, Skilgannon) and doubtlessly some 
 * ideas from the very cunning Michael Dorgan.
 *  
 * Version 1.0: Initial Release.
 *   Codesize ???.
 *
 * @author John Cleland 
 */
public class PatternAdept extends AdvancedRobot {
  // tunable constants
  // for movement
  private final static double MOVE_DISTANCE       = 80;
  private final static double PREFERRED_RANGE     = 200;  // fixme tune range and BP, prob want longer now we don't have anti-ram BP, or higher BP
  private final static double CLOSE_FCT           = 430 * MOVE_DISTANCE;
  
  // for gun
  private final static double BULLET_POWER        = 2.45; 
  private final static double BULLET_SPEED        = 20.0 - 3.0 * (double) BULLET_POWER; 
  private final static double DISTANCE_DIVISOR    = PREFERRED_RANGE;
  private final static int    PREDICT_TICKS       = (int) (DISTANCE_DIVISOR / BULLET_SPEED + 1.5);
  private final static int    MAX_MATCH_LEN       = 57; // or 71 or 41-45 @ -1, not clear which is best
  
  // attributes
  // for movement
  private static double       enemyEnergy;
  private static double       moveDir;
  private static int          moveMode;

  /**
   * Bot run method.
   */
  public void run() {
    // testparam = Double.parseDouble(System.getProperty("RUMBLETESTER_PARAM"));
    
    // start our infinite radar loop
    turnRadarRightRadians(moveDir = MOVE_DISTANCE);
  }
  
  /**
   * Scan handler.
   * This is where it all happens.
   */ 
  public void onScannedRobot(ScannedRobotEvent e) {
    // register vars, should be the most commonly used
    int    ri = MAX_MATCH_LEN;
    double rd;
 
    // other vars
    int matchPos;
    
    // radar scan
    setTurnRadarLeftRadians(getRadarTurnRemaining());
    
    // fire
    setFire(BULLET_POWER);  

    // bullet dodge a random distance
    if ( (char) ((enemyEnergy - 1 - (enemyEnergy = e.getEnergy()))) <= 2) {
      moveDir *= (short) MOVE_TABLE.charAt(moveMode);
    }
    setAhead(moveDir * Math.random()); 
    
    // turn perpendicular with range control
    setTurnRightRadians(Math.cos((PREFERRED_RANGE - e.getDistance()) * moveDir / CLOSE_FCT + (rd = e.getBearingRadians())));
    
    // rd has enemy relative bearing, now updated to absolute bearing
    rd += getHeadingRadians();

    // pattern gun from WeekendOnsession by Eric Simonton
    // add last enemy move to the pattern
    enemyHistory = String.valueOf((char) (e.getVelocity() * (Math.sin(e.getHeadingRadians() - rd)))).concat(enemyHistory);
    
    // search for a match
    while((matchPos = enemyHistory.indexOf(enemyHistory.substring(0, ri-=2), PREDICT_TICKS)) < 0);
    
    // calculate aim offset
    ri = PREDICT_TICKS;
    do { rd += ((short) enemyHistory.charAt(--matchPos)) / DISTANCE_DIVISOR; } while (--ri > 0);
    
    // turn gun
    setTurnGunRightRadians(Utils.normalRelativeAngle(rd - getGunHeadingRadians()));
  }
  
  /**
   * Hit a wall, reverse direction and start moving immediately.
   */
  public void onHitWall(HitWallEvent e) {
    moveDir = -moveDir;
  }

  public void onDeath(DeathEvent event) {
    moveMode += 2;
  }

  /**
   * Hit by bullet, change movement strategy.
   */
  public void onHitByBullet(HitByBulletEvent e) {
    moveMode ^= 1;
  }
  
  // table constants
  private final static char  ORBIT = (char) 1;
  private final static char  OSC   = (char) -1;
  private final static String MOVE_TABLE = "" 
    + ORBIT + ORBIT + OSC + OSC + ORBIT + ORBIT + OSC + OSC + ORBIT + ORBIT + OSC + OSC + ORBIT + ORBIT
    + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC
    + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC
    + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC
    + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC
    + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC
    + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC
    + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC
    + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC
    + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC
    + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC
    + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC
    + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC
    + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC
    + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC
    + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC
    + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC
    + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC
    + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC
    + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC
    + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC
    + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC
    + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC
    + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC + ORBIT + OSC
    ;

  // the pattern
  public static String enemyHistory = ""
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 1
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 2
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char)-1
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char)-2 + (char)-4 + (char)-6
    + (char)-8 + (char)-8 + (char)-8 + (char)-8
    + (char)-8 + (char)-8 + (char)-8 + (char)-8
    + (char)-8 + (char)-8 + (char)-8 + (char)-8
    + (char)-8 + (char)-8 + (char)-8 + (char)-8
    + (char)-8 + (char)-8 + (char)-8 + (char)-8
    + (char)-8 + (char)-8 + (char)-8 + (char)-8
    + (char)-8 + (char)-8 + (char)-8 + (char)-8
    + (char)-8 + (char)-8 + (char)-8 + (char)-8
    + (char)-8 + (char)-8 + (char)-8 + (char)-8
    + (char)-8 + (char)-8 + (char)-8 + (char)-8
    + (char)-7 + (char)-6 + (char)-5 + (char)-4
    + (char)-3 + (char)-2 + (char)-1 + (char) 0
    + (char) 2 + (char) 4 + (char) 6 + (char) 8
    + (char) 8 + (char) 8 + (char) 8 + (char) 8
    + (char) 8 + (char) 8 + (char) 8 + (char) 8
    + (char) 8 + (char) 8 + (char) 8 + (char) 8
    + (char) 8 + (char) 8 + (char) 8 + (char) 8
    + (char) 8 + (char) 8 + (char) 8 + (char) 8
    + (char) 8 + (char) 8 + (char) 8 + (char) 8
    + (char) 8 + (char) 8 + (char) 8 + (char) 8
    + (char) 8 + (char) 8 + (char) 8 + (char) 8
    + (char) 8 + (char) 8 + (char) 8 + (char) 8
    + (char) 8 + (char) 8 + (char) 8 + (char) 8
    + (char) 7 + (char) 6 + (char) 5 + (char) 4
    + (char) 3 + (char) 2 + (char) 1 + (char) 0;

}
