package davidalves.net.radar.strategies;

//Imports for all classes
import robocode.*;
import davidalves.net.*;
import davidalves.net.targeting.*;
import davidalves.net.data.*;
import davidalves.net.math.*;
import davidalves.net.movement.*;
import davidalves.net.radar.RadarInterface;
import davidalves.net.util.*;
import java.util.*;
import java.awt.Color;
import java.io.*;


/**
 * @author David Alves
 *
 */
public class DuelStrategy implements RadarInterface, Serializable {
	AbstractAdvancedBot me;
	EnvironmentInterface environment;
	FiniteMovingAverage shortTargetSpeed, longTargetSpeed;
	/**
	 * @see davidalves.net.scan.RadarMethodInterface#scanTo(DaveBot, Hashtable)
	 */
	public DuelStrategy(AbstractAdvancedBot myBot, EnvironmentInterface e){
		me = myBot;
		environment = e;
		shortTargetSpeed = new FiniteMovingAverage(5);
		longTargetSpeed = new FiniteMovingAverage(20);
	}
	
	public double scan() {
		double radarOffset;
		//double scanArcWidth = .1;
		RobocodeRobot target = environment.getTarget();
		shortTargetSpeed.addValue(Math.abs(target.getSpeed()));
		longTargetSpeed.addValue(Math.abs(target.getSpeed()));
		//double scanArcWidth = .01 + shortTargetSpeed.getAverage()  + longTargetSpeed.getAverage();
		double scanArcWidth = .01;
		
		if (me.getTime() - target.getLastScannedTime() > 8) //We need a new target
			return DaveMath.QUARTERCIRCLE;
		
		//If we just switched to duel mode and aren't yet tracking the last remaining enemy,
		//sweep until we find him
		if(!target.alive())
			return DaveMath.QUARTERCIRCLE;
		
		radarOffset = DaveMath.angularDifferenceBetween(me.getRadarHeading(),me.getAbsoluteAngleTo(environment.getTarget())); 
		//me.out.println("Angle to target" + me.getAbsoluteAngleTo(dataStore.getTarget()) + " current radar heading: " + me.getRadarHeading());

		if (radarOffset < 0)
			radarOffset -= scanArcWidth;
		else
			radarOffset += scanArcWidth;

		return radarOffset;
	}

}
