package davidalves.net.util;


//Imports for all classes
import robocode.*;
import davidalves.net.AbstractAdvancedBot;
import davidalves.net.targeting.*;
import davidalves.net.math.*;
import davidalves.net.movement.*;
import java.util.*;
import java.io.*;



//An enemy
public class RobocodeRobot implements Serializable{
	String name;
	double bearing, heading, speed, x, y, distance, deltaHeading, energy, lastBulletPower = 3;
	public FiniteMovingAverage averageSpeed = new FiniteMovingAverage(10), averageDeltaHeading = new FiniteMovingAverage(10);
	
	long lastScannedTime, lastFiredTime = - 9999;
	boolean live;
	
	public void kill(){live = false;}
	
	//Accessors (Getters)
	public String getName(){return name;}
	public Point getLocation(){return new Point(x, y);}
	public long getLastScannedTime(){return lastScannedTime;}
	public double getBearing(){return bearing;}
	public double getHeading(){return heading;}
	public double getDeltaHeading(){return deltaHeading;}
	public double getSpeed(){return speed;}
	public double getDistance(){return distance;}
	public double getEnergy(){return energy;}
	public double getX(){return x;}
	public double getY(){return y;}
	public boolean alive(){return live;}
	public long getLastFiredTime(){return lastFiredTime;}
	public double getLastBulletPower(){return lastBulletPower;}
	
	//Mutators (Setters)
	public void setLastBulletPower(double power){lastBulletPower = power;}
	public void setLastFiredTime(long lastTime){lastFiredTime = lastTime;}

	
	//Make an enemy out of a radar scan
	public RobocodeRobot(ScannedRobotEvent e, AbstractAdvancedBot me){
		//double absoluteBearing = (Math.toRadians(DaveBot.me.getHeading()) + e.getBearingRadians()) % Settings.FULLCIRCLE;
		double absoluteBearing = DaveMath.normalizeAbsoluteAngle(me.getHeading() + e.getBearing());
		//double h = DaveMath.normalizeAbsoluteAngle(e.getHeading() - heading);
		
		averageSpeed = new FiniteMovingAverage();
		averageDeltaHeading = new FiniteMovingAverage();
		
		name = e.getName();
		deltaHeading = 0;

		//Initialize moving averages
		averageSpeed.addValue(e.getVelocity());
		averageDeltaHeading.addValue(0);

		x = me.getX() + DaveMath.xComponent(absoluteBearing) * e.getDistance();
		y = me.getY() + DaveMath.yComponent(absoluteBearing) * e.getDistance();
		
		//bearing = e.getBearing();
		bearing = absoluteBearing;
		heading = e.getHeading();
				
		lastScannedTime = e.getTime();
		speed = e.getVelocity();
		distance = e.getDistance();
		live = true;
		energy = e.getEnergy();
	}
	
	public void updateScan(ScannedRobotEvent e, AbstractAdvancedBot me){
			double absoluteBearing = DaveMath.normalizeAbsoluteAngle(me.getHeading() + e.getBearing());
			double deltaTime = me.getTime() - lastScannedTime;
			double newDeltaHeading = DaveMath.normalizeRelativeAngle((e.getHeading() - heading) / deltaTime);
			energy = e.getEnergy();
			
			deltaHeading = newDeltaHeading;
			averageDeltaHeading.addValue(newDeltaHeading);

			//update moving averages
			averageSpeed.addValue(e.getVelocity());
			
			
			//setPosition(new Point(getX()+Math.sin(absoluteBearing_rad)*e.getDistance(), y = getY()+Math.cos(absoluteBearing_rad)*e.getDistance()));
			x = me.getX() + DaveMath.xComponent(absoluteBearing) * e.getDistance();
			y = me.getY() + DaveMath.yComponent(absoluteBearing) * e.getDistance();
			
			bearing = absoluteBearing; //e.getBearing();
			heading = e.getHeading();
			
			lastScannedTime = me.getTime();
			speed = e.getVelocity();
			distance = e.getDistance();
	}
	
	//Used to construct temporary variables
	public RobocodeRobot(){
		averageSpeed = new FiniteMovingAverage();
		averageDeltaHeading = new FiniteMovingAverage();
	}
	
	public double powerNeededToKill()
	{
		if (energy > 16){
			return 3;
		} else if (energy > 4){
			return (energy + 2) / 6 + .1;
		} else {
			return energy / 4 + .1;
		}
	}
	
	public String getRobotClass(){
		return DaveString.getRobotClass(name);
	}
	
	public int getRobotNumber(){
		return DaveString.getRobotNumber(name);
	}
	
	public Point maxForwardPosition(double time){
		return new Point(
			x + DaveMath.xComponent(heading) * DaveMath.maxForwardDrivingDistance(speed, time),
			y + DaveMath.yComponent(heading) * DaveMath.maxForwardDrivingDistance(speed, time)
		);
		
	}
	
	public Point maxBackwardPosition(double time){
		return new Point(
			x + DaveMath.xComponent(heading) * DaveMath.maxBackwardDrivingDistance(speed, time),
			y + DaveMath.yComponent(heading) * DaveMath.maxBackwardDrivingDistance(speed, time)
		);
	}
	
	public double getLastBulletTravelTime(){
		return distance / DaveMath.speedCorrespondingToPower(lastBulletPower);
	}
	
	public double getLastBulletTimeOfImpact(){
		return getLastBulletTravelTime() + lastFiredTime;
	}
	
	public String toString(){
		String returnValue = new String();
		returnValue += "\n> Name:                 " + name;
		returnValue += "\n> Energy:               " + DaveString.formatDouble(energy);
		returnValue += "\n> Alive:                " + live;
		returnValue += "\n> Bearing:              " + DaveString.formatDouble(bearing);
		returnValue += "\n> Heading:              " + DaveString.formatDouble(heading);
		returnValue += "\n> Speed:                " + DaveString.formatDouble(speed);
		returnValue += "\n> Position:             " + getLocation();
		returnValue += "\n> Distance:             " + DaveString.formatDouble(distance);
		returnValue += "\n> DeltaHeading:         " + DaveString.formatDouble(deltaHeading);
		returnValue += "\n> Average Speed:        " + averageSpeed;
		returnValue += "\n> Average DeltaHeading: " + averageDeltaHeading;
		returnValue += "\n> Last Scanned time:    " + lastScannedTime;
		return returnValue;
	}
}