package bvh.fnr;
import java.awt.geom.Point2D;
import robocode.*;
/**
 * Kogel - deze class bevat zoveel informatie over een kogel:
 *
 * Deze class is bedoeld om informatie over eigen uitgaande kogels en
 * gescande inkomende kogels op te slaan.
 */
class Kogel implements Constanten {

   public String         naam;              // naam van doel dat kogel heeft afgeschoten
   public long           scanTijd;          // tijd waarop kogel is gescanned
   public Point2D.Double scanPositie;       // de initiele positie van het gescande doel
   public double         v;                 // geschatte snelheid o.b.v. energieverlies gescande doel
   public double         scanAfstand, richting; // afstand en hoek tov. mijn botje
   public double         bewegingsrichting; // bewegingsrichting v.d.kogel = - richting t.o.v. mijn bot
                                            // bij aanname dat doel op mij schiet...

// constructor:
   public Kogel() {
      naam = null;
   }

   public Kogel(String n, Point2D.Double pos, long t, double e, double a, double r) {
      this.naam              = n;
      this.scanTijd          = t-1;
      this.scanPositie       = new Point2D.Double( pos.x, pos.y );
      this.scanAfstand       = a;
      // ingegeven hoek is de hoek vd gescande kogel tov de eigen bot;
      this.bewegingsrichting = r;
      this.v                 = 20D - 3D * e;
   }

/**
* Methoden geven x,y-waarden van de oorsprong van de kogel:
*/
   public Point2D.Double getScanPositie() {return scanPositie;}
   public double getScanX() {return scanPositie.x;}
   public double getScanY() {return scanPositie.y;}
/**
* Methoden geven de x,y-waarden van de kogel op tijd t.
*/
   public Point2D.Double getPositie(long t) {return ( new Point2D.Double(getX(t), getY(t)) );}
   public double getX(long t) {return  (scanPositie.x + Math.sin(bewegingsrichting) * v * (t-scanTijd));}
   public double getY(long t) {return  (scanPositie.y + Math.cos(bewegingsrichting) * v * (t-scanTijd));}
/**
* Methode geeft de afstand van de kogel t.o.v. de eigen bot op tijd t.
*/
   public double getAfstand(long t, Point2D.Double botPositie) {
      return  ( HulpRoutines.bepaalAfstand( getPositie(t), botPositie ) );
   }
/**
* Methode geeft de afgelegde weg van de kogel op tijd t.
*/
   public double getAfgelegdeWeg(long t) {
      return  ( v * (t-scanTijd) );
   }

 } // einde class Kogel
/**********************************************************************
** EINDE KOGEL
**********************************************************************/
