package bvh.fnr;

import java.awt.geom.Point2D;
import robocode.*;
/**
 * Slagveld - deze class bevat basis gegegevens m.b.t. het slagveld,
 * zoals bijv. de grootte:
 *
 * Verder bevat deze class methoden om de afstand tot wanden, hoeken
 * en dichts bijzijnde hoek te bepalen.
 */
class Slagveld implements Constanten {

// variabelen voor strijdperk:
   public  Point2D.Double   middelpunt;
   private static double    xMax, yMax, xM, yM;

   public Slagveld(AdvancedRobot bot) { // constructor
      xMax       = bot.getBattleFieldWidth();
      yMax       = bot.getBattleFieldHeight();
      xM         = xMax/2D;
      yM         = yMax/2D;
      middelpunt = new Point2D.Double(xM, yM);
   }

   public static double xBinnenSlagveld(double x) {
      if      (x < 18D      ) return (18D); // 18 is halve breedte van een robot
      else if (x > xMax-18D ) return (xMax-18D);
      else                    return (x);
   }

   public static double yBinnenSlagveld(double y) {
      if      (y < 18D      ) return (18D);
      else if (y > yMax-18D ) return (yMax-18D);
      else                    return (y);
   }

   public static Point2D.Double BinnenSlagveld(Point2D.Double p) {
      p.x = xBinnenSlagveld( p.x );
      p.y = yBinnenSlagveld( p.y );
      return (p);
   }
 }
/**********************************************************************
** EINDE CLASS SLAGVELD
**********************************************************************/
