package axeBots;

import robocode.*;
import java.io.*;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;

public class Stratego {

    public static final String STAT_FILE_PREFIX= "stat_";
    public static final String STAT_FILE_EXTENSION= ".txt";
    public static final int MOVE_WALLSWING= 0;
    public static final int MOVE_PREDICTING_STOP= 1;
    public static final int MOVE_PREDICTING_SLOW= 2;
    public static final int MOVE_ON_FIRE= 3;
    public static final int MOVE_TWISTER= 4;
    public static final int MOVE_STRATS= 5; //11;

    private int usingMove= MOVE_WALLSWING;

    private int moveHited[]= new int[AIM_STRATS];
    private int moveFired[]= new int[AIM_STRATS];
    private double moveDamaged[]= new double[AIM_STRATS];

    public static final int AIM_STATIC= 0; //2;
    public static final int AIM_CIRCULAR_AVG= 1; //4;
    public static final int AIM_CIRCULAR_ACC= 2; //6;
    public static final int AIM_INTERPOLATED_MATCH= 3; //8;
    public static final int AIM_HISTORY_MATCH= 4; //9;
    public static final int AIM_MOVEMENT_ESTIMATED= 5; //10;
    //fora:
    public static final int AIM_LINEAR_ACC= 6; //3;//7;
    public static final int AIM_LINEAR_AVG= 7;
    public static final int AIM_CIRCULAR= 8;
    public static final int AIM_LINEAR= 9;
    public static final int AIM_PATTERN_MATCH= 10;

    public static final int AIM_STRATS= 11; //11;
    private int totHits[][]= new int[AIM_STRATS][AIM_ANGLES_QTD];
    private int totFired[][]= new int[AIM_STRATS][AIM_ANGLES_QTD];
    private int totHitsPR[][][]=
        new int[AIM_STRATS][AIM_ANGLES_QTD][AIM_RANGES_QTD];
    private int totFiredPR[][][]=
        new int[AIM_STRATS][AIM_ANGLES_QTD][AIM_RANGES_QTD];
    //[AIM_ANGLES_QTD];
    private int duelTotHits[][]= new int[AIM_STRATS][AIM_ANGLES_QTD];
    private int duelTotFired[][]= new int[AIM_STRATS][AIM_ANGLES_QTD];
    private int duelTotHitsPR[][][]=
        new int[AIM_STRATS][AIM_ANGLES_QTD][AIM_RANGES_QTD];
    private int duelTotFiredPR[][][]=
        new int[AIM_STRATS][AIM_ANGLES_QTD][AIM_RANGES_QTD];
    //[AIM_ANGLES_QTD];
    private int meleeTotHits[][]= new int[AIM_STRATS][AIM_ANGLES_QTD];
    private int meleeTotFired[][]= new int[AIM_STRATS][AIM_ANGLES_QTD];
    private int meleeTotHitsPR[][][]=
        new int[AIM_STRATS][AIM_ANGLES_QTD][AIM_RANGES_QTD];
    //[AIM_ANGLES_QTD];
    private int meleeTotFiredPR[][][]=
        new int[AIM_STRATS][AIM_ANGLES_QTD][AIM_RANGES_QTD];
    //[AIM_ANGLES_QTD];
    public static final int AIM_RANGES_QTD= 6; //12;
    public static final int AIM_RANGES_WIDTH= 200; //100;
    public static final int AIM_ANGLES_QTD= 2; //100;
    public static final int AIM_ANGLES_WIDTH= 45; //100;

    public static final String TOKEN_VIRGULA= ",";
    public static final String TOKEN_DOIS_PONTOS= ":";
    public static final String TOKEN_BARRA_DIVISAO= "/";
    //private double ranges[] = new double[rangesQtd];
    private int usingAim= /*AIM_MOVEMENT_ESTIMATED; //*/
    AIM_CIRCULAR;
    private int missesChange= 5;
    private int misses= 0;
    private int targMissesOnARow= 0;
    private String name= null;
    private PrintStream log= null;
    //private int totPts;
    //private boolean rstPts;
    private boolean duel= false;
    private ArrayList scoring= new ArrayList();
    private AxeScoreReg score= null;
    private int totBots= 0;

    private boolean changeMoving= false;

    //private Vector moveStat = new Vector();
    public static String getStratName(int strat) {
        switch (strat) {
            case AIM_CIRCULAR :
                return "AIM_CIRCULAR";
            case AIM_LINEAR :
                return "AIM_LINEAR";
            case AIM_STATIC :
                return "AIM_STATIC";
            case AIM_CIRCULAR_AVG :
                return "AIM_CIRCULAR_AVG";
            case AIM_LINEAR_AVG :
                return "AIM_LINEAR_AVG";
            case AIM_CIRCULAR_ACC :
                return "AIM_CIRCULAR_ACC";
            case AIM_LINEAR_ACC :
                return "AIM_LINEAR_ACC";
            case AIM_PATTERN_MATCH :
                return "AIM_PATTERN_MATCH";
            case AIM_INTERPOLATED_MATCH :
                return "AIM_INTERPOLATED_MATCH";
            case AIM_HISTORY_MATCH :
                return "AIM_HISTORY_MATCH";
            case AIM_MOVEMENT_ESTIMATED :
                return "AIM_MOVEMENT_ESTIMATED";
        }
        return "AIM_NOTFOUND";
    }

    public static String getMoveStratName(int strat) {
        switch (strat) {
            case MOVE_WALLSWING :
                return "MOVE_WALLSWING";
            case MOVE_PREDICTING_STOP :
                return "MOVE_PREDICTING_STOP";
            case MOVE_PREDICTING_SLOW :
                return "MOVE_PREDICTING_SLOW";
            case MOVE_ON_FIRE :
                return "MOVE_ON_FIRE";
            case MOVE_TWISTER :
                return "MOVE_TWISTER";
        }
        return "MOVE_NOTFOUND";
    }

    public static String getAngleLabel(int strat) {
        switch (strat) {
            case 0 :
                return "PARALELO";
            case 1 :
                return "PERPENDICULAR";
        }
        return "NOTFOUND";
    }

    public Stratego(String n, PrintStream inlog, AxeTarget t) {
        this(n, inlog);
        //log = inlog;
        //name = n;
        //reset();
        //resetTots();
        HataMoto me= (HataMoto)HataMoto.getIt();

        totBots= me.getTotBots();
        String dataFileName= STAT_FILE_PREFIX + name + STAT_FILE_EXTENSION;

        loadData(me.getDataFile(dataFileName));

        //log.println("CREATING STRATEGO FOR:"+name+"\r\n"+getStats());
        usingAim= chooseAimStrat(t);
        if (me.getRoundNum() == 1) {

            this.resetScores();
        }
    }

    public Stratego(String n, PrintStream inlog) {
        super();

        name= n;
        log= inlog;
        log.println("criando: " + name);
    }
    /*private void reset()
    {
    	for(int i=0; i< AIM_STRATS; i++)
    	{
    		hits[i] = 0;
    		fired[i] = 0;
    	}
    }*/
    //public  void fired(double pwr) {}
    public void setDuel(boolean d) {
        //log.println("setduela :"+d+"  " +duel);
        if (d == duel)
            return;
        //log.println("SETDUEL STRATEGO:"+name);
        this.changeMoving= true;
        duel= d;
        changeDuel(duel);
    }
    public boolean isDuel() {
        return duel;
    }
    //    public  double getAvgHit() {
    //        return (((double)totHits[using]) / (double)totFired[using]);
    //    }
    //    public  Vector getAvgHitVector() {
    //        Vector avg= new Vector();
    //
    //        for (int i= 0; i < AIM_STRATS; i++) {
    //
    //            avg.addElement(
    //                new Double(((double)totHits[i]) / (double)totFired[i]));
    //
    //        }
    //
    //        return avg;
    //    }
    public ArrayList[] getDuelAimStats() {
        ArrayList ret[]= new ArrayList[AIM_ANGLES_QTD];

        for (int j= 0; j < AIM_ANGLES_QTD; j++) {
            ret[j]= new ArrayList();
            AxeAimingStrats tot= new AxeAimingStrats(12, "AIM_TOTAIS");
            for (int i= 0; i < AIM_STRATS; i++) {
                AxeAimingStrats aim=
                    new AxeAimingStrats(
                        i,
                        "DUEL "
                            + this.getAngleLabel(j)
                            + " "
                            + this.getStratName(i),
                        duelTotHits[i][j],
                        duelTotFired[i][j],
                        duelTotHitsPR[i][j],
                        duelTotFiredPR[i][j]);
                tot.add(aim);
                ret[j].add(aim);
            }
            ret[j].add(tot);
        }
        return ret;
    }
    public ArrayList[] getMeleeAimStats() {
        ArrayList ret[]= new ArrayList[AIM_ANGLES_QTD];

        for (int j= 0; j < AIM_ANGLES_QTD; j++) {
            ret[j]= new ArrayList();
            AxeAimingStrats tot= new AxeAimingStrats(12, "AIM_TOTAIS");
            for (int i= 0; i < AIM_STRATS; i++) {
                AxeAimingStrats aim=
                    new AxeAimingStrats(
                        i,
                        "MELEE "
                            + this.getAngleLabel(j)
                            + " "
                            + this.getStratName(i),
                        meleeTotHits[i][j],
                        meleeTotFired[i][j],
                        meleeTotHitsPR[i][j],
                        meleeTotFiredPR[i][j]);
                tot.add(aim);
                ret[j].add(aim);
            }
            ret[j].add(tot);
        }
        return ret;
    }
    //    public  Vector getNamesVector() {
    //        Vector names= new Vector();
    //
    //        for (int i= 0; i < AIM_STRATS; i++) {
    //
    //            names.addElement(getStratName(i));
    //
    //        }
    //
    //        return names;
    //    }
    //    public  int getTargetMisses() {
    //        return (targMissesOnARow);
    //    }
    //    public  void resetTargetMisses() {
    //        targMissesOnARow= 0;
    //    }
    //    public  double getBestAvgHit() {
    //        double avgNow= Double.NaN;
    //        double avgSearch= 0;
    //        for (int i= 0; i < AIM_STRATS; i++) {
    //
    //            avgSearch= (((double)totHits[i]) / (double)totFired[i]);
    //            //log.println("########### FIRED > 200:"+getStratName(i)+" RATE:"+avgSearch+" FIRED:"+totFired[i]);
    //            if (Double.isNaN(avgNow)) {
    //                avgNow= avgSearch;
    //            } else if (avgNow < avgSearch) {
    //                avgNow= avgSearch;
    //            }
    //            //fired[i] = 0;
    //        }
    //
    //        return avgNow;
    //    }

    public double getAvgDistHit(AxeTarget t) {
        int ind= getDistInd(t.getDistance());
        int ang= getAngleInd(t.getAngle());
        double ret=
            (double)totHitsPR[usingAim][ang][ind]
                / (double)totFiredPR[usingAim][ang][ind];
        ret= (Double.isNaN(ret)) ? 0.00 : ret;
        return ret;
    }

    //    private double getBestAvg() {
    //        double avgs[] = new double[AIM_STRATS];
    //        for (int i = 0; i < AIM_STRATS; i++) {
    //            double avg = (double)totHits[i] / (double)totFired[i];
    //            avg = (Double.isNaN(avg)) ? 0.00 : avg;
    //            avgs[i] = avg;
    //        }
    //        return RoboMath.getMax(avgs);
    //    }

    private double getBestAllAvg() {
        double avgs[]= new double[AIM_STRATS * AIM_ANGLES_QTD];
        for (int j= 0; j < AIM_ANGLES_QTD; j++) {
            for (int i= 0; i < AIM_STRATS; i++) {
                double avg= (double)totHits[i][j] / (double)totFired[i][j];
                avg= (Double.isNaN(avg)) ? 0.00 : avg;
                avgs[(j * AIM_STRATS) + i]= avg;
            }
        }
        return RoboMath.getMax(avgs);
    }

    public double getBestAvg(double dist, double ang) {
        int ind= getDistInd(dist);
        int angInd= getAngleInd(ang);
        double avgs[]= new double[AIM_STRATS];
        for (int i= 0; i < AIM_STRATS; i++) {
            double avg=
                (double)totHitsPR[i][angInd][ind]
                    / (double)totFiredPR[i][angInd][ind];
            avg= (Double.isNaN(avg)) ? 0.00 : avg;
            avgs[i]= avg;
        }
        return RoboMath.getMax(avgs);
    }

    public void setScore(int pts) {
        log.println("STRATEGO SETSCORE: " + pts);
        score.addScore(pts);
        //log.println("===> SCORE: "+score);
    }
    //    public  int getTotPts() {
    //        return totPts;
    //    }
    public void setEnemyFired(int mov) {
        if (duel && (HataMoto.getIt().getOthers() > 0)) {
            this.moveFired[mov]++;
        }
    }
    public void setEnemyHitedMe(int mov, double pow) {
        if (HataMoto.getIt().getOthers() > 0) {
            score.addDamage(pow);
            if (duel) {
                this.changeMoving= true;
                this.moveHited[mov]++;
                this.moveDamaged[mov] += pow;
            }
        }
    }

    public int getMoving() {
        if (changeMoving) {
            changeMoving= false;
            usingMove= chooseMoving();
        }

        return usingMove; // = MOVE_TWISTER;
    }

    private ArrayList getAvgMissesInMovings() {
        ArrayList ret= new ArrayList();
        for (int i= 0; i < this.MOVE_STRATS; i++) {
            double misses= moveFired[i] - moveHited[i];
            misses= (misses < 0) ? 0.00 : misses;
            double avg= misses / (double)moveFired[i];
            avg= (Double.isNaN(avg)) ? 0.00 : avg;
            ret.add(new Double(avg));
        }
        return ret;
    }

    private int chooseMoving() {
        double minRate= 50.00;
        double totFired= RoboMath.getSum(this.moveFired);
        //expoente eh uma curva saturada em 3, funcao do numero de tiros disparados
        // quanto mais disparos, maior exp.
        //double exp= (1 - Math.exp((totFired / -5000.00))) * 15;

        double exp= Math.pow((totFired / (MOVE_STRATS * 40)), 2.00);
        exp= (exp > 100) ? 100 : exp;

        ArrayList movingRates= this.getAvgMissesInMovings();
        // ajusta as chances pelo rate de acerto(%) elevado ao exp
        // seta os componentes do stratsChances como o limitante maximo 
        // do intervalo.
        double edge= 0;
        ArrayList movingChances= new ArrayList();
        Iterator it= movingRates.iterator();
        while (it.hasNext()) {
            double chance= ((Double)it.next()).doubleValue();
            chance *= 100.00;
            chance= (chance > minRate) ? chance : minRate;
            chance= Math.pow(chance, exp);
            edge += chance;
            movingChances.add(new Double(edge));
        }
        double alea= Math.random() * edge;
        //verifica qual strategia foi sorteada
        it= movingChances.iterator();
        int strat= 0;
        while (it.hasNext()) {
            double stratEdge= ((Double)it.next()).doubleValue();
            if (alea < stratEdge) {
                //                log.println(
                //                    "########### CHOOSEN MOVING STRATEGY:"
                //                        + this.getMoveStratName(strat));
                break;
            }
            strat++;
        }
        return strat;
    }

    //    public int getBestMoving() {
    //        if (!duel) {
    //            return MOVE_WALLSWING;
    //        }
    //        //if(true) return Stratego.MOVE_PREDICTING_SLOW;
    //        double avgNow = Double.NaN;
    //        double dmgNow = Double.NaN;
    //        double avgSearch = 0;
    //        int ret = 0;
    //        for (int i = 0; i < MOVE_STRATS; i++) {
    //            if (moveFired[i] > 0) {
    //                avgSearch = moveDamaged[i] / moveFired[i];
    //            } else {
    //                avgSearch = 0;
    //            }
    //            if (Double.isNaN(avgNow)) {
    //                avgNow = avgSearch;
    //                dmgNow = moveDamaged[i];
    //                ret = i;
    //                continue;
    //            } else if (avgSearch < avgNow) {
    //                avgNow = avgSearch;
    //                dmgNow = moveDamaged[i];
    //                ret = i;
    //                continue;
    //            }
    //            if ((moveDamaged[i] * 0.05) < dmgNow) {
    //                avgNow = avgSearch;
    //                dmgNow = moveDamaged[i];
    //                ret = i;
    //                break;
    //            }
    //            //fired[i] = 0;
    //        }
    //        //        HataMoto.getIt().out.println(
    //        //            "getBestMoving:"
    //        //                + this.getMoveStratName(ret)
    //        //                + ":"
    //        //                + avgNow
    //        //                + " ("
    //        //                + moveDamaged[ret]
    //        //                + "/"
    //        //                + moveFired[ret]
    //        //                + ")");
    //        return ret;
    //    }
    //    public  double getBestAvgDistHit(double dist) {
    //        int ind= getDistInd(dist);
    //        double avgNow= Double.NaN;
    //        double avgSearch= 0;
    //        for (int i= 0; i < AIM_STRATS; i++) {
    //
    //            avgSearch=
    //                (((double)totHitsPR[i][ind]) / (double)totFiredPR[i][ind]);
    //            //log.println("########### FIRED > 200:"+getStratName(i)+" RATE:"+avgSearch+" FIRED:"+totFired[i]);
    //            if (Double.isNaN(avgNow)) {
    //                avgNow= avgSearch;
    //            } else if (avgNow < avgSearch) {
    //                avgNow= avgSearch;
    //            }
    //            //fired[i] = 0;
    //        }
    //
    //        return avgNow;
    //    }
    //    public String getStats() {
    //        String res = "";
    //        //res += "   PONTOS: " + totPts + "\r\n";
    //        res += "   EM USO, DUEL:" + duel + "\r\n";
    //        for (int i = 0; i < AIM_STRATS; i++) {
    //            res += "   ESTRATEGIA DE TIRO: " + getStratName(i) + "\r\n";
    //            res += "   acertos: " + Integer.toString(totHits[i]) + "\r\n";
    //            res += "   disparos: " + Integer.toString(totFired[i]) + "\r\n";
    //            if (i == (AIM_STRATS - 1)) {
    //                res += "\r\n";
    //            }
    //        }
    //        res += "   DUEL:" + "\r\n";
    //        for (int i = 0; i < AIM_STRATS; i++) {
    //            res += "   ESTRATEGIA DE TIRO: " + getStratName(i) + "\r\n";
    //            res += "   acertos: " + Integer.toString(duelTotHits[i]) + "\r\n";
    //            res += "   disparos: " + Integer.toString(duelTotFired[i]) + "\r\n";
    //            if (i == (AIM_STRATS - 1)) {
    //                res += "\r\n";
    //            }
    //        }
    //        res += "   MELEE:" + "\r\n";
    //        for (int i = 0; i < AIM_STRATS; i++) {
    //            res += "   ESTRATEGIA DE TIRO: " + getStratName(i) + "\r\n";
    //            res += "   acertos: " + Integer.toString(meleeTotHits[i]) + "\r\n";
    //            res += "   disparos: "
    //                + Integer.toString(meleeTotFired[i])
    //                + "\r\n";
    //            if (i == (AIM_STRATS - 1)) {
    //                res += "\r\n";
    //            }
    //        }
    //        res += "   MOVING:" + "\r\n";
    //        for (int i = 0; i < MOVE_STRATS; i++) {
    //            res += "   ESTRATEGIA DE MOVIMENTO: " + getStratName(i) + "\r\n";
    //            res += "   disparos: " + Integer.toString(moveFired[i]) + "\r\n";
    //            res += "   acertos: " + Integer.toString(moveHited[i]) + "\r\n";
    //            res += "   dano: " + Double.toString(moveDamaged[i]) + "\r\n";
    //            if (i == (MOVE_STRATS - 1)) {
    //                res += "\r\n";
    //            }
    //        }
    //        return res;
    //    }
    public int getAimStrat() {
        return usingAim;
    }
    public int newAimStrat(AxeTarget t) {
        //        double chng = Math.random() * 20;
        //        if (chng < 1) //escolhe randomicamente
        //            {
        //            chng = Math.random() * AIM_STRATS;
        //            //log.println("getAimStrat SORTEOU:"+ getStratName(((int)Math.ceil(chng)-1)) );
        //            return ((int)Math.ceil(chng) - 1);
        //        }
        /*else
        	log.println("getAimStrat sorteio:"+chng);*/
        //if(misses > missesChange)
        usingAim= chooseAimStrat(t);
        return usingAim;
    }
    public boolean goodFire(AxeTarget t) {

        if (HataMoto.getIt().getOthers() > 2) {
            return true;
        }

        double tol= 0.00;
        int ind= getDistInd(t.getDistance());
        int angInd= getAngleInd(t.getAngle());

        double avgPR=
            (double)totHitsPR[usingAim][angInd][ind]
                / (double)totFiredPR[usingAim][angInd][ind];
        double avgTot= this.getBestAllAvg();
        //(double)totHits[usingAim] / (double)totFired[usingAim];
        if (Double.isNaN(avgPR) || Double.isNaN(avgTot)) {
            return true;
        }
        log.println("goodFire:avgPR:" + avgPR + " avgTot:" + avgTot);
        if ((avgPR + tol) >= avgTot) {
            return true;
        } else {
            return false;
        }
    }
    private void resetTots() {
        //log.println(" RRRRREEEEESSSSSEEEEETTTTT !!!! ****" );
        //totPts= 0;
        for (int k= 0; k < AIM_ANGLES_QTD; k++) {
            for (int i= 0; i < AIM_STRATS; i++) {
                duelTotHits[i][k]= 0;
                duelTotFired[i][k]= 0;
                for (int j= 0; j < AIM_RANGES_QTD; j++) {
                    duelTotHitsPR[i][k][j]= 0;
                    duelTotFiredPR[i][k][j]= 0;
                }
            }
            for (int i= 0; i < AIM_STRATS; i++) {
                meleeTotHits[i][k]= 0;
                meleeTotFired[i][k]= 0;
                for (int j= 0; j < AIM_RANGES_QTD; j++) {
                    meleeTotHitsPR[i][k][j]= 0;
                    meleeTotFiredPR[i][k][j]= 0;
                }
            }
        }
        for (int i= 0; i < MOVE_STRATS; i++) {
            moveFired[i]= 0;
            moveHited[i]= 0;
            moveDamaged[i]= 0;
        }
        int totBots= ((HataMoto)HataMoto.getIt()).getTotBots();
        scoring.clear();
        score= new AxeScoreReg(name, totBots);
        score.incRounds();
        scoring.add(score);
        loadDuel(duel);
    }

    public void resetScores() {
        score= new AxeScoreReg(name, totBots);
        score.incRounds();

    }

    public static int getDistInd(double dist) {
        int ind= (int) (dist / Stratego.AIM_RANGES_WIDTH);
        ind= (ind > (AIM_RANGES_QTD - 1)) ? (AIM_RANGES_QTD - 1) : ind;
        return ind;
    }

    public static int getAngleInd(double ang) {
        ang= Math.abs(RoboMath.normalRelativeAngle(ang));
        ang= (ang > 90) ? Math.abs(ang - 180) : ang;

        int ind= (int) (ang / Stratego.AIM_ANGLES_WIDTH);
        return ind;
    }

    private double[] getAimAvgDistArray(AxeTarget t) {
        double[] ret= new double[AIM_STRATS];
        int start;
        int end;
        int[] fires;
        int[] hits;
        double fired;
        double hit;

        double dist= t.getDistance();
        int angInd= this.getAngleInd(t.getAngle());

        double botSz= ((HataMoto)HataMoto.getIt()).getBotDim();
        if (dist <= Stratego.AIM_RANGES_WIDTH) {
            start= getDistInd(0);
            end= getDistInd(Stratego.AIM_RANGES_WIDTH);
        } else if (dist <= Stratego.AIM_RANGES_WIDTH * 2) {
            start= getDistInd(Stratego.AIM_RANGES_WIDTH);
            end= getDistInd(Stratego.AIM_RANGES_WIDTH * 2);
        } else {
            start= getDistInd(Stratego.AIM_RANGES_WIDTH * 2);
            end= getDistInd(botSz * (Stratego.AIM_RANGES_WIDTH * 3));
        }

        for (int i= 0; i < AIM_STRATS; i++) {
            fires= RoboMath.arraySubSet(totFiredPR[i][angInd], start, end);
            fired= RoboMath.getSum(fires);
            hits= RoboMath.arraySubSet(totHitsPR[i][angInd], start, end);
            hit= RoboMath.getSum(hits);
            double avg= hit / fired;
            avg= (Double.isNaN(avg)) ? 0.00 : avg;
            ret[i]= avg;

        }

        return ret;
    }

    public double getAimTotFiredInRange(AxeTarget t) {
        double ret= 0;
        int start;
        int end;
        int[] fires;
        double fired;

        double dist= t.getDistance();
        int angInd= this.getAngleInd(t.getAngle());

        double botSz= ((HataMoto)HataMoto.getIt()).getBotDim();
        if (dist <= Stratego.AIM_RANGES_WIDTH) {
            start= getDistInd(0);
            end= getDistInd(Stratego.AIM_RANGES_WIDTH);
        } else if (dist <= Stratego.AIM_RANGES_WIDTH * 2) {
            start= getDistInd(Stratego.AIM_RANGES_WIDTH);
            end= getDistInd(Stratego.AIM_RANGES_WIDTH * 2);
        } else {
            start= getDistInd(Stratego.AIM_RANGES_WIDTH * 2);
            end= getDistInd(botSz * (Stratego.AIM_RANGES_WIDTH * 3));
        }

        for (int i= 0; i < AIM_STRATS; i++) {
            fires= RoboMath.arraySubSet(totFiredPR[i][angInd], start, end);
            fired= RoboMath.getSum(fires);
            ret += fired;

        }

        return ret;
    }
    private ArrayList getAimAvgHitsInRange(AxeTarget t) {
        double avgs[]= getAimAvgDistArray(t);
        ArrayList ret= new ArrayList();
        for (int i= 0; i < AIM_STRATS; i++) {
            ret.add(new Double(avgs[i]));
        }
        return ret;
    }

    private int chooseAimStrat(AxeTarget t) {
        double minRate= 5.00;

        double totFire= this.getAimTotFiredInRange(t);
        double exp= Math.floor(Math.pow((totFire / (AIM_STRATS * 10)), 2.00));
        exp= (exp > 100) ? 100 : exp;

        ArrayList stratsRates= this.getAimAvgHitsInRange(t);
        // ajusta as chances pelo rate de acerto(%) elevado ao exp
        // seta os componentes do stratsChances como o limitante maximo 
        // do intervalo.
        double edge= 0;
        ArrayList stratsChances= new ArrayList();
        Iterator it= stratsRates.iterator();
        while (it.hasNext()) {
            double chance= ((Double)it.next()).doubleValue();
            chance *= 100.00;
            chance= (chance > minRate) ? chance : minRate;
            chance= Math.pow(chance, exp);
            edge += chance;
            stratsChances.add(new Double(edge));
        }
        double alea= Math.random() * edge;
        //verifica qual strategia foi sorteada
        it= stratsChances.iterator();
        int strat= 0;
        while (it.hasNext()) {
            double stratEdge= ((Double)it.next()).doubleValue();
            if (alea < stratEdge) {
                log.println(
                    "########### CHOOSEN AIM STRATEGY:" + getStratName(strat));
                break;
            }
            strat++;
        }
        return strat;
    }
    //    private int changeAimStrat(double dist) {
    //        misses = 0;
    //        //        if (true)
    //        //            return AIM_MOVEMENT_ESTIMATED;
    //        int ind = getDistInd(dist);
    //        int newStrat = usingAim;
    //        double avgNow = 0;
    //        double avgSearch = 0;
    //        int minFire;
    //        /*if(RoboMath.getSum(totFired)<(30*AIM_STRATS))
    //        {
    //        	
    //        	for(int i=0; i< AIM_STRATS; i++)
    //        	{
    //        		avgSearch = ((double)totHits[i]/(double)totFired[i]);
    //        		//log.println("########### FIRED < 200:"+getStratName(i)+" RATE:"+avgSearch+" FIRED:"+totFired[i]);
    //        		if(totFired[i] < totFired[newStrat] )
    //        			newStrat = i;
    //        	}	
    //        }
    //        else*/
    //        for (int i = 0; i < AIM_STRATS; i++) {
    //            avgSearch = (double)totHitsPR[i][ind] / (double)totFiredPR[i][ind];
    //            if (Double.isNaN(avgSearch)) {
    //                avgSearch = 0;
    //            }
    //            /*
    //            avgNow = (((double)totHits[newStrat]+1)/(double)totFired[newStrat] );
    //            avgSearch = (((double)totHits[i]+1)/(double)totFired[i]);
    //            */
    //            //log.println(getStratName(i)+" RATE:"+avgSearch+" FIRED:"+totFired[i]+" avgNow:"+avgNow);
    //            minFire = (int) (totFired[i] * 0.05);
    //            if (totFiredPR[i][ind] < minFire) {
    //                newStrat = i;
    //                break;
    //            } else if (avgNow < avgSearch) {
    //                newStrat = i;
    //                avgNow = avgSearch;
    //                //log.println("# BEST STRATEGY:"+getStratName(newStrat));
    //            }
    //            //fired[i] = 0;
    //        }
    //        //avgNow = (((double)totHits[newStrat]+1)/(double)totFired[newStrat] );
    //        //log.println("########### CHANGING STRATEGY TO:"+getStratName(newStrat)+" RATE:"+avgNow+" totFired:"+(double)totFired[newStrat]);
    //        return newStrat;
    //        //reset();
    //    }
    public void missed(BulletTracker bt) {
        int ind= getDistInd(bt.getTargetDist());
        int angInd= this.getAngleInd(bt.getFacingAngle());
        //fired[bt.getAimMethod()]++;
        misses++;
        targMissesOnARow++;
        totFired[bt.getAimMethod()][angInd]++;
        totFiredPR[bt.getAimMethod()][angInd][ind]++;
        /*if(bt.getAimMethod()==using)
        {
        	if(misses >= missesChange)
        		changeStrat();
        }*/
    }
    public void hit(BulletTracker bt) {
        int ind= getDistInd(bt.getTargetDist());
        int angInd= this.getAngleInd(bt.getFacingAngle());
        //hits[bt.getAimMethod()]++;
        //fired[bt.getAimMethod()]++;
        misses= 0;
        targMissesOnARow= 0;
        totHits[bt.getAimMethod()][angInd]++;
        totFired[bt.getAimMethod()][angInd]++;
        totHitsPR[bt.getAimMethod()][angInd][ind]++;
        totFiredPR[bt.getAimMethod()][angInd][ind]++;
    }
    /*public  int getHits(int strat)
    {
    	return hits[strat];
    }
    
    public  int getFired(int strat)
    {
    	return fired[strat];
    }  
    
    public  int getTotHits(int strat)
    {
    	return hits[strat];
    }
    
    public  int getTotFired(int strat)
    {
    	return fired[strat];
    }*/
    private void changeDuel(boolean d) {
        //saveDuel(!d);
        loadDuel(d);
    }
    //    private void saveDuel(boolean d) {
    //        if (d) {
    //            duelTotHits= totHits;
    //            duelTotFired= totFired;
    //            duelTotHitsPR= totHitsPR;
    //            duelTotFiredPR= totFiredPR;
    //        } else {
    //            meleeTotHits= totHits;
    //            meleeTotFired= totFired;
    //            meleeTotHitsPR= totHitsPR;
    //            meleeTotFiredPR= totFiredPR;
    //        }
    //
    //    }
    private void loadDuel(boolean d) {
        if (d) {
            totHits= duelTotHits;
            totFired= duelTotFired;
            totHitsPR= duelTotHitsPR;
            totFiredPR= duelTotFiredPR;
        } else {
            totHits= meleeTotHits;
            totFired= meleeTotFired;
            totHitsPR= meleeTotHitsPR;
            totFiredPR= meleeTotFiredPR;
        }
    }
    //    public void save() {
    //        String dataFileName= STAT_FILE_PREFIX + name + STAT_FILE_EXTENSION;
    //        log.println(" saving " + dataFileName);
    //        try {
    //            PrintStream w=
    //                ((HataMoto)HataMoto.getIt()).getPrintStream(dataFileName);
    //            //                new PrintStream(
    //            //                    new RobocodeFileOutputStream(
    //            //                        HataMoto.getIt().getDataFile(dataFileName)));
    //            int totScores= scoring.size();
    //            w.println(totScores);
    //            Iterator it= scoring.iterator();
    //            while (it.hasNext()) {
    //                AxeScoreReg scoreReg= (AxeScoreReg)it.next();
    //                w.print(scoreReg.getBots() + TOKEN_DOIS_PONTOS);
    //                w.print(scoreReg.getRounds() + TOKEN_DOIS_PONTOS);
    //                w.print(scoreReg.getScore() + TOKEN_DOIS_PONTOS);
    //                w.print(scoreReg.getDamage() + TOKEN_DOIS_PONTOS);
    //                w.println();
    //            }
    //            w.println(AIM_STRATS);
    //            w.println(AIM_RANGES_QTD);
    //            for (int i= 0; i < AIM_STRATS; i++) {
    //                //w.print(this.getStratName(i) + TOKEN_DOIS_PONTOS);
    //                w.print(duelTotHits[i] + TOKEN_BARRA_DIVISAO);
    //                w.print(duelTotFired[i] + TOKEN_DOIS_PONTOS);
    //                for (int j= 0; j < AIM_RANGES_QTD; j++) {
    //                    w.print(duelTotHitsPR[i][j] + TOKEN_BARRA_DIVISAO);
    //                    w.print(duelTotFiredPR[i][j] + TOKEN_DOIS_PONTOS);
    //                }
    //                w.println();
    //            }
    //            for (int i= 0; i < AIM_STRATS; i++) {
    //                //w.print(this.getStratName(i) + TOKEN_DOIS_PONTOS);
    //                w.print(meleeTotHits[i] + TOKEN_BARRA_DIVISAO);
    //                w.print(meleeTotFired[i] + TOKEN_DOIS_PONTOS);
    //                for (int j= 0; j < AIM_RANGES_QTD; j++) {
    //                    w.print(meleeTotHitsPR[i][j] + TOKEN_BARRA_DIVISAO);
    //                    w.print(meleeTotFiredPR[i][j] + TOKEN_DOIS_PONTOS);
    //                }
    //                w.println();
    //            }
    //            w.println(MOVE_STRATS);
    //            for (int i= 0; i < MOVE_STRATS; i++) {
    //                //w.print(this.getMoveStratName(i) + TOKEN_DOIS_PONTOS);
    //                w.print(moveFired[i] + TOKEN_DOIS_PONTOS);
    //                w.print(moveHited[i] + TOKEN_DOIS_PONTOS);
    //                w.print(moveDamaged[i] + TOKEN_DOIS_PONTOS);
    //                w.println();
    //            }
    //            // PrintStreams don't throw IOExceptions during prints,
    //            // they simply set a flag.... so check it here.
    //            if (w.checkError()) {
    //                HataMoto.getIt().out.println("I could not write the count!");
    //            }
    //            w.close();
    //        } catch (IOException e) {
    //            HataMoto.getIt().out.println("IOException trying to write: " + e);
    //        }
    //    }

    private int getTotFiredMelee() {
        int tot= 0;
        for (int i= 0; i < meleeTotFired.length; i++) {
            for (int j= 0; j < meleeTotFired[i].length; j++) {
                tot += meleeTotFired[i][j];
            }

        }
        return tot;
    }

    private int getTotFiredDuel() {
        int tot= 0;
        for (int i= 0; i < duelTotFired.length; i++) {
            for (int j= 0; j < duelTotFired[i].length; j++) {
                tot += duelTotFired[i][j];
            }

        }
        return tot;
    }

    public void saveData() {
        //((HataMoto)HataMoto.getIt()).cleanDir();
        String dataFileName= STAT_FILE_PREFIX + name + STAT_FILE_EXTENSION;
        //log.println(" saving " + dataFileName);

        try {
            DataOutputStream w=
                ((HataMoto)HataMoto.getIt()).getDataOutputStream(dataFileName);
            //                new PrintStream(
            //                    new RobocodeFileOutputStream(
            //                        HataMoto.getIt().getDataFile(dataFileName)));
            int totScores= scoring.size();
            w.writeByte(totScores);
            //Iterator it= scoring.iterator();
            //while (it.hasNext()) {
            //AxeScoreReg scoreReg= (AxeScoreReg)it.next();
            w.writeByte(score.getBots());
            w.writeInt((int)score.getRounds());
            w.writeInt((int)score.getScore());
            w.writeInt((int)score.getDamage());
            //}
            w.writeByte(AIM_STRATS);
            w.writeByte(AIM_ANGLES_QTD);
            w.writeByte(AIM_RANGES_QTD);
            boolean existMelee= (this.getTotFiredMelee() > 0);
            w.writeBoolean(existMelee);

            for (int k= 0; k < AIM_ANGLES_QTD; k++) {
                for (int i= 0; i < AIM_STRATS; i++) {
                    //w.print(this.getStratName(i) + TOKEN_DOIS_PONTOS);
                    //w.writeInt(duelTotHits[i] + TOKEN_BARRA_DIVISAO);
                    //w.print(duelTotFired[i] + TOKEN_DOIS_PONTOS);
                    for (int j= 0; j < AIM_RANGES_QTD; j++) {
                        if (duelTotFiredPR[i][k][j] > Short.MAX_VALUE) {
                            duelTotFiredPR[i][k][j]= Short.MAX_VALUE;
                            duelTotHitsPR[i][k][j] *= Short.MAX_VALUE
                                / (int)duelTotFiredPR[i][k][j];
                        }
                        w.writeShort((short)duelTotHitsPR[i][k][j]);
                        w.writeShort((short)duelTotFiredPR[i][k][j]);
                    }
                    //w.println();
                }
                if (existMelee) {

                    for (int i= 0; i < AIM_STRATS; i++) {
                        //w.print(this.getStratName(i) + TOKEN_DOIS_PONTOS);
                        //w.print(meleeTotHits[i] + TOKEN_BARRA_DIVISAO);
                        //w.print(meleeTotFired[i] + TOKEN_DOIS_PONTOS);
                        for (int j= 0; j < AIM_RANGES_QTD; j++) {
                            if (meleeTotFiredPR[i][k][j] > Short.MAX_VALUE) {
                                meleeTotFiredPR[i][k][j]= Short.MAX_VALUE;
                                meleeTotHitsPR[i][k][j] *= Short.MAX_VALUE
                                    / (int)meleeTotFiredPR[i][k][j];
                            }
                            w.writeShort((short)meleeTotHitsPR[i][k][j]);
                            w.writeShort((short)meleeTotFiredPR[i][k][j]);
                        }
                        //w.println();
                    }
                }
            }
            w.writeByte(MOVE_STRATS);
            for (int i= 0; i < MOVE_STRATS; i++) {
                //w.print(this.getMoveStratName(i) + TOKEN_DOIS_PONTOS);
                if (moveDamaged[i] > Short.MAX_VALUE) {
                    moveDamaged[i]= Short.MAX_VALUE;
                    moveFired[i] *= Short.MAX_VALUE / (int)moveDamaged[i];
                    moveHited[i] *= Short.MAX_VALUE / (int)moveDamaged[i];
                }

                if (moveFired[i] > Short.MAX_VALUE) {
                    moveFired[i]= Short.MAX_VALUE;
                    moveDamaged[i] *= Short.MAX_VALUE / (int)moveFired[i];
                    moveHited[i] *= Short.MAX_VALUE / (int)moveFired[i];
                }

                if (moveHited[i] > Short.MAX_VALUE) {
                    moveHited[i]= Short.MAX_VALUE;
                    moveDamaged[i] *= Short.MAX_VALUE / (int)moveHited[i];
                    moveFired[i] *= Short.MAX_VALUE / (int)moveHited[i];
                }

                w.writeShort((short)moveFired[i]);
                w.writeShort((short)moveHited[i]);
                w.writeShort((short)moveDamaged[i]);
                //w.println();
            }
            // PrintStreams don't throw IOExceptions during prints,
            // they simply set a flag.... so check it here.

            w.close();
        } catch (IOException e) {
            HataMoto.getIt().out.println("IOException trying to write: " + e);
        }
    }

    //    public void load(File f) {
    //        //int firingTypeCount;
    //        BufferedReader r= null;
    //        //String dataFileName= STAT_FILE_PREFIX + name + STAT_FILE_EXTENSION;
    //        String linha= null;
    //        String item= null;
    //        StringTokenizer st= null;
    //        StringTokenizer st2= null;
    //        try {
    //            r= new BufferedReader(new FileReader(f));
    //
    //            int totScores= Integer.parseInt(r.readLine());
    //            for (int i= 0; i < totScores; i++) {
    //                linha= r.readLine();
    //                st= new StringTokenizer(linha, TOKEN_DOIS_PONTOS);
    //                AxeScoreReg scoreReg=
    //                    new AxeScoreReg(
    //                        name,
    //                        st.nextToken(),
    //                        st.nextToken(),
    //                        st.nextToken(),
    //                        st.nextToken());
    //                //scoreReg.incRounds();
    //                if (scoreReg.getBots() == totBots) {
    //                    score= scoreReg;
    //                    score.incRounds();
    //                }
    //                scoring.add(scoreReg);
    //                //}
    //            }
    //            if (score == null && (totBots != 0)) {
    //                score= new AxeScoreReg(name, totBots);
    //                score.incRounds();
    //            }
    //            //scoring.add(score);
    //            int totStrats= Integer.parseInt(r.readLine());
    //            if (totStrats != AIM_STRATS) {
    //                r.close();
    //                resetTots();
    //                //				initialise();
    //                return;
    //            }
    //            int totRanges= Integer.parseInt(r.readLine());
    //            if (totRanges != AIM_RANGES_QTD) {
    //                r.close();
    //                resetTots();
    //                //				initialise();
    //                return;
    //            }
    //            for (int i= 0; i < AIM_STRATS; i++) {
    //                linha= r.readLine();
    //                st= new StringTokenizer(linha, TOKEN_DOIS_PONTOS);
    //                //item = st.nextToken();
    //                item= st.nextToken();
    //                st2= new StringTokenizer(item, TOKEN_BARRA_DIVISAO);
    //                duelTotHits[i]= Integer.parseInt(st2.nextToken());
    //                duelTotFired[i]= Integer.parseInt(st2.nextToken());
    //                for (int j= 0; j < AIM_RANGES_QTD; j++) {
    //                    item= st.nextToken();
    //                    st2= new StringTokenizer(item, TOKEN_BARRA_DIVISAO);
    //                    duelTotHitsPR[i][j]= Integer.parseInt(st2.nextToken());
    //                    duelTotFiredPR[i][j]= Integer.parseInt(st2.nextToken());
    //                }
    //            }
    //            for (int i= 0; i < AIM_STRATS; i++) {
    //                linha= r.readLine();
    //                st= new StringTokenizer(linha, TOKEN_DOIS_PONTOS);
    //                //item = st.nextToken();
    //                item= st.nextToken();
    //                st2= new StringTokenizer(item, TOKEN_BARRA_DIVISAO);
    //                meleeTotHits[i]= Integer.parseInt(st2.nextToken());
    //                meleeTotFired[i]= Integer.parseInt(st2.nextToken());
    //                for (int j= 0; j < AIM_RANGES_QTD; j++) {
    //                    item= st.nextToken();
    //                    st2= new StringTokenizer(item, TOKEN_BARRA_DIVISAO);
    //                    meleeTotHitsPR[i][j]= Integer.parseInt(st2.nextToken());
    //                    meleeTotFiredPR[i][j]= Integer.parseInt(st2.nextToken());
    //                }
    //            }
    //            loadDuel(duel);
    //            int totMOVE_STRATS= Integer.parseInt(r.readLine());
    //            if (totMOVE_STRATS != MOVE_STRATS) {
    //                r.close();
    //                resetTots();
    //                //							initialise();
    //                return;
    //            }
    //            for (int i= 0; i < MOVE_STRATS; i++) {
    //                linha= r.readLine();
    //                st= new StringTokenizer(linha, TOKEN_DOIS_PONTOS);
    //                //item = st.nextToken();
    //                item= st.nextToken();
    //                moveFired[i]= Integer.parseInt(item);
    //                item= st.nextToken();
    //                moveHited[i]= Integer.parseInt(item);
    //                item= st.nextToken();
    //                moveDamaged[i]= Double.parseDouble(item);
    //            }
    //        } catch (Throwable e) {
    //            log.println(" loading failed:" + e.getMessage());
    //            try {
    //                r.close();
    //            } catch (Throwable e2) {};
    //            resetTots();
    //            // Something went wrong reading the file, Start from scratch
    //            //			initialise();
    //        }
    //    }

    public void loadData(File f) {
        //int firingTypeCount;
        DataInputStream r= null;

        //String dataFileName= STAT_FILE_PREFIX + name + STAT_FILE_EXTENSION;
        String linha= null;
        String item= null;
        StringTokenizer st= null;
        StringTokenizer st2= null;
        try {
            r= new DataInputStream(new FileInputStream(f));

            int totScores= r.readByte();
            for (int i= 0; i < totScores; i++) {
                //linha= r.readLine();
                //st= new StringTokenizer(linha, TOKEN_DOIS_PONTOS);
                AxeScoreReg scoreReg=
                    new AxeScoreReg(
                        name,
                        Byte.toString(r.readByte()),
                        Integer.toString(r.readInt()),
                        Integer.toString(r.readInt()),
                        Integer.toString(r.readInt()));
                //scoreReg.incRounds();
                if (scoreReg.getBots() == totBots) {
                    score= scoreReg;
                    score.incRounds();
                }
                scoring.add(scoreReg);
                //}
            }
            if (score == null && (totBots != 0)) {
                score= new AxeScoreReg(name, totBots);
                score.incRounds();
            }
            //scoring.add(score);
            int totStrats= r.readByte();
            if (totStrats != AIM_STRATS) {
                r.close();
                resetTots();
                //				initialise();
                return;
            }

            int totAngs= r.readByte();
            if (totAngs != AIM_ANGLES_QTD) {
                r.close();
                resetTots();
                //				initialise();
                return;
            }

            int totRanges= r.readByte();
            if (totRanges != AIM_RANGES_QTD) {
                r.close();
                resetTots();
                //				initialise();
                return;
            }

            boolean existMelee = r.readBoolean();

            for (int k= 0; k < AIM_ANGLES_QTD; k++) {
                for (int i= 0; i < AIM_STRATS; i++) {
                    for (int j= 0; j < AIM_RANGES_QTD; j++) {
                        duelTotHitsPR[i][k][j]= r.readShort();
                        duelTotFiredPR[i][k][j]= r.readShort();
                    }
                }
                if (existMelee) {

                    for (int i= 0; i < AIM_STRATS; i++) {
                        for (int j= 0; j < AIM_RANGES_QTD; j++) {
                            meleeTotHitsPR[i][k][j]= r.readShort();
                            meleeTotFiredPR[i][k][j]= r.readShort();
                        }
                    }
                }
            }

            int totMOVE_STRATS= r.readByte();
            if (totMOVE_STRATS != MOVE_STRATS) {
                r.close();
                resetTots();
                //							initialise();
                return;
            }
            for (int i= 0; i < MOVE_STRATS; i++) {
                moveFired[i]= r.readShort();
                moveHited[i]= r.readShort();
                moveDamaged[i]= r.readShort();
            }

            this.makeTots();
            this.loadDuel(duel);

        } catch (Throwable e) {
            log.println(" loading failed:" + e.getMessage());
            try {
                r.close();
            } catch (Throwable e2) {};
            resetTots();
            // Something went wrong reading the file, Start from scratch
            //			initialise();
        }
    }

    private void makeTots() {
        for (int k= 0; k < AIM_ANGLES_QTD; k++) {
            for (int i= 0; i < AIM_STRATS; i++) {
                meleeTotHits[i][k]= 0;
                meleeTotFired[i][k]= 0;
                duelTotHits[i][k]= 0;
                duelTotFired[i][k]= 0;
                for (int j= 0; j < AIM_RANGES_QTD; j++) {
                    meleeTotHits[i][k] += meleeTotHitsPR[i][k][j];
                    meleeTotFired[i][k] += meleeTotFiredPR[i][k][j];
                    duelTotHits[i][k] += duelTotHitsPR[i][k][j];
                    duelTotFired[i][k] += duelTotFiredPR[i][k][j];
                }
            }
        }
    }

    /**
     * @return
     */
    public AxeScoreReg getScore() {
        return score;
    }
    public ArrayList getAllScores() {
        return scoring;
    }
    public ArrayList getMovings() {
        ArrayList ret= new ArrayList();
        for (int i= 0; i < Stratego.MOVE_STRATS; i++) {
            ret.add(
                new AxeMovingStrats(
                    this.getMoveStratName(i),
                    this.moveFired[i],
                    this.moveHited[i],
                    this.moveDamaged[i]));
        }
        Collections.sort(ret);
        return ret;
    }
    /**
     * @return
     */
    public String getName() {
        return name;
    }

    /**
     * @param string
     */
    public void setName(String string) {
        name= string;
    }

}