package dft.bin;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

import robocode.*;

public class COBOL {

	//private static final int TOTAL_FACTORS = 25;
	//private static final int MIDDLE_FACTOR = 12;
	DangerAnalysis a = new DangerAnalysis();
	
	private AdvancedRobot robot;
	private int orbitDirection = 1;
	
	private static Buffer HOT = new Buffer(19);
	private static Buffer LT = new Buffer(17);
	private static Buffer allHits = new Buffer(25);
	private static Buffer allWaves = new Buffer(31);
	private static Buffer patternHits = new Buffer(25);
	private static Buffer recentHits = new Buffer(25);
	private static Buffer recentSegmentHits = new Buffer(25);
		
	public COBOL() {
		double[] HOTarray = HOT.getCurrentBucket(new int[] {});
		HOTarray[9]=0.6;
		HOTarray[10]=0.15;
		HOTarray[8]=0.15;
		HOTarray[11]=0.05;
		HOTarray[7]=0.05;
		double[] AHarray = allHits.getCurrentBucket(new int[] {});
		AHarray[12]=0.6;
		AHarray[13]=0.15;
		AHarray[11]=0.15;
		AHarray[14]=0.05;
		AHarray[10]=0.05;
		for (int i = 0; i < 6; i++) {			
			double[] LTarray = LT.getCurrentBucket(new int[] {i});			
			LTarray[7+i]=0.2;
			LTarray[8+i]=0.2;
			LTarray[9+i]=0.5;
			LTarray[10+i]=0.4;
			LTarray[Math.min(16,11+i)]=0.2;	
				
		}
	}
	

	private WaveManager surfable = new WaveManager();
	
	public void think(WaveManager waves, State s, Log log) {		
			
		robot = s.getRobot();
		ReducedState p = log.get(-1);
				
		double energyChange = p.getEnemyEnergy()-s.getEnemyEnergy();
				
		
		
		if (robot.getOthers()>0) {
		
			if (((s.getEnemyGunHeat()<-0.5&&s.getEnemyEnergy()>3.0)||
					(energyChange<=3&&energyChange>0))&&waves.size()>=2) {
				//System.out.println("X");
				s.setLastBulletPower(energyChange);
				// Reset the fired enemy wave to account for the appropriate bullet power
				
				MoveWave wReal = new MoveWave();
				MoveWave w = (MoveWave)waves.get(waves.size()-2);
				wReal.real = w.real = true;
				wReal.bulletPower = w.bulletPower = s.getLastBulletPower();				
				wReal.velocity = w.velocity = 20-3*wReal.bulletPower;
				wReal.waveLocation = wReal.waveOrigin = w.waveLocation = w.waveOrigin;
				wReal.targetLocation = w.targetLocation;
				wReal.angle = w.angle;
				s.setLastBulletFireTime(wReal.lastTime = wReal.fireTime = w.lastTime = w.fireTime);
				wReal.escapeEnvelope = w.escapeEnvelope = Utils.escapeEnvelope(((ReducedState)log.get(-2)).getRobotDirection(),wReal.velocity);						
				wReal.realBuffers = w.realBuffers;
				wReal.buffers = w.buffers;
				wReal.delay = w.velocity*3.0;
				wReal.probability = 1.0;
				if (s.getEnemyGunHeat()>0.0||s.getEnemyGunHeat()<-0.5)
					wReal.probability = 0.25;
				w.probability = wReal.probability;
				s.updateGunHeat(s.getLastBulletPower());
				surfable.add(wReal);
				
			}
			MoveWave w = new MoveWave();			
			w = new MoveWave();
			w.targetLocation = Utils.project(s.getRobotLocation(),0,0);
			w.waveOrigin = w.waveLocation = Utils.project(s.getEnemyLocation(),0,0);
			w.angle = s.getOppAbsBearing();
			w.bulletPower = s.getLastBulletPower();
			w.velocity = 20-3*w.bulletPower;
			w.lastTime = w.fireTime = s.getRobot().getTime();
			w.escapeEnvelope = Utils.escapeEnvelope(s.getRobotDirection(),w.velocity);
			
			double wallDistance = 1.0;
			for (; wallDistance >= 0;wallDistance-=0.25) {
				if (s.battleField.contains(
						Utils.project(s.getEnemyLocation(), 
								s.getOppAbsBearing() + wallDistance*w.escapeEnvelope, 
								s.getEnemyDistance())))
					break;
			}
			
			double reverseWallDistance = 1.0;
			for (; reverseWallDistance >= 0; reverseWallDistance-=0.5) {
				if (s.battleField.contains(
						Utils.project(s.getEnemyLocation(), 
								s.getOppAbsBearing() - reverseWallDistance*w.escapeEnvelope, 
								s.getEnemyDistance())))
					break;
			}
			int reverseWallIndex = (int)(reverseWallDistance*2);
			int lateralVelocityIndex = (int)Math.abs(s.getRobotLateralVelocity()/2.0);
			int velocityIndex = (int)Math.abs(robot.getVelocity()/2.01);
			int wallIndex = (int)(wallDistance*4);
			int distanceIndex = (int)s.getEnemyDistance()/200;
			int accelIndex = (int)Math.round(Math.abs(robot.getVelocity()) - Math.abs(p.getRobotVelocity()));
			if (accelIndex != 0) {
				accelIndex = accelIndex < 0 ? 2 : 1;
			}	
			
			int fmDistance = (int)(s.getEnemyDistance()/10/(20-3*Math.min(Math.min(s.getEnemyEnergy(), robot.getEnergy())/4, 3)));
			double fmLVHelper = p.getRobotVelocity()*Math.sin(robot.getHeadingRadians()-s.getOppAbsBearing()); 
			int fmLatVel = (int)Math.abs(fmLVHelper/3);
			int fmAccel = accelIndex;
			int fmWalls = s.battleField.contains(Utils.project(s.getRobotLocation(),robot.getHeadingRadians(),(s.getRobotVelocity() < 0) ? -80 : 80))?0:1;
			
			//System.out.println(robot.getTime()+""+fmWalls+""+fmAccel+""+fmLatVel+""+fmDistance);
			
				
			
			w.buffers = new ArrayList();
			double[] fmSegment = allWaves.getCurrentBucket(new int[] {fmWalls,fmAccel,fmLatVel,fmDistance});
			if (robot.getTime()>=10&&robot.getOthers()>0)
				w.buffers.add(allWaves.getCurrentBucket(new int[] {fmWalls,fmAccel,fmLatVel,fmDistance}));
			
			//w.buffers.add(LT.getCurrentBucket(new int[] {(int)Math.abs(s.getRobotLateralVelocity()/1.33)}));
			w.realBuffers = new ArrayList();
			w.surf = new double[31];
			int bestIndex = 15;
			for (int i = 1; i < fmSegment.length; i++) {
				w.surf[i] = fmSegment[i];
				
			}
			//System.out.println(bestIndex);
			//w.surf[bestIndex] = 1.0;
			//w.realBuffers.add(w.surf);
			//w.realBuffers.add(HOT.getCurrentBucket(new int[] {}));
			//w.realBuffers.add(allHits.getCurrentBucket(new int[] {fmWalls,fmAccel,fmLatVel,fmDistance}));
			w.realBuffers.add(allHits.getCurrentBucket(new int[] {}));
			w.realBuffers.add(allHits.getCurrentBucket(new int[] {velocityIndex}));
			w.realBuffers.add(allHits.getCurrentBucket(new int[] {wallIndex,reverseWallIndex}));
			w.realBuffers.add(allHits.getCurrentBucket(new int[] {velocityIndex,accelIndex}));	
			w.realBuffers.add(allHits.getCurrentBucket(new int[] {velocityIndex,accelIndex,distanceIndex}));
			w.realBuffers.add(allHits.getCurrentBucket(new int[] {velocityIndex,accelIndex,distanceIndex,wallIndex}));
			w.realBuffers.add(allHits.getCurrentBucket(new int[] {velocityIndex,accelIndex,distanceIndex,wallIndex,reverseWallIndex}));
			//w.realBuffers.add(allHits.getCurrentBucket(new int[] {accelIndex,distanceIndex,lateralVelocityIndex,wallIndex,reverseWallIndex}));
			//w.realBuffers.add(allHits.getCurrentBucket(new int[] {velocityIndex,lateralVelocityIndex,wallIndex}));
			//w.realBuffers.add(allHits.getCurrentBucket(new int[] {velocityIndex,lateralVelocityIndex,wallIndex,reverseWallIndex}));
			waves.add(w);
		
		}
		
		surfable.update(s);
		
		double targetAngle = Math.PI/2+Math.PI/10;
		
		a.clear();
		
		a.add(new Position(s.getRobotLocation(),robot.getHeadingRadians(),robot.getVelocity()));
		a.add(new Position(s.getRobotLocation(),robot.getHeadingRadians(),robot.getVelocity()));
		a.add(new Position(s.getRobotLocation(),robot.getHeadingRadians(),robot.getVelocity()));
		
		int maxTicks = 1;
		if (surfable.size()>0) {
			MoveWave b = (MoveWave)surfable.get(Math.min(1,surfable.size()-1));
			maxTicks = (int)(b.waveLocation.distance(s.getRobotLocation())/b.velocity)+2;			
		}
		else 
			maxTicks = 4;
		
		for (int ticks = 1; ticks < maxTicks; ticks++) {
			a.updatePosition(0,s.getEnemyLocation(),8,targetAngle,orbitDirection,s.battleField,false);
			a.updatePosition(1,s.getEnemyLocation(),8,targetAngle,-orbitDirection,s.battleField,false);
			a.updatePosition(2,s.getEnemyLocation(),0,targetAngle,orbitDirection,s.battleField,false);			
				
			
			int numWaves = Math.min(2,surfable.size());
			for (int i = 0; i < numWaves; i++) {				
				MoveWave b = (MoveWave)surfable.get(i);	
				
				//if (ticks==1) System.out.println(b.waveOrigin);
				
				//ArrayList buffers = new ArrayList();
				//buffers.add(HOT.getCurrentBucket(new int[]{}));
				for (int j = 0; j < a.size(); j++) {
					a.updateScore(j,b,ticks,b.realBuffers);
				}		
				
				
			}		
			
		}
		
		boolean smoothAway = false;
		robot.setMaxVelocity(8);
		if (s.getEnemyDistance()<100&&Math.PI/2-Math.abs(Math.PI/2-Math.abs(s.getEnemyBearing())) < Math.PI/4) {
			smoothAway = true;
			targetAngle = -Math.PI;
			//System.out.println("EMERGENCY...");
			if (Math.abs(robot.getVelocity())> 2 && a.getPosition(1).getLocation().distance(s.getEnemyLocation()) < s.getEnemyDistance()) {
				orbitDirection = -orbitDirection;
				//System.out.println("     Reverse...");
			}
		}
		else if (Math.abs(robot.getVelocity())==8&&s.getEnemyDistance() < 200 && a.getPosition(1).getLocation().distance(s.getEnemyLocation()) < s.getEnemyDistance() && Math.PI/2-Math.abs(Math.PI/2-Math.abs(s.getEnemyBearing())) < Math.PI/4) {
			orbitDirection = -orbitDirection;
			//System.out.println("Reversing...");
		}		
		else if (a.getScore(1)<a.getScore(0)&&a.getScore(1)<a.getScore(2)
						/*&&a.getScore(1)<a.getScore(3)*///||
						/*(a.getScore(1)==0.0&&Math.abs(robot.getVelocity())==8
						&&a.getPosition(1).getLocation().distance(s.getEnemyMirrorPosition())<
						a.getPosition(1).getLocation().distance(s.getEnemyLocation()))*/) {							
			orbitDirection = -orbitDirection;
		}
		//else if (a.getScore(3)<=a.getScore(2)&&a.getScore(3)<=a.getScore(1)) {
		//	smoothAway = true;
		//}
		else if (surfable.size()==0&&robot.getTime()<=26) {
			targetAngle = Math.PI;
		}
		else if (a.getScore(2)<a.getScore(0)) {
			if (s.getEnemyDistance()>250||a.getScore(2)<a.getScore(0))
				robot.setMaxVelocity(0);
		}
				
		//System.out.println(a.getScore(0) + " " + a.getScore(1) + " " + a.getScore(2));

		double finalTurn = Utils.wallSmoothedAngle(s.getRobotLocation(),s.getAbsBearing(),targetAngle,s.getRobot().getHeadingRadians(),orbitDirection,smoothAway);
		//if (Utils.project(s.getRobotLocation(),robot.getHeadingRadians()+Math.tan(finalTurn),100).distance(s.getEnemyLocation())<80) {
		//	finalTurn = Utils.wallSmoothedAngle(s.getRobotLocation(),s.getAbsBearing(),-targetAngle,s.getRobot().getHeadingRadians(),orbitDirection);
		//}
		robot.setAhead(Math.cos(finalTurn)*100);
		robot.setTurnRightRadians(Math.tan(finalTurn));
		
		//if (!s.battleField.contains(Utils.project(s.getRobotLocation(), robot.getHeadingRadians(), robot.getVelocity()*3.25))) robot.setAhead(0);
		//if (!s.battleField.contains(Utils.project(s.getRobotLocation(), robot.getHeadingRadians(), robot.getVelocity()*5))) robot.setAhead(4);
		
	}
	
	public void onBulletHitBullet(BulletHitBulletEvent e) {
		// If my bullet hits your bullet
		//System.out.print("BHB at GF ");
		for (int i = 0; i < surfable.size(); i++) {
			Point2D theBullet = new Point2D.Double(e.getHitBullet().getX(),e.getHitBullet().getY());
			MoveWave w = (MoveWave)surfable.get(i);
			double currentDistance = w.waveLocation.distance(w.waveOrigin);			
			double GF = Utils.getGF(Utils.normalRelativeAngle(
					Utils.absoluteBearing(w.waveOrigin,theBullet)-w.angle),
					w.escapeEnvelope);
			double myDistance = theBullet.distance(w.waveOrigin);
			// Make sure we've got the right bullet and a reasonable angle
			if (Math.abs(myDistance-currentDistance) < 40) {
				//System.out.print(GF + ": " + w.probability);
				w.increment(GF,true);
				surfable.remove(i);
				break;
			}
		}
		//System.out.println();
		
	}
	
	public void onHitByBullet(HitByBulletEvent e) {
		//System.out.print("HIT at GF ");
		for (int i = 0; i < surfable.size(); i++) {
			Point2D theBullet = new Point2D.Double(e.getBullet().getX(),e.getBullet().getY());
			MoveWave w = (MoveWave)surfable.get(i);
			//double currentDistance = Utils.findDistance(b.current,b.start);			
			double GF = Utils.getGF(Utils.normalRelativeAngle(
					Utils.absoluteBearing(w.waveOrigin,theBullet)-w.angle),
					w.escapeEnvelope);	
			// Update with the correct bullet
			double currentDistance = w.waveOrigin.distance(w.waveLocation);			
			double myDistance = theBullet.distance(w.waveOrigin);
			if (Math.abs(myDistance-currentDistance) < 40) {	
				w.increment(GF,true);
				//System.out.print(GF + ": " + w.probability);
				break;
			}
		}		
		//System.out.println();
	}
	
		
	public void onPaint(java.awt.Graphics g) {
		
		for (int i = 0; i < a.size(); i++) {
			Point2D p = a.getPosition(i).getLocation();
			g.setColor(Color.gray);
			g.drawOval((int)(p.getX()-4),(int)(p.getY()-4),8,8);
			g.drawString(a.getScore(i)+"",(int)(p.getX()+10),(int)(p.getY()));
			 
		}
		
		for (int i = 0; i < surfable.size();i++) {
			MoveWave w = (MoveWave)surfable.get(i);
			//if (w.real) {
				Point2D p = w.waveLocation;
				if (i < 2)
					g.setColor(Color.green);
				else
					g.setColor(Color.gray);
				int radius=(int)p.distance(w.waveOrigin);	
				//g.drawOval((int)(w.waveOrigin.getX()-4),(int)(w.waveOrigin.getY()-4),8,8); 
				g.drawOval((int)(w.waveOrigin.getX()-radius),(int)(w.waveOrigin.getY()-radius),
						radius*2,radius*2);
				//g.setColor(Color.red);
				//g.drawOval((int)(p.getX()-2),(int)(p.getY()-2),4,4); 
				//g.drawString(w.probability+"",(int)(p.getX()+20),(int)(p.getY()-2));
				/*for (int j = 0; j < 51; j++) {
					Point2D l = Utils.project(w.waveOrigin,w.angle+((j/25.0)-1)*w.escapeEnvelope,w.waveOrigin.distance(w.waveLocation));
					g.setColor(Color.yellow);
					g.drawOval((int)(l.getX()-2),(int)(600-l.getY()-2),4,4); 
				}*/
				double[] val = (double[])w.realBuffers.get(0);
				for (int j = 1; j < val.length; j++) {
					p = Utils.project(w.waveOrigin,w.angle+(j-(val.length-1)/2)/(double)((val.length-1)/2)*w.escapeEnvelope,radius);
					int size = 2;
					if (val[j]==0) g.setColor(Color.green);
					else if (val[j]<0.075) g.setColor(new Color(125,255,0));
					else if (val[j]<0.15) g.setColor(new Color(255,255,0));
					else if (val[j]<0.225) g.setColor(new Color(255,125,0));
					else {
						g.setColor(Color.red);
						if (val[j]<0.3)
							size = 2;
						else if (val[j]<0.4)
							size = 3;
						else if (val[j]<0.5)
							size = 4;
						else
							size = 5;
					}
					if (val[j]>0)
					g.drawOval((int)(p.getX()-size),(int)(p.getY()-size),size*2,size*2); 
					
				}
			//}
		}
	}
	
}
