package kvk.Bots;
import java.io.*;
import java.util.Arrays;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kvk.ExtendedRobot;
import kvk.Gun.GunManager;
import kvk.Gun.GunStats;
import kvk.Utils.BattleField;
import kvk.Utils.C;
import kvk.Utils.Fct;
import kvk.Utils.MoveList;
import kvk.Utils.Point;
import kvk.Utils.Wave;
import robocode.*;

/**
 * Bot : stock les informations sur un robot
 *
 * @author     Ssin.le.Terrible
 * @created    11 janvier 2004
 */
public class Bot {

	//{{{ *** Variables de Bot
	private final static  int            VERSION_FICHIER  = 1;
	protected             ExtendedRobot  myBot;                                    // rfrence  moi
	// Informations sur le robot
	private               String         name;                                     // nom du Bot
	private               double         energy;                                   // nergie
	private               double         absBearing;                               // orientation relative par rapport  moi
	private               Point          bCoord;                                   // Coordones du Bot
	private               Point          bCoordOld;                                // Anciennes coordones du Bot
	private               double         distance;                                 // distance par rapport  moi
	private               double         speed;                                    //vitesse du Bot
	private               double         prevSpeed;                                //vitesse prcdente du Bot
	private               double         chgSpeed;                                 //changement de vitesse du Bot
	private               double         heading;                                  //orientation du Bot
	private               double         prevHeading;                              //orientation prcdente du Bot
	private               double         chgHeading;                               //changement d'orientation du Bot
	private               int            speed0Count;                              //compte les tours  vitesse nulle
	// Historique des positions
	private               Vector         waves;                                    // liste des waves
	//private               MoveList       moveList;                                 //liste des mouvements
	//private               String         deltaCoordString;                         // liste des changements de coordonnes
	// Canons et stats de tir
	private               GunManager     gunManager;                               // gestionnaire des canons
	private               GunStats       gunStats;                                 // stats gnrales de tir
	// Suivi des mises  jour
	private               long           lastUpdate;                               // date de la dernire mise  jour
	private               long           lastAddedWave;                            // date de la dernire wave
	//private               long           lastPatternUpdate;                        // date du dernier pettern
	//}}}

	//{{{ *** Constructor
	/**
	 * Constructor pour l'objet Bot
	 *
	 * @param  er    moi-mme
	 * @param  name  Description of the Parameter
	 */
	public Bot(ExtendedRobot er, String name) {

		myBot = er;
		this.name = name;

		// Initialisation des donnes
		bCoord = new Point();
		bCoordOld = new Point();
		prevHeading = heading = chgHeading = 0d;
		prevSpeed = speed = chgSpeed = 0d;
		speed0Count = 0;

		// Initialisation des canons et stats de tir
		gunStats = new GunStats();
		gunManager = new GunManager(myBot, this);

		// Initialisation des historiques
		waves = new Vector();
		//moveList = new MoveList(C.PATTERN_MAX_SIZE);
		//deltaCoordString = "";
	}
	//}}}

	//{{{ ***************************** METHODES D'ACCES ***************************** //
	public void setEnergy(double nrj) {
		energy = nrj;
	}

	public double getAbsBearing() {
		return absBearing;
	}

	public double getSpeed() {
		return speed;
	}

	public double getPrevSpeed() {
		return prevSpeed;
	}

	public double getChgSpeed() {
		return chgSpeed;
	}

	public double getHeading() {
		return heading;
	}

	public double getPrevHeading() {
		return prevHeading;
	}

	public double getChgHeading() {
		return chgHeading;
	}

	public Point getCoord() {
		return bCoord;
	}

//	public String getDeltaCoordString() {
//		return deltaCoordString;
//	}

	public double getDistance() {
		return distance;
	}

	public double getEnergy() {
		return energy;
	}

	public GunManager getGunManager() {
		return gunManager;
	}

	public long getLastUpdate() {
		return lastUpdate;
	}

	public long getLastAddedWave() {
		return lastAddedWave;
	}

//	public long getLastPatternUpdate() {
//		return lastPatternUpdate;
//	}

	public ExtendedRobot getMyBot() {
		return myBot;
	}

	public String getName() {
		return name;
	}

//	public int getPatternSize() {
//		return deltaCoordString.length();
//	}

	public boolean isDead() {
		return energy == -1;
	}

	public boolean isDisabled() {
		return energy == 0;
	}

	public boolean isMoving() {
		return speed0Count < 20;
	}

	public boolean isUpdated() {
		return myBot.getTime() - lastUpdate < 10;
	}
	// **************************************************************************** //}}}
	// **************************************************************************** //
	//                       MISE A JOUR                                            //
	// **************************************************************************** //

	public void update(double eBearing, double eHeading, double eSpeed, double eDistance, double eEnergy, long time) {
		//myBot.print(true, "Old pos=" + bCoord.toString() + " head=" + Fct.round2(Math.toDegrees(heading)) + " speed=" + Fct.round2(speed) + " time=" + lastPatternUpdate);//DEBUG
		Point  myPosition  = myBot.getCoord();
		absBearing = robocode.util.Utils.normalRelativeAngle(eBearing + myBot.getHeadingRadians());
		distance = eDistance;
		bCoordOld = bCoord;
		bCoord = Fct.calcXY(myPosition, absBearing, distance);

		prevHeading = heading;
		heading = eHeading;
		chgHeading = heading - prevHeading;

		prevSpeed = speed;
		speed = eSpeed;
		chgSpeed = speed - prevSpeed;
		if (speed == 0d) {
			speed0Count++;
		}
		else {
			speed0Count = 0;
		}

		energy = eEnergy;
		lastUpdate = time;

		// Mise  jour du pattern
//		if (time > 15) {                                                              // Evite les incohrences du dbut du round
//			Point  deltaCoord  = new Point(bCoord);
//			deltaCoord.minus(bCoordOld);                                                 //calcul de l'cart de position
//			long   deltaTime   = time - lastPatternUpdate;                               // Temps pass depuis la dernire mise  jour

		//myBot.print("   dPos=" + deltaCoord.toString() + " dHead=" + Fct.round2(Math.toDegrees(chgHeading)) + " dSpeed=" + Fct.round2(chgSpeed) + " dTime=" + deltaTime);//DEBUG

		//myBot.print(true, name + " dCoord=" + deltaCoord.toString() + " dTime=" + deltaTime);

//			if (deltaTime < 10d) {                                                       // Si >9 = problme de scan
//				double  invDeltaTime  = 1d / (double)deltaTime;
//				//mise  jour des donnes
//				deltaCoord.mult(invDeltaTime);
//				chgHeading *= invDeltaTime;
//				chgSpeed *= invDeltaTime;
//				for (int i = 0; i < deltaTime; i++) {
//					//myBot.print("   dPos=" + deltaCoord.toString() + " dHead=" + Fct.round2(Math.toDegrees(chgHeading)) + " speed=" + Fct.round2(prevSpeed + (i + 1) * chgSpeed) + " i=" + i);//DEBUG

//					moveList.add(new Point(chgHeading, prevSpeed + (i + 1) * chgSpeed));
//					deltaCoordString += Fct.codeDeltaCoordToString(deltaCoord);
//					//myBot.print(true, "" + deltaCoord.toString() + " => " + Fct.decodeStringToDeltaCoord(deltaCoordString.substring(deltaCoordString.length() - 2)));//DEBUG
//					//Fct.decodeStringToDeltaCoord(Fct.codeDeltaCoordToString(deltaCoord)).toString());
//					if (deltaCoordString.length() > C.PATTERN_MAX_SIZE * C.PATTERN_STEP) {
//						deltaCoordString = deltaCoordString.substring(deltaCoordString.length() - C.PATTERN_MAX_SIZE * C.PATTERN_STEP);
//					}
//				}
//			}
//		}
//		lastPatternUpdate = time;
		//myBot.print("   Pos=" + bCoord.toString() + " head=" + Fct.round2(Math.toDegrees(heading)) + " speed=" + Fct.round2(speed) + " time=" + lastPatternUpdate);//DEBUG

		// Ajout d'une wave
		if (time - lastAddedWave > 6) {                                               //limite pour RADAR_SCAN_ALL
			//myBot.print(true, name + "-" + lastAddedWave + "=" + (time - lastAddedWave));
			lastAddedWave = time;
			// cre une wave
			waves.add(new Wave(myPosition, time, absBearing, distance, eSpeed * Math.sin(eHeading - absBearing), bCoord.distance(BattleField.getCentreX(), BattleField.getCentreY()) / 60d));
			// Limite  3000 waves
			while (waves.size() > 3000) {
				waves.remove(0);
			}
		}
	}

	/**
	 *  Mise  jour  chaque tour
	 */
	public void updateEachTurn() {
		distance = bCoord.distance(myBot.getCoord());
	}

	// **************************************************************************** //
	//                    NIMROD WAVES AND PATTER MATCHING                          //
	// **************************************************************************** //

	public void testWave(long time) {
		int  wavesSize  = waves.size();
		// 25 car 25x11(vitesse max)x8(nb tours entre scans)=2200 > distance de l'ennemi
		// remplacement de 25 par 30 pour RADAR_SCAN_ALL car nb tours entre scans = 7
		for (int i = wavesSize - 2; i >= 0 && i > wavesSize - 30; i--) {
			((Wave)waves.elementAt(i)).test(bCoord, time);
		}
	}

	public double getShootTurnAngle(double firePower) {
		Point   myPosition  = myBot.getCoord();
		double  comVal;
		double  comValD;
		double  dir;
		double  div;
		double  minComVal   = 1000d;
		double  hitAngle    = 0d;
		absBearing = Fct.bearing(myPosition, bCoord);
		int     size        = waves.size();

		// Recherche de similarit sur 10 positions
		for (int i = 10; i < size; i++) {
			Wave  wave;
			if ((wave = (Wave)waves.elementAt(i)).getStartPoint().getX() < 10) {
				div = comVal = comValD = 0;
				dir = wave.getStartPoint().getX();
				int  j  = 0;
				do {
					comVal += ((Wave)waves.elementAt(size - j - 1)).getComVal((Wave)waves.elementAt(i - j), 1d) / (div = div * 2 + 1);
					comValD += ((Wave)waves.elementAt(size - j - 1)).getComVal((Wave)waves.elementAt(i - j), -1d) / (div);
				} while (j++ < 10);
				if (comValD < comVal) {
					comVal = comValD;
					dir = -wave.getStartPoint().getX();
				}
				if (comVal < minComVal && (Fct.calcXY(myPosition, absBearing + dir, wave.getStartPoint().getY())).isOnSmallField()) {
					hitAngle = dir;
					minComVal = comVal;
				}
			}
		}
		if (energy == 0d) {
			hitAngle = 0d;
		}
		return absBearing + Math.asin(Math.sin(hitAngle) / (1.818182d - firePower * 0.2727273d));
		//												1.81 = 20 / 11			0.27 = 3 / 11
	}
	// **************************************************************************** //

	/**
	 *  Mthode pour rinitialiser le bot au 2me tour et les suivants
	 */
	public void reinitialise() {

		energy = 100d;
		absBearing = 0d;
		distance = 0;
		bCoord.setXY(0d, 0d);
		prevHeading = heading = chgHeading = 0d;
		prevSpeed = speed = chgSpeed = 0d;
		lastUpdate = -1000;
		lastAddedWave = -1000;
		speed0Count = 0;
	}

	/**
	 * Mthode pour dclarer un robot mort
	 */
	public void updateDead() {
		energy = -1;
	}

	/**
	 * Mthode pour affichage
	 *
	 * @return    Description of the Return Value
	 */
	public String toString() {
		String  s  = "";

		s += "Robot : " + name + "\n";
		s += "   Energy = " + energy + "\n";
		s += "   Bearing = " + absBearing + "\n";
		s += "   Distance = " + distance + "\n";
		s += "   Coord = " + bCoord.toString() + "\n";
		return s;
	}


	//{{{ Mthodes de lecture / criture
	/**
	 * Ecrit les infos du robot dans le fichier
	 */
	public void botEcriture() {
		try {
			DataOutputStream  out  = new DataOutputStream(new RobocodeFileOutputStream(myBot.getDataFile(fileName())));
			objetEcriture(out);
			out.close();
		}
		catch (IOException e) {}
	}

	/**
	 * Lit les infos du robot dans le fichier
	 */
	public void botLecture() {
		try {
			File  robotFile  = myBot.getDataFile(fileName());
			if (robotFile.length() > 0) {
				DataInputStream  in  = new DataInputStream(new FileInputStream(robotFile));
				objetLecture(in);
				in.close();
			}
		}
		catch (IOException e) {}
	}

	/**
	 * Choix du nom de fichier
	 *
	 * @return    Description of the Return Value
	 */
	private String fileName() {
		String  file  = name;
		int     i     = file.lastIndexOf(" (");
		if (i > -1) {
			int  j  = file.indexOf(')', i + 1);
			if ((j > i) && (j == file.length() - 1)) {
				file = file.substring(0, i);
			}
		}
		return file + ".dat";
	}

	/**
	 * Ecrit un objet dans le fichier
	 *
	 * @param  stream           Description of the Parameter
	 * @exception  IOException  Description of the Exception
	 */
	private void objetEcriture(DataOutputStream stream)
		throws IOException {
		stream.writeInt(VERSION_FICHIER);
	}

	/**
	 * Lit un objet du fichier
	 *
	 * @param  stream           Description of the Parameter
	 * @exception  IOException  Description of the Exception
	 */
	private void objetLecture(DataInputStream stream)
		throws IOException {
		if (stream.readInt() == VERSION_FICHIER) {
		}
	}

	// **************************************************************************** //}}}

}

