
package sgp;

public class InterceptManager
{ 
	public static final int ANTI_DODGE 									= 0; //3.01
	public static final int JIGGLE_ALL_PLUS_CIRCULAR 					= 1; //2.0
	public static final int JIGGLE_OSC_PLUS_PATTERN_WHEN_VALID_CIRCULAR 	= 2; //2.01
	public static final int JIGGLE_ALL_PLUS_PATTERN 						= 3; //0.02
	public static final int PATTERN 										= 4;
	public static final int JIGGLE_ALL_PLUS_PATTERN_WHEN_VALID_CIRCULAR 	= 5; //0.5
	public static final int JIGGLE_ONLY 									= 7;
	public static final int GRAVITY 										= 8;
	public static final int JIGGLE_ALL_PLUS_GRAVITY 						= 9;
	public static final int JIGGLE_OSC_PLUS_GRAVITY 						= 10;
	public static final int POLAR_PATTERN 								= 11; //0.5
	public static final int AVERAGE_LINEAR 								= 12;
	public static final int RANDOM 										= 13;
	public static final int CIRCULAR 									= 14; 
	public static final int LINEAR 										= 15;
	public static final int JIGGLE_OSC_PLUS_CIRCULAR 					= 16;
	public static final int JIGGLE_OSC_PLUS_PATTERN 						= 17; 
	public static final int JIGGLE_ALL_PLUS_ANTI_DODGE 					= 18;
	public static final int JIGGLE_OSC_PLUS_ANTI_DODGE 					= 6; //0.02

	public static final int NUMBER_OF_INTERCEPT_TYPES = 9;


	public static final int PATTERN_WHEN_VALID 							= 19;
	public static final int JIGGLE_ALL_PLUS_PATTERN_WHEN_VALID 			= 20;
	public static final int JIGGLE_OSC_PLUS_PATTERN_WHEN_VALID 			= 21;
	
	public JiggleAnalyser jiggleAnalyser = null; 
	public PatternAnalyser patternAnalyser = null;
	public AverageLinearAnalyser averageLinearAnalyser = null;
	public AntiDodgeAnalyser antiDodgeAnalyser = null;
	public PolarPatternAnalyser polarPatternAnalyser = null;
	
	private Target target = null;
	
	public InterceptManager
	(
		JiggleAnalyser theJiggleAnalyser, 
		PatternAnalyser thePatternAnalyser, 
		AverageLinearAnalyser theAverageLinearAnalyser,
		AntiDodgeAnalyser theAntiDodgeAnalyser,
		PolarPatternAnalyser thePolarPatternAnalyser,
		Target theTarget
	)
	{
		jiggleAnalyser = theJiggleAnalyser;
		patternAnalyser = thePatternAnalyser;
		averageLinearAnalyser = theAverageLinearAnalyser;
		antiDodgeAnalyser = theAntiDodgeAnalyser;
		polarPatternAnalyser = thePolarPatternAnalyser;
		target = theTarget;
	}
	
	public void reset(String moduleName, String robotName)
	{
	}


	public Intercept getIntercept
	(
		Coordinate bulletStartPosition, 
		Coordinate targetPosition,
		double targetHeading,
		double targetVelocity,
		double targetAngularVelocity,
		double bulletPower, 
		int type
	)
	{
		Intercept intercept = null;
		
		switch (type)
		{
		case JIGGLE_ONLY:
			intercept = getJiggleIntercept(false, false);
			break;
		case JIGGLE_OSC_PLUS_PATTERN:
			intercept = getJiggleIntercept(true, false);
			if (intercept == null) return getPatternIntercept(bulletStartPosition, targetPosition, targetHeading, targetVelocity, targetAngularVelocity, bulletPower, false);
			break;
		case JIGGLE_ALL_PLUS_PATTERN:
			intercept = getJiggleIntercept(true, true);
			if (intercept == null) return getPatternIntercept(bulletStartPosition, targetPosition, targetHeading, targetVelocity, targetAngularVelocity, bulletPower, false);
			break;
		case JIGGLE_ALL_PLUS_CIRCULAR:
			intercept = getJiggleIntercept(true, false);
			if (intercept == null) intercept = getCircularIntercept();
			break;
		case CIRCULAR:
			intercept = getCircularIntercept();
			break;
		case LINEAR:
			intercept = getLinearIntercept();
			break;
		case PATTERN:
			return getPatternIntercept(bulletStartPosition, targetPosition, targetHeading, targetVelocity, targetAngularVelocity, bulletPower, false);
		case PATTERN_WHEN_VALID:
			return getPatternIntercept(bulletStartPosition, targetPosition, targetHeading, targetVelocity, targetAngularVelocity, bulletPower, true);
		case JIGGLE_OSC_PLUS_PATTERN_WHEN_VALID:
			intercept = getJiggleIntercept(true, false);
			if (intercept == null) return getPatternIntercept(bulletStartPosition, targetPosition, targetHeading, targetVelocity, targetAngularVelocity, bulletPower, true);
			break;
		case JIGGLE_OSC_PLUS_PATTERN_WHEN_VALID_CIRCULAR:
			intercept = getJiggleIntercept(true, false);
			if (intercept == null) intercept = getPatternIntercept(bulletStartPosition, targetPosition, targetHeading, targetVelocity, targetAngularVelocity, bulletPower, true);
			if (intercept == null) intercept = getCircularIntercept();
			break;
		case JIGGLE_ALL_PLUS_PATTERN_WHEN_VALID:
			intercept = getJiggleIntercept(true, true);
			if (intercept == null) return getPatternIntercept(bulletStartPosition, targetPosition, targetHeading, targetVelocity, targetAngularVelocity, bulletPower, true);
			break;
		case JIGGLE_ALL_PLUS_PATTERN_WHEN_VALID_CIRCULAR:
			intercept = getJiggleIntercept(true, true);
			if (intercept == null) intercept = getPatternIntercept(bulletStartPosition, targetPosition, targetHeading, targetVelocity, targetAngularVelocity, bulletPower, true);
			if (intercept == null) intercept = getCircularIntercept();
			break;
		case AVERAGE_LINEAR:
			intercept = getAverageLinearIntercept();
			break;
		case ANTI_DODGE:
			intercept = getAntiDodgeIntercept();
			break;
		case JIGGLE_OSC_PLUS_ANTI_DODGE:
			intercept = getJiggleIntercept(true, false);
			if (intercept == null) intercept = getAntiDodgeIntercept();
			break;
		case JIGGLE_ALL_PLUS_ANTI_DODGE:
			intercept = getJiggleIntercept(true, true);
			if (intercept == null) intercept = getAntiDodgeIntercept();
			break;
		case JIGGLE_OSC_PLUS_CIRCULAR:
			intercept = getJiggleIntercept(true, false);
			if (intercept == null) intercept = getCircularIntercept();
			break;
		case RANDOM:
			intercept = new RandomIntercept();
			break;
		case GRAVITY:
			if (target != null) intercept = new GravityIntercept(target);
			break;
		case JIGGLE_OSC_PLUS_GRAVITY:
			intercept = getJiggleIntercept(true, false);
			if ((intercept == null) && (target != null)) intercept = new GravityIntercept(target);
			break;
		case JIGGLE_ALL_PLUS_GRAVITY:
			intercept = getJiggleIntercept(true, true);
			if ((intercept == null) && (target != null)) intercept = new GravityIntercept(target);
			break;
		case POLAR_PATTERN:
			if (polarPatternAnalyser != null) intercept = new PolarPatternIntercept(polarPatternAnalyser);
			else 
			{
				intercept = getCircularIntercept();
			}
			break;
		}
		
		if (intercept == null) return null;
		
		long currentTime = Environment.getRobot().getTime();

		intercept.calculate
		(
			bulletStartPosition,
			targetPosition,
			targetHeading,
			targetVelocity,
			bulletPower,
			targetAngularVelocity
		);
		
		return intercept;
	}
	
	public Intercept getJiggleIntercept(boolean isJiggleCheckOn, boolean isOscilatingCheckOn)
	{
		Intercept intercept = null;
	
		if (isJiggleCheckOn && !jiggleAnalyser.isJiggling) return null;
		if (isOscilatingCheckOn && !jiggleAnalyser.isOscilating) return null;

		intercept = new JiggleIntercept(jiggleAnalyser);
		return intercept;
	}
	
	public Intercept getPatternIntercept
	(
		Coordinate bulletStartPosition, Coordinate targetPosition, 
		double heading, double velocity, double angularVelocity,
		double bulletPower, boolean isReliableCheckOn
	)
	{
		long currentTime = Environment.getRobot().getTime();

		PatternIntercept patternIntercept = new PatternIntercept(patternAnalyser);
		Intercept intercept = patternIntercept;
		intercept.calculate
		(
			bulletStartPosition, targetPosition,
			heading, velocity, bulletPower, angularVelocity
		);
		
		if (isReliableCheckOn && !patternIntercept.isPredictionReliable) return null;
		else return intercept;
	}

	public Intercept getCircularIntercept()
	{
		return new CircularIntercept();
	}

	public Intercept getLinearIntercept()
	{
		return new LinearIntercept();
	}
	
	public Intercept getAverageLinearIntercept()
	{
		return new AverageLinearIntercept(averageLinearAnalyser);
	}
	
	public Intercept getAntiDodgeIntercept()
	{
		return new AntiDodgeIntercept(antiDodgeAnalyser);
	}

	
	
	
	
}
