package axeBots.data;

import java.text.DecimalFormat;
import java.util.ArrayList;
//import java.util.zip.GZIPInputStream;
//import java.util.zip.GZIPOutputStream;

import axeBots.AxeBot;
//import axeBots.util.AxeFiles;
import axeBots.util.RoboMath;
import robocode.*;

/**
 * BotScore - 11/06/2004
 * 
 * @author Axe
 * 
 * This code is released under the RoboWiki Public Code Licence (RWPCL),
 * datailed on: http://robowiki.net/?RWPCL (Basically it means you must keep the
 * code public if you base any code on it.) Not basically, i think it means that
 * the knowledge should not be retained, but shared. We must all remember that
 * the veins of the Knowledge must flow. Quoting(or some) PEZs comment about
 * OpenSouce: "At least is a good Karma".
 * 
 * Class made to calculate the bot's score. Note that it will only work in 1x1,
 * melee calculus would be a lot more complicated (and possibly not even 70%
 * accurate, given that when u die, your thread dies).
 * 
 * Calculus based on the Wiki Pages, topic Score. extracted from:
 * http://robowiki.dyndns.org/perl/robowiki?Score
 * 
 * The best I can come up with is:
 * 
 * survival = 50 * survival 1st (but I think this is wrong given the next
 * category, and the fact that they could've combined it with this one by
 * multiplying with 60 instead of 50) last survivor bonus = 10 * survival 1st
 * bullet damage = total damage done to your enemies by hitting them bonus
 * (bullet damage) = 20% of all damage done to the enemy you just killed by
 * hitting him ram damage * 2 = total damage done to your enemies by ramming
 * them * 2 bonus (ram damage) = 30% of all damage done to the enemy you just
 * killed by ramming him
 * 
 * total score = sum of all of the above Does someone have a reference to an
 * "official" formula? (Or did someone decompile the code?)
 * 
 * ---FnH
 * 
 * The survival and last survivor bonus are correct for 1v1 but for melee/team
 * the folling is a more complete description:
 * 
 * 50 points for each survivor when an opponent dies (by coming first in a 10
 * bot melee round you will have aquired 450 points - because 9 bots died before
 * you)
 * 
 * Last Survivor bonus = 10 * number of opponents at the start of the round. For
 * a 10 bot melee the bonus = 90, 1v1 the bonus is 10.
 * 
 * In a 10 bot melee battle survival points are distributed thus: 10th = 0 9th =
 * 50 8th = 100 . . . 3rd = 350 2nd = 400 1st = 450 (+ 90 last survivor)
 * 
 * ---Paul Evans
 *  
 */

public class BotScore {

	public static final int STR_NAME = 0;
	public static final int STR_ROUNDS = 1;
	public static final int STR_ENEMIES_SCORE = 2;
	public static final int STR_SURVIVAL = 3;
	public static final int STR_LAST_SURVIVAL = 4;
	public static final int STR_BULLS_DMG = 5;
	public static final int STR_BULLS_AVG_DMG = 6;

	private int rounds;

	private static ArrayList allScores = new ArrayList();

	private double survival = 0;
	private double lastSurvivor = 0;
	private double bullsDmg = 0;
	private double bullsDmgBonus = 0;
	private double rammsDmg = 0;
	private double rammsDmgBonus = 0;

	private double nowBullsDmg = 0;
	private double nowRammsDmg = 0;

	private double closedOthersScore = 0;
	//private double score=0;
	private String botsName;

	public BotScore() {
		super();
		if (!allScores.contains(this)) {
			allScores.add(this);
		}
	}

	public BotScore(String botsName) {
		this();
		this.botsName = botsName;
	}

	public void newRound() {
		AxeBot.getIt().out.println(botsName + " scorer new Round!");
		rounds++;
		nowBullsDmg = 0;
		nowRammsDmg = 0;

	}

	public void died() {
		terminus();
	}

	public void win() {

		AxeBot.getIt().out.println(botsName + " win!");
		survival += 50;
		lastSurvivor += 10;
		rammsDmgBonus += nowRammsDmg * 0.2;
		bullsDmgBonus += nowBullsDmg * 0.2;
		terminus();

	}

	private void terminus() {
		rammsDmg += nowRammsDmg;
		bullsDmg += nowBullsDmg;
		nowBullsDmg = 0;
		nowRammsDmg = 0;
		this.setClosedOthersScore(this.getOthersScore());
	}

	private void bullsEye(double energyAfter, double energyLeft,
			double bullsPower) {

		double bullsDamage = RoboMath.getBulletDamage(bullsPower);
		nowBullsDmg += (bullsDamage = (Double.isNaN(energyAfter)
				|| (energyLeft > 0) || (energyAfter > bullsDamage))
				? bullsDamage
				: energyAfter);
	}

	public void bullsEye(BulletHitEvent bhe, double energyAfter) {
		this.bullsEye(energyAfter, bhe.getEnergy(), bhe.getBullet().getPower());
	}

	public void bullsEye(AdvancedRobot myBot, HitByBulletEvent hbbe,
			double energyAfter) {
		this.bullsEye(energyAfter, myBot.getEnergy(), hbbe.getBullet()
				.getPower());
	}

	public void ramm(boolean itsFault) {
	}

	public int getScore() {

		return (int) Math.round(survival + lastSurvivor + bullsDmg
				+ nowBullsDmg + bullsDmgBonus + rammsDmg + nowRammsDmg
				+ rammsDmgBonus);
	}

	public String toString() {
		DecimalFormat forma = new DecimalFormat("0.00");

		return this.botsName + ": " + getScore() + "("
				+ forma.format(this.getELO() * 100) + ") rounds:" + this.rounds
				+ "survival:" + (int) Math.round(survival) + " lastSurvivor:"
				+ (int) Math.round(lastSurvivor) + " bullsDmg:"
				+ (int) Math.round(bullsDmg + nowBullsDmg) + " bullsDmgBonus:"
				+ (int) Math.round(bullsDmgBonus) + " rammsDmg:"
				+ (int) Math.round(rammsDmg + nowRammsDmg) + " rammsDmgBonus:"
				+ (int) Math.round(rammsDmgBonus);
	}

	public double getELO() {
		return this.getScore() / this.getOthersScore();
	}

	public double getOthersScore() {
		double all = 0;
		for (int i = 0; i < allScores.size(); i++) {
			all += ((BotScore) allScores.get(i)).getScore();
		}
		return all;
	}

	public int getRounds() {
		return rounds;
	}

	public String getBotsName() {
		return botsName;
	}

	public double getBullsDmg() {
		return bullsDmg;
	}

	public double getBullsDmgBonus() {
		return bullsDmgBonus;
	}

	public double getLastSurvivor() {
		return lastSurvivor;
	}

	public double getSurvival() {
		return survival;
	}

	public void setBullsDmg(double d) {
		bullsDmg = d;
	}

	public void setBullsDmgBonus(double d) {
		bullsDmgBonus = d;
	}

	public void setLastSurvivor(double d) {
		lastSurvivor = d;
	}

	public void setRounds(int i) {
		rounds = i;
	}

	public void setSurvival(double d) {
		survival = d;
	}

	public double getClosedOthersScore() {
		return closedOthersScore;
	}

	public void setClosedOthersScore(double d) {
		closedOthersScore = d;
	}
}