package jok;
import robocode.*;
import java.util.*;
import java.awt.geom.*;

/**
 * MyClass - a class by (your name here)
 */
public class Enemy
{
	private Hashtable log = new Hashtable();
	private ScannedRobotEvent e;
	private AdvancedRobot me;
	double x;
	double y;
	double time;
	double dH;
	double adH;
	
	Targeting targeting = new TargetingHeadOn();
			
	public void update(ScannedRobotEvent event, AdvancedRobot ar) 
	{
		if(e !=  null)
		{
			dH = BotMath.normaliseBearing(event.getHeading()-getHeading())/(me.getTime() - getTime());
			adH = (adH + event.getHeading() * .4)/(1.5);
		}
		me = ar;
		e = event;
		time = me.getTime();
		x = me.getX() + Math.sin(Math.toRadians(BotMath.normaliseHeading((getBearing()+me.getHeading())))) * e.getDistance();
		y = me.getY() + Math.cos(Math.toRadians(BotMath.normaliseHeading((getBearing()+me.getHeading())))) * e.getDistance();
		log.put(new Double(e.getTime()),e);
	}
	
	public void fire()
	{
		targeting.update(me,this);
		targeting.fire();
	}
	
	public boolean isUpdated(double time)
	{
		return (time - getTime()) <= 10;
	}
	
	public String getName()
	{
		return e.getName();
	}
	
	public double getTime()
	{
		return time;
	}
	
	public double getDistance()
	{
		return e.getDistance();
	}
	
	public double getEnergy()
	{
		return e.getEnergy();
	}
	
	public double getBearing()
	{
		return e.getBearing();
	}
	
	public double getHeading()
	{
		return e.getHeading();
	}
	
	public double getHeadingChange()
	{
		return dH;
	}
	
	public double getAverageHeadingChange()
	{
		return dH;
	}
	
	public double getVelocity()
	{
		return e.getVelocity();
	}
	
	public double getX()
	{
		return x;
	}
	
	public double getY()
	{
		return y;
	}		
}