package hamilton;

import java.io.*;
import robocode.*;
import java.util.*;

public class Memory 
{
	File dataFile;
	
	int rounds;
	Statistic averageVelocity;
	Statistic averageChangeInHeading;
	Statistic averageRank;
	Statistic averageHalfPeriod;
	Statistic averageDamagePerRound;
	
	Statistic hitPercentage;
	HashMap algorithmMap;
	
	public Memory(File someFile)
	{
		dataFile = someFile;
		readFile();
	}
	
	public int getRounds()
	{
		return rounds;
	}
	
	public Statistic getAverageVelocity()
	{
		return averageVelocity;
	}
	
	public Statistic getAverageChangeInHeading()
	{
		return averageChangeInHeading;
	}
	
	public Statistic getAverageRank()
	{
		return averageRank;
	}
	
	public Statistic getAverageHalfPeriod()
	{
		return averageHalfPeriod;
	}
	
	public Statistic getAverageDamagePerRound()
	{
		return averageDamagePerRound;
	}
	
	public Statistic getHitPercentage()
	{
		return hitPercentage;
	}
	
	public HashMap getAlgorithmStatistics()
	{
		return algorithmMap;
	}
	
	public void reset()
	{
		rounds = 0;
		averageVelocity = new Statistic();
		averageChangeInHeading = new Statistic();
		averageRank = new Statistic();
		averageHalfPeriod = new Statistic();
		averageDamagePerRound = new Statistic();
		hitPercentage = new Statistic();
		algorithmMap = new HashMap();
	}
	
	public void readFile()
	{
		try 
		{
			BufferedReader reader = new BufferedReader(new FileReader(dataFile));

			rounds = Integer.parseInt(reader.readLine());
			
			// get averageVelocity statistic
			averageVelocity = readStatistic(reader);
			
			// get averageChangeInHeading statistic
			averageChangeInHeading = readStatistic(reader);
			
			// get averageRank statistic
			averageRank = readStatistic(reader);
			
			// get averageHalfPeriod statistic
			averageHalfPeriod = readStatistic(reader);
			
			// get averageDamagePerRound statistic
			averageDamagePerRound = readStatistic(reader);
			
			// get algorithm data
			int numberOfAlgorithms = Integer.parseInt(reader.readLine());
			algorithmMap = new HashMap(numberOfAlgorithms);
			
			for (int x = 0; x < numberOfAlgorithms; x ++)
			{
				String algorithmName = reader.readLine();
				Statistic algorithmStatistic = readStatistic(reader);
				algorithmMap.put(algorithmName, algorithmStatistic);
			}			
		} 
		
		catch (IOException e) 
		{
			// Something went wrong reading the file, reset to 0.
			reset();
		} 
		
		catch (NumberFormatException e) 
		{
			// Something went wrong converting to ints, reset to 0
			reset();

		}		
	}
	
	public Statistic readStatistic(BufferedReader someReader)
	{
		Statistic someStatistic;
		
		try
		{
			double sum = Double.parseDouble(someReader.readLine());
			double sumOfSquares = Double.parseDouble(someReader.readLine());
			int count= Integer.parseInt(someReader.readLine());
			someStatistic = new Statistic(sum, sumOfSquares, count);
		}
		catch (IOException e)
		{
			someStatistic = new Statistic();
		}
		
		return someStatistic;
	}
	
	public void writeStatistic(Statistic someStatistic, PrintStream someStream)
	{
		someStream.println(someStatistic.getSum());
		someStream.println(someStatistic.getSumOfSquares());
		someStream.println(someStatistic.getCount());
	}
		
	public void writeFile()
	{
		try 
		{
			PrintStream writer = new PrintStream(new RobocodeFileOutputStream(dataFile));

			writer.println(rounds);
			
			writeStatistic(averageVelocity, writer);
			
			writeStatistic(averageChangeInHeading, writer);
			
			writeStatistic(averageRank, writer);
			
			writeStatistic(averageHalfPeriod, writer);
			
			writeStatistic(averageDamagePerRound, writer);
			
			writer.println(algorithmMap.size());
			
			Collection c = algorithmMap.keySet();			
			Iterator i = c.iterator();
			
			while (i.hasNext())
			{
				String algorithmName = (String) i.next();
				Statistic s = (Statistic) algorithmMap.get(algorithmName);
				writer.println(algorithmName);
				writeStatistic(s, writer);
			}
			
			if (writer.checkError()) System.out.println("I could not write the count!");
			writer.close();
		} 
		
		catch (IOException e) 
		{
			System.out.println("IOException trying to write: " + e);
		}		
		
	}
}

