package hamilton;

import robocode.*;

public class VirtualBullet extends Condition 
{
	AdvancedRobot r;
	Target t;
	String algorithm;
	double firingTime;
	double heading;
	double velocity;
	Coordinate origin;
	
	double originalBearing;
	
	double correctBearing;
	
	public VirtualBullet(AdvancedRobot someR, Target someT, String someAlgorithm, double someTime, double someHeading, double someFirepower, Coordinate someOrigin)
	{
		r = someR;
		t = someT;
		algorithm = someAlgorithm;
		firingTime = someTime;
		heading = someHeading;
		velocity = 20 - (someFirepower * 3);
		origin = someOrigin;
		
		originalBearing = origin.absoluteBearingTo(t.getCoordinates());
		
		r.addCustomEvent(this);
	}
	
	public boolean test()
	{
		double elapsedTime = t.getTimeStamp() - firingTime;

		double radius = (elapsedTime * velocity);
		
		Coordinate position = origin.getCoordinates(heading, radius);
		
		if (position.isOnField(r.getBattleFieldWidth(), r.getBattleFieldHeight()))
		{
			if ( position.distanceFrom(t.getCoordinates()) < (r.getWidth()/2) )	
			{
				t.updateAimingStats(algorithm, 1);
					
				double correctBearing = origin.absoluteBearingTo(t.getCoordinates());
				double delta = Calculator.relativeAngle(correctBearing - originalBearing);
				
				r.removeCustomEvent(this);
			} 

			else t.updateAimingStats(algorithm, 0);
				
		}
		
		else r.removeCustomEvent(this);
		
		return false;
	}
}
