package djc.movement;

import djc.*;
import djc.util.*;

import java.util.*;
import java.awt.geom.*;

import robocode.*;
import robocode.util.*;

/**
 * My modifications to CoriantumrMovement to surf the nearest 2 waves
 */
public class EvolutionSurfMovement extends EvolutionMovement
{
	EnemyWave []nearestWaves;
	
	public EvolutionSurfMovement(AbstractDynaBot themyrobot) {
		super(themyrobot);
				
		name = "EVOLUTIONSURF";
		movementID = DynaBotConstants.EVOLUTIONSURF;
		nearestWaves = new EnemyWave[DynaBotConstants.NUM_WAVES_TO_SURF];
	}
	
	public void doWork() {
		// Get the DynaBotConstants.NUM_WAVES_TO_SURF nearest waves
		getNearestTwoWaves();
		super.doWork();
	}
	
	/**
	 * Override the findRisk method.  The idea is to find the point with the
	 * least risk.
	 */
	protected double findRisk(Point2D.Double point)
	{
		double risk = 0;
		double myCurDistToWave;
		double maxVisitCount;
		double nearestVisitCount;
		
		// The idea is to find the GuessFactor bin for this point on each of the two nearest
		// waves.  Then, lookup the VisitCount from enemyGuessFactorVisitCounts and compare
		// that value to the corresponding maximum VisitCount.  The idea is to increase the
		// risk for VisitCounts closest to the maximum VisitCount.
		for(int i=0;i<DynaBotConstants.NUM_WAVES_TO_SURF;i++) {
			if(nearestWaves[i] != null) {
				myCurDistToWave = nearestWaves[i].fireLocation.distance(myrobot.location) - nearestWaves[i].distanceTraveled;
				
				double [][]visitCounts;
				if(myrobot.theMoveManager.enemyGuessFactorVisitCounts.containsKey(nearestWaves[i].enemyName)) {
					visitCounts = (double[][])myrobot.theMoveManager.enemyGuessFactorVisitCounts.get(nearestWaves[i].enemyName);
				} else {
					visitCounts = new double[DynaBotConstants.NUM_DIST_SEG][DynaBotConstants.GUESSFACTORBINS];
					myrobot.theMoveManager.enemyGuessFactorVisitCounts.put(nearestWaves[i].enemyName, visitCounts);
				}
		
				double fireDist   = nearestWaves[i].fireLocation.distance(nearestWaves[i].fireTargetLocation);
				int distSeg = MyUtils.getDistanceBin(fireDist);
				int gfIndex = nearestWaves[i].getFactorIndex(point);
				
				// Find the Max VisitCount
				maxVisitCount = 0;
				for(int j=0;j<DynaBotConstants.GUESSFACTORBINS;j++) {
					if(maxVisitCount < visitCounts[distSeg][j]) {
						maxVisitCount = visitCounts[distSeg][j];
					}
				}
				
				// Get the visit count for the GF Index
				nearestVisitCount = visitCounts[distSeg][gfIndex];
				if(maxVisitCount != 0) {
					risk += nearestWaves[i].shotPower * (nearestVisitCount / maxVisitCount) / (myCurDistToWave * myCurDistToWave);
				}
			}
		}
	
		// We also want to stay away from enemies...
		double nonSurfRisk = super.findRisk(point);
		//myrobot.out.println("For " + (int)point.getX() + "," + (int)point.getY() + " SurfRisk: " + risk + " NonSurfRisk: " + nonSurfRisk);				
		return risk + nonSurfRisk;
	}
	
	protected void getNearestTwoWaves() {
		// TODO - Change this in case DynaBotConstants.NUM_WAVES_TO_SURF is ever > 2
		nearestWaves[1] = null;  // Reset this wave
		nearestWaves[0] = myrobot.theBattleManager.getClosestSurfableWave(myrobot.location);
		if(nearestWaves[0] != null) {
			nearestWaves[1] = myrobot.theBattleManager.getNextClosestSurfableWave(myrobot.location, nearestWaves[0]);
		}
	}
}
