/*
 * Decompiled with CFR 0.152.
 */
package tcf;

import robocode.util.Utils;
import tcf.Bot;
import tcf.GfBase;
import tcf.GuessFactor;
import tcf.Wave;

class GuessFactorWave
extends Wave {
    Bot m_target;
    double m_targBearing;
    double m_angleAhead;
    double m_angleBehind;
    double[] m_gfData;
    GfBase[] m_gf;
    double[] m_gfValues;
    int[] m_gfStats;

    GuessFactorWave(Bot bot, double d, Bot bot2, double[] dArray, GfBase[] gfBaseArray, double[] dArray2, int[] nArray) {
        super(bot, d);
        this.m_target = bot2;
        this.m_targBearing = Math.atan2(bot2.x() - bot.x(), bot2.y() - bot.y());
        this.m_angleAhead = GuessFactor.calcAngle(true, bot, d, bot2);
        this.m_angleBehind = GuessFactor.calcAngle(false, bot, d, bot2);
        this.m_gfData = dArray;
        this.m_gf = gfBaseArray;
        this.m_gfValues = dArray2;
        this.m_gfStats = nArray;
    }

    Bot target() {
        return this.m_target;
    }

    double bearing() {
        return this.m_targBearing;
    }

    boolean hasHit() {
        return super.hasHit(this.m_target);
    }

    boolean hasMissed() {
        return super.hasMissed(this.m_target);
    }

    double[] getGfData() {
        return this.m_gfData;
    }

    GfBase[] getGf() {
        return this.m_gf;
    }

    double[] getGfValues() {
        return this.m_gfValues;
    }

    int[] getGfStats() {
        return this.m_gfStats;
    }

    double getAngleAhead() {
        return this.m_angleAhead;
    }

    double getAngleBehind() {
        return this.m_angleBehind;
    }

    double calcGuessFactor(double d, double d2) {
        double d3 = Math.atan2(d - this.m_gunX, d2 - this.m_gunY);
        double d4 = Utils.normalRelativeAngle((double)(d3 - this.m_targBearing));
        return GuessFactor.angleToGf(d4, this.m_angleAhead, this.m_angleBehind);
    }

    double calcGuessFactor() {
        return this.calcGuessFactor(this.m_target.x(), this.m_target.y());
    }
}

