/*
 * Decompiled with CFR 0.152.
 */
package eem.frame.gun;

import eem.frame.bot.InfoBot;
import eem.frame.bot.fighterBot;
import eem.frame.gun.baseGun;
import eem.frame.gun.firingSolution;
import eem.frame.gun.gunManagerInterface;
import eem.frame.misc.HashCounter;
import eem.frame.misc.String2D;
import eem.frame.misc.graphics;
import eem.frame.misc.logger;
import eem.frame.misc.math;
import eem.frame.wave.wave;
import eem.frame.wave.waveWithBullets;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import robocode.Bullet;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;

public class gunManager
implements gunManagerInterface {
    public HashMap<String, LinkedList<baseGun>> gunListForGameType = new HashMap();
    public LinkedList<baseGun> gunList = new LinkedList();
    public fighterBot myBot;
    fighterBot targetBot = null;
    protected int firedCount = 0;
    double firingSolutionQualityThreshold = 0.005;
    long fireAtTime = -9999L;
    LinkedList<firingSolution> firingSolutions = new LinkedList();
    firingSolution bestFiringSolution = null;
    public HashCounter<String> hitByOther = new HashCounter();
    public HashCounter<String> hitByMe = new HashCounter();
    public HashCounter<String> firedAt = new HashCounter();
    public HashCounter<String> firedByEnemy = new HashCounter();
    public HashCounter<String> hitBullet = new HashCounter();
    public HashCounter<String2D> hitByMyGun = new HashCounter();
    public HashCounter<String2D> hitByEnemyGun = new HashCounter();
    public HashCounter<String2D> firedAtEnemyByGun = new HashCounter();
    protected int numGuessFactorBins = 31;
    protected HashMap<String, double[]> guessFactorsMap = new HashMap();
    protected double decayRate = 0.8;
    protected HashMap<String, double[]> decayingGuessFactorMap = new HashMap();

    public gunManager() {
    }

    public gunManager(fighterBot fighterBot2) {
        this();
        this.myBot = fighterBot2;
    }

    public void setGunsMap(HashMap<String, LinkedList<baseGun>> hashMap) {
        this.gunListForGameType = hashMap;
    }

    public LinkedList<baseGun> getGunList() {
        return this.gunList;
    }

    public void initTic() {
        String string = this.myBot.getGameInfo().fightType();
        this.gunList = this.gunListForGameType.get(string);
        if (this.gunList == null) {
            logger.dbg("no gun list for the fight type: " + string + ", choosing default");
            this.gunList = this.gunListForGameType.get("default");
        }
        if (this.gunList == null) {
            logger.error("ERROR: no gun list for the default fight type. Assigning empty list");
            this.gunList = new LinkedList();
        }
    }

    @Override
    public void manage() {
    }

    public void onHitByBullet(HitByBulletEvent hitByBulletEvent) {
        String string = this.myBot.getGameInfo().getMasterBot().getName();
        String string2 = hitByBulletEvent.getName();
        this.incrHitCounts(string, string2);
        if (string2.equals(this.myBot.getName())) {
            wave wave2 = this.myBot.getGameInfo().getWavesManager().getWaveMatching(hitByBulletEvent);
            if (wave2 == null) {
                logger.dbg("cannot locate the wave matching HitByBulletEvent");
                return;
            }
            LinkedList<waveWithBullets> linkedList = this.myBot.getGameInfo().getFighterBot(string).getEnemyWaves();
            for (waveWithBullets waveWithBullets2 : linkedList) {
                if (!waveWithBullets2.equals(wave2)) continue;
                Bullet bullet = hitByBulletEvent.getBullet();
                Point2D.Double double_ = new Point2D.Double(bullet.getX(), bullet.getY());
                LinkedList<firingSolution> linkedList2 = waveWithBullets2.getFiringSolutionsWhichHitBotAt(double_, this.myBot.getTime());
                if (linkedList2.size() == 0) {
                    String string3 = "unknownGun";
                    String2D string2D = new String2D(string3, string);
                    this.hitByMyGun.incrHashCounter(string2D);
                    break;
                }
                for (firingSolution firingSolution2 : linkedList2) {
                    String string4 = firingSolution2.getGunName();
                    String2D string2D = new String2D(string4, string);
                    this.hitByMyGun.incrHashCounter(string2D);
                }
            }
        }
    }

    public fighterBot getTarget() {
        return this.targetBot;
    }

    public fighterBot getClosestTarget() {
        double d = 1000000.0;
        long l = 9L;
        for (fighterBot fighterBot2 : this.myBot.getEnemyBots()) {
            double d2 = this.myBot.getPosition().distance(fighterBot2.getPosition());
            if (!(d2 < d) || this.myBot.getTime() - fighterBot2.getLastSeenTime() >= l) continue;
            d = d2;
            this.targetBot = fighterBot2;
        }
        return this.targetBot;
    }

    public void onBulletHit(BulletHitEvent bulletHitEvent) {
        String string = bulletHitEvent.getName();
        String string2 = this.myBot.getGameInfo().getMasterBot().getName();
        this.incrHitCounts(string, string2);
        Bullet bullet = bulletHitEvent.getBullet();
        long l = this.myBot.getTime();
        Point2D.Double double_ = new Point2D.Double(bullet.getX(), bullet.getY());
        wave wave2 = this.myBot.getGameInfo().getWavesManager().getWaveMatching(string2, string, double_, l);
        for (waveWithBullets waveWithBullets2 : this.myBot.myWaves) {
            if (!wave2.equals(waveWithBullets2)) continue;
            waveWithBullets2.setMyWavePassedOverTargetFlag(string, true);
            waveWithBullets2.markFiringSolutionWhichHitBotAt(double_, string, l);
        }
    }

    public void onBulletHitBullet(fighterBot fighterBot2) {
        this.hitBullet.incrHashCounter(fighterBot2.getName());
    }

    public boolean isBulletShieldDetected(String string) {
        int n = this.firedByEnemy.getHashCounter(string);
        double d = math.eventRate(this.hitBullet.getHashCounter(string).intValue(), n);
        int n2 = 10;
        double d2 = 0.2;
        return n >= n2 && d >= d2;
    }

    public void incrHitCounts(String string, String string2) {
        if (this.myBot.getName().equals(string)) {
            this.hitByOther.incrHashCounter(string2);
        }
        if (this.myBot.getName().equals(string2)) {
            this.hitByMe.incrHashCounter(string);
        }
    }

    public void reportHitByOther() {
        logger.routine("Hit me count by the following bot(s)");
        for (fighterBot fighterBot2 : this.myBot.getAllKnownEnemyBots()) {
            String string = fighterBot2.getName();
            logger.routine(" " + string + ": " + logger.hitRateFormat(this.hitByOther.getHashCounter(string), this.firedByEnemy.getHashCounter(string)));
        }
    }

    public void onMyWavePassingOverBot(wave wave2, InfoBot infoBot) {
        long l = this.myBot.getTime();
        String string = infoBot.getName();
        Point2D.Double double_ = infoBot.getPositionClosestToTime(l);
        this.updateHitGuessFactor(infoBot, wave2.getFiringGuessFactor(infoBot, l), wave2.getCount());
        for (waveWithBullets waveWithBullets2 : this.myBot.myWaves) {
            if (!wave2.equals(waveWithBullets2)) continue;
            waveWithBullets2.setMyWavePassedOverTargetFlag(string, true);
            waveWithBullets2.markFiringSolutionWhichHitBotAt(double_, string, l);
        }
    }

    public double[] getGuessFactors(String string) {
        return this.getGuessFromHashMap(this.guessFactorsMap, string);
    }

    public double[] getDecayingGuessFactors(String string) {
        return this.getGuessFromHashMap(this.decayingGuessFactorMap, string);
    }

    public double[] getGuessFromHashMap(HashMap<String, double[]> hashMap, String string) {
        double[] dArray;
        if (!hashMap.containsKey(string)) {
            dArray = new double[this.numGuessFactorBins];
            hashMap.put(string, dArray);
        }
        dArray = hashMap.get(string);
        return dArray;
    }

    public int getGuessFactosrBinNum() {
        return this.numGuessFactorBins;
    }

    public void updateHitGuessFactor(InfoBot infoBot, double d, int n) {
        int n2 = (int)math.gf2bin(d, this.numGuessFactorBins);
        n2 = (int)math.putWithinRange(n2, 0.0, this.numGuessFactorBins - 1);
        double[] dArray = this.getGuessFactors(infoBot.getName());
        int n3 = n2;
        dArray[n3] = dArray[n3] + 1.0;
        dArray = this.getDecayingGuessFactors(infoBot.getName());
        int n4 = 0;
        while (n4 < this.numGuessFactorBins) {
            int n5 = n4++;
            dArray[n5] = dArray[n5] * this.decayRate;
        }
        int n6 = n2;
        dArray[n6] = dArray[n6] + (1.0 - this.decayRate);
    }

    public void onWavePassingOverMe(wave wave2) {
        long l = this.myBot.getTime();
        Point2D.Double double_ = this.myBot.getPosition();
        for (waveWithBullets waveWithBullets2 : this.myBot.enemyWaves) {
            if (!wave2.equals(waveWithBullets2)) continue;
            LinkedList<firingSolution> linkedList = waveWithBullets2.getFiringSolutionsWhichHitBotAt(double_, l);
            for (firingSolution firingSolution2 : linkedList) {
                String string = firingSolution2.getGunName();
                String2D string2D = new String2D(string, waveWithBullets2.getFiredBot().getName());
                if (!firingSolution2.isActive()) continue;
                this.hitByEnemyGun.incrHashCounter(string2D);
                firingSolution2.setActiveFlag(false);
            }
        }
    }

    public void reportHitByMe() {
        logger.routine("hit rate for the following bot(s) out of " + this.firedCount + " shots");
        for (fighterBot fighterBot2 : this.myBot.getAllKnownEnemyBots()) {
            String string = fighterBot2.getName();
            Integer n = this.firedAt.getHashCounter(string);
            if (n == 0) {
                n = this.firedCount;
            }
            logger.routine(" " + string + ": " + logger.hitRateFormat(this.hitByMe.getHashCounter(string), n));
        }
    }

    public void reportMyGunStats() {
        logger.routine("  My virtual gun hit rate stats stats");
        String string = "  ";
        string = string + String.format("%25s", "enemy name");
        for (baseGun object : this.gunList) {
            string = string + String.format("%25s", object.getName());
        }
        logger.routine(string);
        for (fighterBot fighterBot2 : this.myBot.getAllKnownEnemyBots()) {
            string = "  ";
            String string2 = fighterBot2.getName();
            string = string + String.format("%25s", string2);
            for (baseGun baseGun2 : this.gunList) {
                String2D string2D = new String2D(baseGun2.getName(), string2);
                string = string + String.format("%25s", logger.hitRateFormat(this.hitByMyGun.getHashCounter(string2D), this.firedAtEnemyByGun.getHashCounter(string2D)));
            }
            logger.routine(string);
        }
    }

    public void reportEnemyGunStats() {
        logger.routine("  Enemies virtual gun stats");
        for (String2D string2D : this.hitByEnemyGun.keySet()) {
            logger.routine("    " + string2D.getX() + " of bot " + string2D.getY() + " hit me " + logger.hitRateFormat(this.hitByEnemyGun.getHashCounter(string2D), this.firedByEnemy.getHashCounter(string2D.getY())));
        }
    }

    public void reportBulletHitBullet() {
        for (String string : this.hitBullet.keySet()) {
            logger.routine("bot " + string + " intercepted my bullet " + logger.hitRateFormat(this.hitBullet.getHashCounter(string), this.firedByEnemy.getHashCounter(string)));
        }
    }

    public void reportGFStats() {
        for (String string : this.guessFactorsMap.keySet()) {
            logger.routine("bot " + string + " seen at          GF: " + Arrays.toString(this.guessFactorsMap.get(string)));
        }
    }

    public void reportStats() {
        if (this.myBot.isItMasterBotDriver()) {
            this.reportHitByOther();
            this.reportEnemyGunStats();
        }
        this.reportHitByMe();
        this.reportGFStats();
        this.reportMyGunStats();
        if (this.myBot.isItMasterBotDriver()) {
            this.reportBulletHitBullet();
        }
    }

    public void incrFiredCount() {
        ++this.firedCount;
    }

    public void incrFiredAtEnemyByGun(firingSolution firingSolution2) {
        String2D string2D = new String2D(firingSolution2.getGunName(), firingSolution2.getTargetBotName());
        this.firedAtEnemyByGun.incrHashCounter(string2D);
    }

    public void incrFiredAtEnemyByGun(baseGun baseGun2, InfoBot infoBot) {
        String2D string2D = new String2D(baseGun2.getName(), infoBot.getName());
        this.firedAtEnemyByGun.incrHashCounter(string2D);
    }

    public void incrFiredByEnemy(String string) {
        this.firedByEnemy.incrHashCounter(string);
    }

    public LinkedList<firingSolution> getFiringSolutions(fighterBot fighterBot2, long l, double d) {
        LinkedList<firingSolution> linkedList = new LinkedList<firingSolution>();
        for (baseGun baseGun2 : this.gunList) {
            LinkedList<firingSolution> linkedList2 = baseGun2.getFiringSolutions(this.myBot, fighterBot2.getInfoBot(), l, d);
            String2D string2D = new String2D(baseGun2.getName(), fighterBot2.getName());
            double d2 = math.perfRate(this.hitByMyGun.getHashCounter(string2D).intValue(), this.firedAtEnemyByGun.getHashCounter(string2D).intValue());
            for (firingSolution firingSolution2 : linkedList2) {
                double d3 = firingSolution2.getQualityOfSolution();
                firingSolution2.setQualityOfSolution(d3 * d2);
            }
            linkedList.addAll(linkedList2);
        }
        return linkedList;
    }

    public void onPaint(Graphics2D graphics2D) {
        graphics2D.setColor(new Color(255, 0, 0, 128));
        if (this.targetBot != null) {
            double d = 50.0;
            graphics.drawCircle(graphics2D, this.targetBot.getPosition(), d);
        }
    }
}

