/*
 * Decompiled with CFR 0.152.
 */
package catcat20.atom.move.surf.models.quick;

import catcat20.atom.move.surf.models.quick.QuickModel;
import catcat20.atom.utils.HConstants;
import catcat20.atom.utils.HUtils;
import catcat20.atom.utils.Wave;
import java.awt.geom.Point2D;
import robocode.util.Utils;

public class FieldLinearModel
extends QuickModel {
    public FieldLinearModel() {
        this.weight = 5.0;
        this.pow = 3.0;
    }

    @Override
    public double offset(Wave w, Point2D.Double myPos, double myVel, double myHeading) {
        double c;
        double a;
        double D;
        double C;
        double ROBOT_WIDTH = 16.0;
        double ROBOT_HEIGHT = 16.0;
        double eAbsBearing = w.directAngle;
        double rX = w.x;
        double rY = w.y;
        double bV = w.bulletVelocity();
        double eX = myPos.x;
        double eY = myPos.y;
        double A = (eX - rX) / bV;
        double eV = myVel;
        double eHd = myHeading;
        double B = eV / bV * Math.sin(eHd);
        double b = 2.0 * (A * B + (C = (eY - rY) / bV) * (D = eV / bV * Math.cos(eHd)));
        double discrim = b * b - 4.0 * (a = A * A + C * C) * (c = B * B + D * D - 1.0);
        if (discrim >= 0.0) {
            double t2;
            double t1 = 2.0 * a / (-b - Math.sqrt(discrim));
            double t = Math.min(t1, t2 = 2.0 * a / (-b + Math.sqrt(discrim))) >= 0.0 ? Math.min(t1, t2) : Math.max(t1, t2);
            double endX = HUtils.limit(eX + eV * t * Math.sin(eHd), 8.0, HConstants.fieldWidth - 8.0);
            double endY = HUtils.limit(eY + eV * t * Math.cos(eHd), 8.0, HConstants.fieldHeight - 8.0);
            double absAngle = Utils.normalRelativeAngle((double)Math.atan2(endX - rX, endY - rY));
            return absAngle - eAbsBearing;
        }
        return 0.0;
    }
}

