/*
 * Decompiled with CFR 0.152.
 */
package catcat20.atom.move.surf.plan;

import catcat20.atom.move.surf.path.Path;
import catcat20.atom.move.surf.path.PathPos;
import catcat20.atom.move.surf.plan.SurfPlan;
import catcat20.atom.utils.HConstants;
import catcat20.atom.utils.HUtils;
import catcat20.atom.utils.MovementPredictor;
import catcat20.atom.utils.Wave;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import robocode.util.Utils;

public class RamEscapePlan
implements SurfPlan {
    private static double DESIRED_DISTANCE = 650.0;
    private static double MAX_ATTACK_ANGLE = 1.413716694115407;
    public static final int WALL_STICK = 130;
    DistanceController distancer = new DistanceController();

    @Override
    public ArrayList<Path> generatePath(MovementPredictor.PredictionStatus status, Wave w) {
        ArrayList<Path> paths = new ArrayList<Path>();
        boolean ramEscape = false;
        ramEscape = true;
        Path path = new Path(this.predictPosition(status, w, 1, 1, ramEscape, 0.0));
        if (HConstants.safeField.contains(path.path.get(Math.max(0, path.path.size() - 1)))) {
            paths.add(path);
        }
        path = new Path(this.predictPosition(status, w, -1, 1, ramEscape, 0.0));
        if (HConstants.safeField.contains(path.path.get(Math.max(0, path.path.size() - 1)))) {
            paths.add(path);
        }
        path = new Path(this.predictPosition(status, w, 1, 1, ramEscape, 0.6));
        if (HConstants.safeField.contains(path.path.get(Math.max(0, path.path.size() - 1)))) {
            paths.add(path);
        }
        path = new Path(this.predictPosition(status, w, -1, 1, ramEscape, 0.6));
        if (HConstants.safeField.contains(path.path.get(Math.max(0, path.path.size() - 1)))) {
            paths.add(path);
        }
        path = new Path(this.predictPosition(status, w, 1, 1, ramEscape, 1.0));
        if (HConstants.safeField.contains(path.path.get(Math.max(0, path.path.size() - 1)))) {
            paths.add(path);
        }
        path = new Path(this.predictPosition(status, w, -1, 1, ramEscape, 1.0));
        if (HConstants.safeField.contains(path.path.get(Math.max(0, path.path.size() - 1)))) {
            paths.add(path);
        }
        path = new Path(this.predictPosition(status, w, 1, 1, ramEscape, 1.65));
        if (HConstants.safeField.contains(path.path.get(Math.max(0, path.path.size() - 1)))) {
            paths.add(path);
        }
        path = new Path(this.predictPosition(status, w, -1, 1, ramEscape, 1.65));
        if (HConstants.safeField.contains(path.path.get(Math.max(0, path.path.size() - 1)))) {
            paths.add(path);
        }
        return paths;
    }

    public ArrayList<PathPos> precisePredict(Rectangle2D.Double fieldRect, Wave ew, double maxVelocity, MovementPredictor.PredictionStatus status, double heading) {
        ArrayList<PathPos> cachePoss = new ArrayList<PathPos>();
        int counter = 0;
        boolean intercepted = false;
        MovementPredictor.PredictionStatus predictedStatus = (MovementPredictor.PredictionStatus)status.clone();
        Point2D.Double cacheCurrentPos = new Point2D.Double();
        do {
            predictedStatus = MovementPredictor.predict(predictedStatus, heading, maxVelocity);
            PathPos cachePos = new PathPos(predictedStatus.x, predictedStatus.y);
            cachePos.status = (MovementPredictor.PredictionStatus)predictedStatus.clone();
            cachePos.maxVelocity = maxVelocity;
            cachePos.goHeading = heading;
            cachePos.pathColor = ew.color;
            cacheCurrentPos.setLocation(predictedStatus.x, predictedStatus.y);
            cachePoss.add(cachePos);
            ++counter;
            if (predictedStatus.distance(ew) < ew.distanceTraveled + (double)counter * ew.bulletVelocity() + ew.bulletVelocity()) {
                intercepted = true;
            }
            if (fieldRect.contains(predictedStatus.x, predictedStatus.y)) continue;
            intercepted = true;
        } while (!intercepted && counter < 30);
        return cachePoss;
    }

    public ArrayList<PathPos> predictPosition(MovementPredictor.PredictionStatus status, Wave surfWave, int direction, int smoothTowardEnemy, boolean escapeFromRam, double offsetMul) {
        MovementPredictor.PredictionStatus predictedPosition = (MovementPredictor.PredictionStatus)status.clone();
        double predictedVelocity = status.velocity;
        double predictedHeading = status.heading;
        double moveAngle = 0.0;
        int counter = 0;
        boolean intercepted = false;
        ArrayList<PathPos> statuses = new ArrayList<PathPos>();
        do {
            double distancerAngle = 0.0;
            double enDist = surfWave.enState.getPosition().distance(surfWave.myState.getPosition());
            distancerAngle = this.distancer.attackAngle(enDist, offsetMul);
            moveAngle = this.wallSmoothing(predictedPosition.x, predictedPosition.y, HUtils.absoluteBearing(surfWave, predictedPosition) + (double)direction * (1.5707963267948966 + distancerAngle), direction, smoothTowardEnemy) - predictedHeading;
            double moveDir = 1.0;
            if (Math.cos(moveAngle) < 0.0) {
                moveAngle += Math.PI;
                moveDir = -1.0;
            }
            moveAngle = Utils.normalRelativeAngle((double)moveAngle);
            double maxTurning = 0.004363323129985824 * (40.0 - 3.0 * Math.abs(predictedVelocity));
            predictedHeading = Utils.normalRelativeAngle((double)(predictedHeading + HUtils.limit(-maxTurning, moveAngle, maxTurning)));
            predictedVelocity += predictedVelocity * moveDir < 0.0 ? 2.0 * moveDir : moveDir;
            predictedVelocity = HUtils.limit(-8.0, predictedVelocity, 8.0);
            predictedPosition.x = HUtils.project((Point2D.Double)predictedPosition, (double)predictedHeading, (double)predictedVelocity).x;
            predictedPosition.y = HUtils.project((Point2D.Double)predictedPosition, (double)predictedHeading, (double)predictedVelocity).y;
            predictedPosition.heading = predictedHeading;
            predictedPosition.velocity = predictedVelocity;
            predictedPosition.direction = direction;
            PathPos path = new PathPos(predictedPosition.x, predictedPosition.y);
            path.maxVelocity = 8.0;
            path.status = (MovementPredictor.PredictionStatus)predictedPosition.clone();
            path.status.direction = direction;
            path.status.x = predictedPosition.x;
            path.status.y = predictedPosition.y;
            path.goHeading = predictedHeading;
            path.pathColor = surfWave.color;
            statuses.add(path);
            ++counter;
            if (!(predictedPosition.distance(surfWave) < surfWave.distanceTraveled + (double)counter * surfWave.bulletVelocity() + surfWave.bulletVelocity())) continue;
            intercepted = true;
        } while (!intercepted && counter < 300);
        return statuses;
    }

    public double wallSmoothing(double x, double y, double startAngle, int orientation, int smoothTowardEnemy) {
        double angle = startAngle;
        double testX = x + Math.sin(angle += Math.PI * 4) * 130.0;
        double testY = y + Math.cos(angle) * 130.0;
        double wallDistanceX = Math.min(x - 18.0, HConstants.fieldWidth - x - 18.0);
        double wallDistanceY = Math.min(y - 18.0, HConstants.fieldHeight - y - 18.0);
        double testDistanceX = Math.min(testX - 18.0, HConstants.fieldWidth - testX - 18.0);
        double testDistanceY = Math.min(testY - 18.0, HConstants.fieldHeight - testY - 18.0);
        double adjacent = 0.0;
        int g = 0;
        while (!HConstants.safeField.contains(testX, testY) && g++ < 25) {
            if (testDistanceY < 0.0 && testDistanceY < testDistanceX) {
                angle = (double)((int)((angle + 1.5707963267948966) / Math.PI)) * Math.PI;
                adjacent = Math.abs(wallDistanceY);
            } else if (testDistanceX < 0.0 && testDistanceX <= testDistanceY) {
                angle = (double)((int)(angle / Math.PI)) * Math.PI + 1.5707963267948966;
                adjacent = Math.abs(wallDistanceX);
            }
            testX = x + Math.sin(angle += (double)(smoothTowardEnemy * orientation) * (Math.abs(Math.acos(adjacent / 130.0)) + 0.005)) * 130.0;
            testY = y + Math.cos(angle) * 130.0;
            testDistanceX = Math.min(testX - 18.0, HConstants.fieldWidth - testX - 18.0);
            testDistanceY = Math.min(testY - 18.0, HConstants.fieldHeight - testY - 18.0);
            if (smoothTowardEnemy != -1) continue;
        }
        return angle;
    }

    @Override
    public double eval(MovementPredictor.PredictionStatus status, Wave w) {
        return 0.0;
    }

    private static class DistanceController {
        private DistanceController() {
        }

        public double surfAttackAngle(double currentDistance) {
            if (currentDistance < 150.0) {
                return this.attackAngle(currentDistance, 1.65);
            }
            if (currentDistance < 250.0) {
                return this.attackAngle(currentDistance, 1.0);
            }
            return this.attackAngle(currentDistance, 0.6);
        }

        public double surfEscapeFromRamAngle(double currentDistance) {
            if (currentDistance < 150.0) {
                return this.attackAngle(currentDistance, 1.0);
            }
            if (currentDistance < 250.0) {
                return this.attackAngle(currentDistance, 1.5);
            }
            return this.attackAngle(currentDistance, 1.0);
        }

        public double orbitAttackAngle(double currentDistance) {
            return this.attackAngle(currentDistance, 1.65);
        }

        public double attackAngle(double currentDistance, double offsetMultiplier) {
            double distanceFactor = (currentDistance - DESIRED_DISTANCE) / DESIRED_DISTANCE;
            return HUtils.limit(-MAX_ATTACK_ANGLE, distanceFactor * offsetMultiplier, MAX_ATTACK_ANGLE);
        }
    }
}

