/*
 * Decompiled with CFR 0.152.
 */
package catcat20.atom.robot;

import catcat20.atom.utils.HUtils;
import java.awt.geom.Point2D;

public class BotState
implements Cloneable {
    public BotState back;
    public BotState next;
    public boolean isRealData = false;
    private final long thisTime;
    private double energy;
    private final Point2D.Double position;
    private final double velocity;
    private final double heading;
    public double lastVel;
    public double latVel;
    public double advVel;
    public double dirChangeTime;
    public double currentGF = 0.0;
    public double myLatVel;

    public BotState(long thisTime, double energy, Point2D.Double position, double velocity, double heading) {
        this.thisTime = thisTime;
        this.energy = energy;
        this.position = position;
        this.velocity = velocity;
        this.heading = heading;
    }

    public Point2D.Double interpolateNextPos() {
        Point2D.Double nextPos = HUtils.project(this.getPosition(), this.getHeading(), this.getVelocity());
        return nextPos;
    }

    public BotState clone() throws CloneNotSupportedException {
        return (BotState)super.clone();
    }

    public long getThisTime() {
        return this.thisTime;
    }

    public double getEnergy() {
        return this.energy;
    }

    public Point2D.Double getPosition() {
        return this.position;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public double getHeading() {
        return this.heading;
    }

    public void setPosition(Point2D.Double position) {
        this.position.setLocation(position.x, position.y);
    }

    public void setEnergy(double energy) {
        this.energy = energy;
    }
}

