/*
 * Decompiled with CFR 0.152.
 */
package rampancy;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.LinkedList;
import rampancy.REnemyManager;
import rampancy.RMovementManager;
import rampancy.RStatisticsManager;
import rampancy.RTargetingManager;
import rampancy.RWaveManager;
import rampancy.util.RBattlefield;
import rampancy.util.REnemyRobot;
import rampancy.util.RPoint;
import rampancy.util.RRobotState;
import rampancy.util.RUtil;
import rampancy.util.movement.RMoveChoice;
import rampancy.util.wave.RBulletWave;
import rampancy.util.wave.REnemyWave;
import rampancy.util.weapon.RFiringSolution;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RampantRobot
extends AdvancedRobot {
    public static final int MAX_HISTORY_DEPTH = 1000;
    public static RBattlefield globalBattlefield;
    public static REnemyManager enemyManager;
    public static RWaveManager waveManager;
    public static RMovementManager movementManager;
    public static RTargetingManager targetingManager;
    public static RStatisticsManager statisticsManager;
    protected long fireTime = 0L;
    protected long ticksSinceLastVirtualBullet = 0L;
    protected boolean processingShot;
    protected RFiringSolution lockedSolution;
    protected REnemyRobot lockedEnemy;
    protected RPoint location;
    protected LinkedList<RRobotState> states = new LinkedList();
    protected String lastType = "";

    public static RBattlefield getGlobalBattlefield() {
        return globalBattlefield;
    }

    public static REnemyManager getEnemyManager() {
        return enemyManager;
    }

    public static RWaveManager getWaveManager() {
        return waveManager;
    }

    public static RMovementManager getMovementManager() {
        return movementManager;
    }

    public static RTargetingManager getTargetingManager() {
        return targetingManager;
    }

    public static RStatisticsManager getStatisticsManager() {
        return statisticsManager;
    }

    public void run() {
        super.run();
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        globalBattlefield = new RBattlefield((int)this.getBattleFieldWidth(), (int)this.getBattleFieldHeight());
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.updateState(e);
        REnemyRobot enemy = enemyManager.findOrCreateByName(e.getName());
        if (enemy != null) {
            ArrayList<RFiringSolution> firingSolutions;
            enemy.update(e);
            waveManager.update();
            RMoveChoice choice = movementManager.computeBestMove(enemy);
            if (choice != null) {
                RUtil.setBackAsFront(this, choice.angle, 100.0);
            }
            if (!(firingSolutions = new ArrayList<RFiringSolution>(targetingManager.getBestFiringSolutions(enemy))).isEmpty()) {
                this.lockFiringSolution(enemy, firingSolutions.get(0));
                this.simulateRemainingSolutions(enemy, firingSolutions);
            } else if (!this.processingShot) {
                this.turnGunToTarget(enemy);
            }
            if (this.attemptShot()) {
                this.processingShot = false;
            }
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        Bullet bullet = e.getBullet();
        REnemyWave wave = waveManager.getWaveForEnemyBullet(bullet);
        if (wave != null) {
            RPoint hitLocation = new RPoint(bullet.getX(), bullet.getY());
            statisticsManager.getMovementStatistics().noteHitByBullet(wave, hitLocation);
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        Bullet bullet = e.getBullet();
        REnemyRobot enemy = enemyManager.get(e.getName());
        if (enemy == null) {
            return;
        }
        RBulletWave wave = waveManager.getWaveForBullet(bullet);
        if (wave == null) {
            return;
        }
        if (!enemy.getName().equalsIgnoreCase(wave.getTarget().getName())) {
            return;
        }
    }

    public void updateState(ScannedRobotEvent e) {
        this.states.push(new RRobotState(this, e));
        if (this.states.size() > 1000) {
            this.states.removeLast();
        }
    }

    public RRobotState getCurrentState() {
        if (this.states.isEmpty()) {
            return null;
        }
        return this.states.get(0);
    }

    public RRobotState getLastState() {
        if (this.states.isEmpty()) {
            return this.getCurrentState();
        }
        return this.states.getFirst();
    }

    public RRobotState getLastUsableState() {
        if (this.states.size() < 3) {
            return this.getLastState();
        }
        return this.states.get(2);
    }

    public RPoint getLocation() {
        RRobotState state = this.getCurrentState();
        if (state == null || state.location == null) {
            return new RPoint(this.getX(), this.getY());
        }
        return state.location.getCopy();
    }

    public RPoint getCopyOfLocation() {
        return this.getLocation().getCopy();
    }

    public void onPaint(Graphics2D g) {
        if (globalBattlefield != null) {
            globalBattlefield.draw(g);
        }
        if (enemyManager != null) {
            enemyManager.draw(g);
        }
        if (waveManager != null) {
            waveManager.draw(g);
        }
        if (movementManager != null) {
            movementManager.draw(g);
        }
    }

    protected boolean attemptShot() {
        if (!this.processingShot) {
            return false;
        }
        if (this.fireTime <= this.getTime() && this.getGunTurnRemainingRadians() == 0.0) {
            if (this.lockedSolution.intendedHitLocation != null) {
                double distance = this.getLocation().distance(this.lockedSolution.intendedHitLocation);
                double desiredVelocity = distance / (double)(this.lockedSolution.anticipatedFlightTime - 1L);
                this.lockedSolution.power = RUtil.computeBulletPower(desiredVelocity);
            }
            if (this.setFireBullet(this.lockedSolution.power) != null) {
                RBulletWave wave = new RBulletWave(this.lockedEnemy, this.lockedSolution, false);
                this.lockedSolution.gun.noteShot(true);
                waveManager.add(wave);
                this.lastType = this.lockedSolution.gun.getName();
            }
            return true;
        }
        return false;
    }

    protected boolean lockFiringSolution(REnemyRobot enemy, RFiringSolution firingSolution) {
        if (!this.processingShot) {
            this.lockedEnemy = enemy;
            this.lockedSolution = firingSolution;
            this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)this.lockedSolution.firingAngle));
            this.fireTime = this.getTime() + 1L;
            this.processingShot = true;
            return true;
        }
        return false;
    }

    protected void simulateRemainingSolutions(REnemyRobot enemy, ArrayList<RFiringSolution> firingSolutions) {
        ++this.ticksSinceLastVirtualBullet;
        if (this.ticksSinceLastVirtualBullet > 2L) {
            int i = 0;
            if (firingSolutions.get(0).equals(this.lockedSolution)) {
                ++i;
            }
            while (i < firingSolutions.size()) {
                RBulletWave wave = new RBulletWave(enemy, firingSolutions.get(i), true);
                firingSolutions.get((int)i).gun.noteShot(false);
                waveManager.add(wave);
                ++i;
            }
            this.ticksSinceLastVirtualBullet = 0L;
        }
    }

    protected void turnGunToTarget(REnemyRobot enemy) {
        RRobotState enemyState = enemy.getCurrentState();
        double gunBearingToTarget = enemyState.absoluteBearing - this.getGunHeadingRadians();
        gunBearingToTarget = Utils.normalRelativeAngle((double)gunBearingToTarget);
        this.setTurnGunRightRadians(gunBearingToTarget);
    }
}

