/*
 * Decompiled with CFR 0.152.
 */
package deith;

import java.util.Vector;

public class AccuStats {
    private double[] myMiss;
    private double[] myHit;
    private double[] myProc;
    private Vector bullets = new Vector();
    private int maxTact;
    private int last = 0;
    private int round = 0;
    private int count = 0;

    public AccuStats(int m) {
        this.maxTact = m;
        this.myMiss = new double[m];
        this.myHit = new double[m];
        this.myProc = new double[m];
        for (int i = 0; i < this.myHit.length; ++i) {
            this.myHit[i] = 20.0;
            this.myMiss[i] = 100.0;
            this.myProc[i] = 0.0;
        }
    }

    public double getTacticStat(int i) {
        return this.myHit[i] / (this.myHit[i] + this.myMiss[i]) * 100.0;
    }

    public int getTactic() {
        double max = Double.MIN_VALUE;
        double min = 0.0;
        double l = Double.MIN_VALUE;
        int index = 0;
        for (int i = 0; i < this.myHit.length; ++i) {
            this.myProc[i] = this.myHit[i] / (this.myHit[i] + this.myMiss[i]);
            if (!(this.myProc[i] > max)) continue;
            max = this.myProc[i];
            index = i;
            if (min > l - this.myProc[i]) {
                min = l - this.myProc[i];
            }
            l = this.myProc[i];
        }
        if (min < 0.05 && this.count == 5) {
            index = (this.last + 1) % this.maxTact;
            this.count = 0;
        }
        this.last = index;
        return index;
    }

    public void nextRound() {
        for (int i = 0; i < this.myHit.length; ++i) {
            if (!(this.myMiss[i] > 80.0)) continue;
            this.myMiss[i] = this.myMiss[i] / 2.0;
            this.myHit[i] = this.myHit[i] / 2.0;
        }
        ++this.round;
    }

    public void fireBullet(int fireTactic) {
        this.bullets.addElement(fireTactic);
        ++this.count;
    }

    public void hitBullet() {
        if (this.bullets.size() != 0) {
            int i;
            int n = i = ((Integer)this.bullets.remove(0)).intValue();
            this.myHit[n] = this.myHit[n] + 1.0;
        }
    }

    public void missBullet() {
        if (this.bullets.size() != 0) {
            int i;
            int n = i = ((Integer)this.bullets.remove(0)).intValue();
            this.myMiss[n] = this.myMiss[n] + 1.0;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.myHit.length; ++i) {
            sb.append("Taktyka " + i + "    hits: " + this.myHit[i] + "    miss: " + this.myMiss[i]);
            sb.append("    Hits%  " + Math.round(this.myHit[i] / (this.myHit[i] + this.myMiss[i]) * 100.0) + "\n");
        }
        return sb.toString();
    }
}

