/*
 * Decompiled with CFR 0.152.
 */
package rdm.gunners;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rdm.gunners.Gunner;
import rdm.precepts.GunPrecept;
import rdm.state.entities.AggregateState;
import rdm.state.entities.InstantState;
import rdm.state.entities.State;
import robocode.Bullet;
import robocode.RobocodeFileOutputStream;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 !2\u00020\u0001:\u0002!\"B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u0016\u0010\u0012\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010H\u0002J\u0018\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0011H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J \u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u0018H\u0016J\u001f\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u0011H\u0016\u00a2\u0006\u0002\u0010\u001fJ\u0018\u0010 \u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0011H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lrdm/gunners/SamplerGunner;", "Lrdm/gunners/Gunner;", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "bulletsMap", "Ljava/util/HashMap;", "Lrobocode/Bullet;", "Lrdm/gunners/SamplerGunner$Sample;", "writer", "Ljava/io/PrintWriter;", "dispose", "", "formatBooleans", "", "booleans", "", "", "formatFloats", "", "formatMainFeatures", "sample", "hit", "handle", "Lrdm/precepts/GunPrecept;", "state", "Lrdm/state/entities/State;", "saveShot", "bullet", "precept", "saveShotResult", "(Lrobocode/Bullet;Ljava/lang/Boolean;)V", "writeSampleToFile", "Companion", "Sample", "Commons"})
public final class SamplerGunner
implements Gunner {
    private final HashMap<Bullet, Sample> bulletsMap;
    private final PrintWriter writer;
    @NotNull
    public static final String FILE_NAME = "dataset.csv";
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public GunPrecept handle(@NotNull State state) {
        Intrinsics.checkParameterIsNotNull(state, "state");
        return GunPrecept.Companion.buildRandomRotation();
    }

    @Override
    public void saveShot(@NotNull Bullet bullet, @NotNull State state, @NotNull GunPrecept precept) {
        Intrinsics.checkParameterIsNotNull(bullet, "bullet");
        Intrinsics.checkParameterIsNotNull(state, "state");
        Intrinsics.checkParameterIsNotNull(precept, "precept");
        Map map = this.bulletsMap;
        Sample sample = new Sample(state, precept);
        map.put(bullet, sample);
    }

    @Override
    public void saveShotResult(@NotNull Bullet bullet, @Nullable Boolean hit) {
        Intrinsics.checkParameterIsNotNull(bullet, "bullet");
        Boolean bl = hit;
        if (bl != null) {
            Boolean bl2 = bl;
            boolean it = bl2;
            Sample sample = this.bulletsMap.get(bullet);
            if (sample != null) {
                Sample sample2;
                Sample it2 = sample2 = sample;
                if (hit.booleanValue()) {
                    Sample sample3 = it2;
                    Intrinsics.checkExpressionValueIsNotNull(sample3, "it");
                    this.writeSampleToFile(sample3, hit);
                }
            }
        }
        this.bulletsMap.remove(bullet);
    }

    @Override
    public void dispose() {
        this.writer.close();
    }

    private final void writeSampleToFile(Sample sample, boolean hit) {
        State state;
        Sample sample2 = sample;
        State state2 = state = sample2.component1();
        AggregateState aggregate = state2.component2();
        StringBuilder builder = new StringBuilder().append(this.formatMainFeatures(sample, hit)).append(this.formatBooleans(aggregate.getBooleans())).append(this.formatFloats(aggregate.getFloats()));
        this.writer.println(builder);
    }

    /*
     * WARNING - void declaration
     */
    private final String formatMainFeatures(Sample sample, boolean hit) {
        void state;
        Sample sample2 = sample;
        State state2 = sample2.component1();
        GunPrecept precept = sample2.component2();
        void var6_6 = state;
        InstantState instant = var6_6.component1();
        double hitValue = hit ? 1.0 : 0.0;
        double bulletPower = precept.getBulletPower();
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%.1f,%.8f,%.8f";
        Object[] objectArray = new Object[]{hitValue, precept.getBulletPower(), precept.getRotation()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull(string2, "java.lang.String.format(format, *args)");
        return string2;
    }

    private final String formatBooleans(List<Boolean> booleans) {
        StringBuilder builder = new StringBuilder();
        for (boolean bl : booleans) {
            String string;
            double number = bl ? 1.0 : 0.0;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = ",%.1f";
            Object[] objectArray = new Object[]{number};
            StringBuilder stringBuilder = builder;
            Intrinsics.checkExpressionValueIsNotNull(String.format(string2, Arrays.copyOf(objectArray, objectArray.length)), "java.lang.String.format(format, *args)");
            stringBuilder.append(string);
        }
        String string = builder.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "builder.toString()");
        return string;
    }

    private final String formatFloats(List<Double> booleans) {
        StringBuilder builder = new StringBuilder();
        Iterator<Double> iterator2 = booleans.iterator();
        while (iterator2.hasNext()) {
            String string;
            double value = ((Number)iterator2.next()).doubleValue();
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = ",%.8f";
            Object[] objectArray = new Object[]{value};
            StringBuilder stringBuilder = builder;
            Intrinsics.checkExpressionValueIsNotNull(String.format(string2, Arrays.copyOf(objectArray, objectArray.length)), "java.lang.String.format(format, *args)");
            stringBuilder.append(string);
        }
        String string = builder.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "builder.toString()");
        return string;
    }

    public SamplerGunner(@NotNull File file) throws IOException {
        Intrinsics.checkParameterIsNotNull(file, "file");
        this.bulletsMap = new HashMap();
        RobocodeFileOutputStream stream = new RobocodeFileOutputStream(file.getPath(), true);
        this.writer = new PrintWriter((OutputStream)stream, true);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lrdm/gunners/SamplerGunner$Sample;", "", "state", "Lrdm/state/entities/State;", "precept", "Lrdm/precepts/GunPrecept;", "(Lrdm/state/entities/State;Lrdm/precepts/GunPrecept;)V", "getPrecept", "()Lrdm/precepts/GunPrecept;", "getState", "()Lrdm/state/entities/State;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Commons"})
    private static final class Sample {
        @NotNull
        private final State state;
        @NotNull
        private final GunPrecept precept;

        @NotNull
        public final State getState() {
            return this.state;
        }

        @NotNull
        public final GunPrecept getPrecept() {
            return this.precept;
        }

        public Sample(@NotNull State state, @NotNull GunPrecept precept) {
            Intrinsics.checkParameterIsNotNull(state, "state");
            Intrinsics.checkParameterIsNotNull(precept, "precept");
            this.state = state;
            this.precept = precept;
        }

        @NotNull
        public final State component1() {
            return this.state;
        }

        @NotNull
        public final GunPrecept component2() {
            return this.precept;
        }

        @NotNull
        public final Sample copy(@NotNull State state, @NotNull GunPrecept precept) {
            Intrinsics.checkParameterIsNotNull(state, "state");
            Intrinsics.checkParameterIsNotNull(precept, "precept");
            return new Sample(state, precept);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Sample copy$default(Sample sample, State state, GunPrecept gunPrecept, int n, Object object) {
            if ((n & 1) != 0) {
                state = sample.state;
            }
            if ((n & 2) != 0) {
                gunPrecept = sample.precept;
            }
            return sample.copy(state, gunPrecept);
        }

        public String toString() {
            return "Sample(state=" + this.state + ", precept=" + this.precept + ")";
        }

        public int hashCode() {
            State state = this.state;
            GunPrecept gunPrecept = this.precept;
            return (state != null ? ((Object)state).hashCode() : 0) * 31 + (gunPrecept != null ? ((Object)gunPrecept).hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Sample)) break block3;
                    Sample sample = (Sample)object;
                    if (!Intrinsics.areEqual(this.state, sample.state) || !Intrinsics.areEqual(this.precept, sample.precept)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lrdm/gunners/SamplerGunner$Companion;", "", "()V", "FILE_NAME", "", "Commons"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

