/*
 * Decompiled with CFR 0.152.
 */
package zh;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import robocode.Condition;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.MoveCompleteCondition;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import zh.Enemy;
import zh.EnemyManager;
import zh.UnderDog;
import zh.logging.MyLogger;

public class Navigator {
    private static MyLogger logger = MyLogger.getLogger(Navigator.class.getName());
    private UnderDog robot;
    public boolean startGameProceduresExecuted;
    private List<Point2D> WAYPOINTLIST;
    private Point2D currentWayPoint;
    private MoveCompleteCondition moveCompleteCondition;
    private boolean NORMAL_DIRECTION = true;
    private double WIDTH;
    private double HEIGHT;
    private double ROBOT_WIDTH_PADDING;
    private double ROBOT_HEIGHT_PADDING;
    private Random randomVelocity = new Random();
    private double lastDistanceSegmenterValue = 1.0;
    private double currDistanceSegmenterValue = 2.0;
    double lastKnownEnergy = 0.0;
    int FORWARD = 1;

    public Navigator(UnderDog r) {
        this.robot = r;
    }

    public void makeDecision() {
    }

    public void processEvent(CustomEvent event) {
        if (event.getCondition() instanceof MoveCompleteCondition) {
            this.currentWayPoint = this.currentWayPoint == null ? this.getClosestWayPoint() : this.getNextWayPoint();
            this.determineHeadingChangeToGoToPoint(this.currentWayPoint);
        }
    }

    private Point2D getClosestCornerPoint() {
        Point2D.Double p = new Point2D.Double(this.robot.getX() > this.WIDTH / 2.0 ? this.WIDTH : 0.0, this.robot.getY() > this.HEIGHT / 2.0 ? this.HEIGHT : 0.0);
        ((Point2D)p).setLocation(Math.abs(((Point2D)p).getX() - this.ROBOT_WIDTH_PADDING), Math.abs(((Point2D)p).getY() - this.ROBOT_HEIGHT_PADDING));
        return p;
    }

    private Point2D getClosestWayPoint() {
        Point2D nextWayPoint = null;
        for (Point2D wayPoint : this.WAYPOINTLIST) {
            if (nextWayPoint != null && !(this.robot.getLocation().distance(wayPoint) < this.robot.getLocation().distance(nextWayPoint))) continue;
            nextWayPoint = wayPoint;
        }
        return nextWayPoint;
    }

    private Point2D getNextWayPoint() {
        ArrayList<Point2D> TMP = new ArrayList<Point2D>(this.WAYPOINTLIST);
        if (!this.NORMAL_DIRECTION) {
            Collections.reverse(TMP);
        }
        Point2D nextWayPoint = null;
        if (this.currentWayPoint == null || ((Point2D)TMP.get(TMP.size() - 1)).equals(this.currentWayPoint)) {
            nextWayPoint = (Point2D)TMP.get(0);
        } else {
            boolean foundCurrent = false;
            for (Point2D wayPoint : TMP) {
                if (wayPoint.equals(this.currentWayPoint)) {
                    foundCurrent = true;
                    continue;
                }
                if (!foundCurrent) continue;
                nextWayPoint = wayPoint;
                break;
            }
        }
        return nextWayPoint;
    }

    private void determineHeadingChangeToGoToPoint(Point2D destination) {
        this.determineHeadingChangeToGoToPoint(destination, true);
    }

    private double determineHeadingChangeToGoToPoint(Point2D destination, boolean goToLocation) {
        double distance = this.getDistanceToPointFromCurrent(destination);
        double angle = this.normalRelativeAngle(this.absoluteBearing(destination) - this.robot.getHeading());
        if (Math.abs(angle) > 90.0) {
            distance *= -1.0;
            angle = angle > 0.0 ? (angle -= 180.0) : (angle += 180.0);
        }
        this.robot.setTurnRight(angle);
        if (goToLocation) {
            this.robot.setAhead(distance);
        }
        logger.log(Level.FINE, "setTurnRight(" + angle + ")");
        logger.log(Level.FINE, "setAhead(" + distance + ")");
        return distance;
    }

    private void setRobotAheadMovement(double distance, double modByValue) {
        double remainder = distance % modByValue;
        double modifiedDistance = distance - remainder;
        boolean remainderUsed = false;
        double tempDist = 0.0;
        for (double i = 0.0; i < modByValue; i += 1.0) {
            if (!remainderUsed) {
                remainderUsed = true;
                this.robot.setAhead(tempDist += modifiedDistance / modByValue + remainder);
                continue;
            }
            tempDist += modifiedDistance / modByValue;
            this.robot.setAhead(modifiedDistance / modByValue);
        }
    }

    private double getNextSegmenterValue() {
        if (this.lastDistanceSegmenterValue < this.currDistanceSegmenterValue) {
            if (this.currDistanceSegmenterValue < 4.0) {
                this.lastDistanceSegmenterValue = this.currDistanceSegmenterValue;
                this.currDistanceSegmenterValue += 1.0;
            } else {
                this.lastDistanceSegmenterValue = this.currDistanceSegmenterValue;
                this.currDistanceSegmenterValue -= 1.0;
            }
        } else if (this.lastDistanceSegmenterValue > this.currDistanceSegmenterValue) {
            if (this.currDistanceSegmenterValue > 1.0) {
                this.lastDistanceSegmenterValue = this.currDistanceSegmenterValue;
                this.currDistanceSegmenterValue -= 1.0;
            } else if (this.currDistanceSegmenterValue <= 1.0) {
                this.lastDistanceSegmenterValue = 0.0;
            }
        }
        return this.currDistanceSegmenterValue;
    }

    private double getNextRandomVelocity() {
        return 50.0 * this.randomVelocity.nextDouble();
    }

    private double absoluteBearing(Point2D target) {
        double dx = target.getX() - this.robot.getX();
        double dy = target.getY() - this.robot.getY();
        double theta = Math.toDegrees(Math.atan2(dx, dy));
        return theta;
    }

    private double normalRelativeAngle(double angle) {
        angle = Math.toRadians(angle);
        double returnvalue = Math.toDegrees(Math.atan2(Math.sin(angle), Math.cos(angle)));
        return returnvalue;
    }

    private double getDistanceToPointFromCurrent(Point2D otherPoint) {
        return Point2D.distance(this.robot.getX(), this.robot.getY(), otherPoint.getX(), otherPoint.getY());
    }

    public void processEvent(ScannedRobotEvent event) {
        this.lastKnownEnergy = event.getEnergy();
        if (this.robot.getDistanceRemaining() == 0.0) {
            this.FORWARD = -this.FORWARD;
            double forwardValue = 185.0 * Math.random() * (double)this.FORWARD;
            this.robot.setAhead(forwardValue);
            System.out.println("forwardValue: " + forwardValue);
        }
        this.robot.setTurnRightRadians(event.getBearingRadians() + 1.5707963267948966 - 0.5236 * (double)this.FORWARD * (double)(event.getDistance() > 200.0 ? 1 : -1));
    }

    public void processEvent(HitByBulletEvent event) {
    }

    public void processEvent(HitRobotEvent event) {
        Enemy enemy = EnemyManager.getInstance().getEnemy(event.getName());
        boolean goBackward = false;
        double turnRightAmount = 45.0;
        if (event.getBearing() > -90.0 && event.getBearing() < 90.0) {
            boolean bl = goBackward = this.robot.getDistanceRemaining() >= 0.0;
            if (goBackward) {
                turnRightAmount = -45.0;
            }
        }
        this.robot.setAhead(goBackward ? -200 : 200);
        if (this.robot.getTurnRemaining() == 0.0) {
            this.robot.setTurnRight(turnRightAmount);
        }
        this.NORMAL_DIRECTION = !this.NORMAL_DIRECTION;
    }

    public void processEvent(HitWallEvent event) {
        System.out.println("hit wall dr: " + this.robot.getDistanceRemaining());
        if (this.robot.getDistanceRemaining() == 0.0) {
            this.FORWARD = -this.FORWARD;
            double forwardValue = 185.0 * Math.random() * (double)this.FORWARD;
            this.robot.setAhead(forwardValue);
            System.out.println("forwardValue: " + forwardValue);
        }
    }

    public void processEvent(DeathEvent event) {
        this.reset();
    }

    public void processEvent(WinEvent event) {
        this.reset();
    }

    private void reset() {
        this.startGameProceduresExecuted = false;
        this.currentWayPoint = null;
        this.NORMAL_DIRECTION = true;
        this.robot.removeCustomEvent((Condition)this.moveCompleteCondition);
    }

    public void onPaint(Graphics2D g) {
        g.setColor(Color.RED);
        double CIRCLE_SIZE = 25.0;
        Object circle = null;
        for (Point2D pt : this.WAYPOINTLIST) {
            g.fill(new Ellipse2D.Double(pt.getX() + CIRCLE_SIZE / 2.0, pt.getY() + CIRCLE_SIZE / 2.0, CIRCLE_SIZE, CIRCLE_SIZE));
        }
    }

    public static void main(String[] args) {
        boolean y = false;
        Random randomVelocity = new Random();
        for (int i = 0; i < 100; ++i) {
            System.out.println("randomVelocity.nextDouble(): " + 3.0 * randomVelocity.nextDouble());
        }
    }

    static {
        logger.setEnabled(true);
        logger.setLevel(Level.FINER);
    }
}

