/*
 * Decompiled with CFR 0.152.
 */
package pedersen.divination;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import pedersen.debug.DebuggableBase;
import pedersen.debug.renderable.GraphicalDebugger;
import pedersen.divination.CombatWave;
import pedersen.divination.WaveOutboundImpl;
import pedersen.physics.Position;
import pedersen.physics.Radius;
import pedersen.physics.constant.CircleImpl;
import pedersen.physics.constant.PositionImpl;
import pedersen.systems.notifier.NotificationSubsystem;
import pedersen.systems.notifier.OnPaint;
import pedersen.systems.notifier.OnRound;
import pedersen.systems.notifier.OnTurn;
import pedersen.util.Constraints;
import robocode.Bullet;

public class BulletBank
extends DebuggableBase
implements OnRound,
OnTurn,
OnPaint {
    private static final boolean debug = false;
    private final Map<Bullet, WaveOutboundImpl> outbound = new HashMap<Bullet, WaveOutboundImpl>();
    private static final BulletBank singleton = new BulletBank();

    private BulletBank() {
        NotificationSubsystem.getInstance().subscribeOnRound(this);
    }

    public static BulletBank getInstance() {
        return singleton;
    }

    public void add(Bullet key, WaveOutboundImpl value) {
        this.outbound.put(key, value);
    }

    public void remove(Bullet key) {
        this.outbound.remove(key);
    }

    public CombatWave find(Bullet key) {
        return this.outbound.get(key);
    }

    public boolean contains(WaveOutboundImpl value) {
        return this.outbound.containsValue(value);
    }

    @Override
    public void onRound(int round) {
        this.outbound.clear();
    }

    @Override
    public void onTurn(long turn) {
        for (Map.Entry<Bullet, WaveOutboundImpl> e : this.outbound.entrySet()) {
            Bullet b = e.getKey();
            WaveOutboundImpl w = e.getValue();
            boolean velocityMatches = Constraints.areEqual(b.getVelocity(), w.velocity());
            if (!velocityMatches) {
                this.consoleTick("Velocity of bullet ( " + b.getVelocity() + " ) does not match velocity of wave ( " + w.velocity() + " ).");
            }
            Radius r = w.getCircle(turn).getRadius();
            Position pW = w.getPosition().addVector(b.getHeadingRadians(), r.radius());
            PositionImpl pB = new PositionImpl(b.getX(), b.getY());
            boolean positionMatches = pB.equalsPosition(pW);
            if (positionMatches) continue;
            this.consoleTick("Bullet x/y " + pB.description() + " does not match projected x/y " + pW.description() + " from wave origin " + w.getPosition().description() + " with heading " + b.getHeadingRadians() + ".");
            Position pBO = pB.addVector(b.getHeadingRadians(), -r.radius());
            this.consoleTick("Calculated bullet origin: " + pBO.getPosition().description());
        }
    }

    @Override
    public void paint() {
        for (Bullet bullet : this.outbound.keySet()) {
            CircleImpl c = new CircleImpl(bullet.getX(), bullet.getY(), 3.0);
            GraphicalDebugger.addCircleTurnScope(c, Color.orange);
        }
    }
}

