/*
 * Decompiled with CFR 0.152.
 */
package pedersen.divination.segmentation;

import pedersen.divination.CombatWave;
import pedersen.divination.TargetAnalysis;
import pedersen.divination.segmentation.FixedSegment;
import pedersen.divination.segmentation.ScalableSegment;
import pedersen.divination.segmentation.Segment;
import pedersen.util.Constraints;

public enum Segmentation implements Segment
{
    LATERAL_7(ScalableSegment.LATERAL_VELOCITY, 7),
    CLOSING_7(ScalableSegment.CLOSING_VELOCITY, 7),
    VELOCITY_7(ScalableSegment.VELOCITY, 7),
    BULLET_POWER_5(ScalableSegment.BULLET_POWER, 5),
    BULLET_FLIGHT_TIME_10(ScalableSegment.BULLET_FLIGHT_TIME, 10),
    WALL_CW(FixedSegment.WALL_DISTANCE_CLOCKWISE),
    WALL_CC(FixedSegment.WALL_DISTANCE_COUNTERCLOCKWISE);

    private final Segment s;
    private final int arraySize;

    private Segmentation(FixedSegment s) {
        this.s = s;
        this.arraySize = s.slices;
    }

    private Segmentation(ScalableSegment s, int slices) {
        this.s = s;
        if (slices % 2 == 0) {
            ++slices;
        }
        this.arraySize = slices;
    }

    @Override
    public int getIndex(CombatWave wave, TargetAnalysis targetAnalysis, int slices) {
        int result = this.s.getIndex(wave, targetAnalysis, this.arraySize);
        if (!Constraints.isInRange(0, result, this.arraySize - 1)) {
            result = Math.max(0, Math.min(result, this.arraySize - 1));
        }
        return result;
    }

    @Override
    public void debug(CombatWave wave, TargetAnalysis targetAnalysis) {
        this.s.debug(wave, targetAnalysis);
    }

    public int getArraySize() {
        return this.arraySize;
    }
}

