/*
 * Decompiled with CFR 0.152.
 */
package alk.lap.strategy;

import alk.lap.LoudAndProud;
import alk.lap.strategy.ScanDatabase;
import alk.lap.strategy.targetting.BulletBeam;
import alk.lap.strategy.targetting.TargetStrategy;
import alk.lap.utils.DVektor;
import java.util.ArrayList;

public class FireWave {
    public DVektor emittingPosition;
    public DVektor proudsPositionAtEmission;
    public double proudsHeadingAtEmission;
    public double proudsVelocityAtEmission;
    public String label;
    private BulletBeam[] possibleBulletVelocities;
    public double power;
    public double bulletVelocity;
    public int maxAge;
    private LoudAndProud proud;
    private static String names = "ABCDEFGHIKL";
    private static int currentName = 0;
    private long emittingTime;

    protected FireWave() {
    }

    public FireWave(double power, LoudAndProud proud) {
        this.proud = proud;
        this.power = power;
        this.emittingPosition = proud.getTacticLead().getEnemyPos().copy();
        this.label = "(" + names.substring(currentName, currentName + 1) + ")";
        currentName = (currentName + 1) % 10;
        ScanDatabase scanbase = proud.getStrategicLead().getAnalystsDB().getScanBase();
        this.proudsPositionAtEmission = scanbase.getLastProudState().pos;
        this.proudsVelocityAtEmission = scanbase.getLastProudState().atomicMove.velocity;
        this.proudsHeadingAtEmission = scanbase.getLastProudState().atomicMove.heading;
        this.emittingTime = scanbase.getLastProudState().getScanTime();
        double fieldWidth = proud.getBattleFieldWidth();
        double fieldHeight = proud.getBattleFieldHeight();
        double mostDistX = 0.0;
        double mostDistY = 0.0;
        if (this.emittingPosition.x < fieldWidth / 2.0) {
            mostDistX = fieldWidth;
        }
        if (this.emittingPosition.y < fieldHeight / 2.0) {
            mostDistY = fieldHeight;
        }
        this.bulletVelocity = 20.0 - 3.0 * power;
        this.maxAge = (int)Math.round(DVektor.sub(this.emittingPosition, new DVektor(mostDistX, mostDistY)).getLength() / this.bulletVelocity);
        TargetStrategy[] strategies = proud.getTacticLead().getEnemyTargetStrategies();
        ArrayList<BulletBeam> bulletBeams = new ArrayList<BulletBeam>();
        int i = 0;
        while (i < strategies.length) {
            TargetStrategy strategy = strategies[i];
            double[] angles = strategy.getFireAngleTo(1, this);
            int j = 0;
            while (j < angles.length) {
                bulletBeams.add(new BulletBeam(DVektor.fromPolarCoord(angles[j], this.bulletVelocity), strategy.getBeamAngle(), strategy));
                ++j;
            }
            ++i;
        }
        this.possibleBulletVelocities = new BulletBeam[bulletBeams.size()];
        i = 0;
        for (BulletBeam beam : bulletBeams) {
            this.possibleBulletVelocities[i++] = beam;
        }
    }

    public void increment() {
        this.proud.getVc().drawCircle(this.emittingPosition, this.getCurrentRadius(), this.label);
    }

    private long getAge() {
        return this.proud.getTime() - this.emittingTime;
    }

    public double getCurrentRadius() {
        return this.bulletVelocity * (double)this.getAge();
    }

    public boolean isValid() {
        boolean proudIsPassed;
        double distanceToProud = DVektor.sub(this.emittingPosition, this.proud.getPosition()).getLength() + this.proud.getProudsRadius();
        boolean bl = proudIsPassed = this.getCurrentRadius() > distanceToProud;
        if (proudIsPassed) {
            double deltaToEmission = this.emittingPosition.getDirectionTo(this.proud.getPosition()) - this.emittingPosition.getDirectionTo(this.proudsPositionAtEmission);
            this.proud.getStrategicLead().getAnalystsDB().incrementProudHitAngleAtBearing(deltaToEmission);
            if (!this.proud.getTacticLead().isHitThisRound()) {
                this.proud.getStrategicLead().getAnalystsDB().rewardAvoiding();
            }
        }
        return this.getAge() < (long)this.maxAge && !proudIsPassed;
    }

    public DVektor bulletPosAt(long time, DVektor v) {
        return DVektor.add(this.emittingPosition, DVektor.scaleVector(v, this.getAge() + time));
    }

    public BulletBeam getBulletV(int stratNum) {
        return this.possibleBulletVelocities[stratNum];
    }

    public BulletBeam[] getPossibleBulletVelocities() {
        return this.possibleBulletVelocities;
    }
}

