/*
 * Decompiled with CFR 0.152.
 */
package justin.movement;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import justin.BulletInfoEnemy;
import justin.Enemy;
import justin.Module;
import justin.Movement;
import justin.movement.Destination;
import justin.utils.DRUtils;
import justin.utils.FastTrig;
import justin.utils.MovSim;
import justin.utils.MovSimStat;
import robocode.Rules;

public class PathFinderMelee
extends Movement {
    public static final int SIM_LENGTH = 30;
    public static final double WAVE_SURFING_WEIGHT = 13.0;
    public static final double MIN_RISK_WEIGHT = 10000.0;
    public static final double REPEL_WEIGHT = 0.0;
    public static final double HBW = 20.0;
    public static Point2D.Double bfCenter;
    public static Polygon diamond;
    public Point2D.Double myLocation;
    public Destination currentDestination;
    public static MovSim sim;
    public MovSimStat[] testSim;
    public MovSimStat[] saveSimResult;
    public Polygon poly;
    Point2D.Double closestCorner;
    public boolean switchOn = true;
    public double switchDir = 1.0;
    public double addRepelPoint = 1.0;
    public int timer = 1;

    public PathFinderMelee(Module bot) {
        super(bot);
    }

    @Override
    public void initialize() {
        bfCenter = new Point2D.Double(Module.bw / 2.0, Module.bh / 2.0);
        diamond = new Polygon();
        diamond.addPoint((int)Module.bw / 2, (int)Module.bh);
        diamond.addPoint((int)Module.bw, (int)Module.bh / 2);
        diamond.addPoint((int)Module.bw / 2, 0);
        diamond.addPoint(0, (int)Module.bh / 2);
        this.closestCorner = new Point2D.Double(0.0, 0.0);
        this.currentDestination = new Destination(this.myLocation, Double.POSITIVE_INFINITY, 0.0);
        this.timer = 1;
        sim = new MovSim();
    }

    @Override
    public void move() {
        Destination nextDestination;
        this.myLocation = new Point2D.Double(this.bot.getX(), this.bot.getY());
        if (!Module.melee && this.bot.enemyBullets.size() < 1 && this.bot.enemy.name != null && (this.bot.myData.energy <= 2.0 || Rules.getBulletDamage((double)this.bot.enemy.energy) < this.bot.myData.energy * 2.0)) {
            DRUtils.driveTo(this.bot.enemy.location, this.bot);
            return;
        }
        if (Math.random() < 0.06) {
            this.switchDir *= -1.0;
            this.switchOn = !this.switchOn;
        }
        if (Module.enemies.size() == 0) {
            return;
        }
        ArrayList<Destination> testLocations = new ArrayList<Destination>();
        testLocations.addAll(this.generateLocations());
        this.currentDestination = nextDestination = this.getLeastRisk(testLocations);
        DRUtils.driveTo(nextDestination.location, this.bot);
    }

    public void setClosestCorner() {
        if (this.bot.myData.location.distance(0.0, 0.0) < this.bot.myData.location.distance(this.closestCorner)) {
            this.closestCorner = new Point2D.Double(0.0, 0.0);
        }
        if (this.bot.myData.location.distance(0.0, Module.bh) < this.bot.myData.location.distance(this.closestCorner)) {
            this.closestCorner = new Point2D.Double(0.0, Module.bh);
        }
        if (this.bot.myData.location.distance(Module.bw, 0.0) < this.bot.myData.location.distance(this.closestCorner)) {
            this.closestCorner = new Point2D.Double(Module.bw, 0.0);
        }
        if (this.bot.myData.location.distance(Module.bw, Module.bh) < this.bot.myData.location.distance(this.closestCorner)) {
            this.closestCorner = new Point2D.Double(Module.bw, Module.bh);
        }
    }

    protected ArrayList<Destination> generateLocations() {
        ArrayList<Destination> destinations = new ArrayList<Destination>();
        int NumOfDirections = Math.max(23, 31 - Module.skippedTurns);
        double sliceSize = Math.PI * 2 / (double)NumOfDirections;
        int i = 0;
        while (i < NumOfDirections) {
            double angle = (double)i * sliceSize;
            double testDist = Math.min(this.bot.myData.cbD * 0.9, 90.0 + 125.0 * Math.random());
            Point2D.Double testLoc = FastTrig.project(this.bot.myData.location, angle, testDist);
            if (Module.bf.contains(testLoc)) {
                Destination test = this.testDestination(testLoc, angle);
                destinations.add(test);
            }
            ++i;
        }
        return destinations;
    }

    protected Destination getLeastRisk(ArrayList<Destination> loc) {
        Destination leastRisk = this.currentDestination;
        double lowestRisk = Double.POSITIVE_INFINITY;
        for (Destination d : loc) {
            if (!(d.risk < lowestRisk)) continue;
            lowestRisk = d.risk;
            leastRisk = d;
        }
        return leastRisk;
    }

    protected Destination testDestination(Point2D.Double destination, double goAngle) {
        Destination test = this.simulate(30, destination, goAngle);
        boolean onlyOnce = false;
        for (Enemy e : Module.enemies.values()) {
            if (!e.alive) continue;
            double distanceSq = destination.distanceSq(e.location);
            double angle = 1.0 + Math.abs(FastTrig.cos(e.absBearingRadians - goAngle));
            double health = DRUtils.limit(0.6, e.energy / this.bot.myData.energy, 1.8);
            double threatLevel = DRUtils.limit(0.7, e.myThreatLevel / e.hisThreatLevel - 0.2, 1.8);
            double closer = e.distance / e.cbD;
            double diamondSpace = 1.0;
            if (Module.melee && this.switchOn) {
                diamondSpace = diamond.contains(destination) ? (this.bot.getTime() < 35L ? 1.7 : 1.08) : 1.0;
            }
            double protectCorner = 1.0;
            if (this.bot.myData.location.distance(this.closestCorner) * 1.4 > e.location.distance(this.closestCorner) && !onlyOnce) {
                onlyOnce = true;
                protectCorner = DRUtils.limit(0.85, this.bot.myData.location.distance(this.closestCorner) / destination.distance(this.closestCorner), 1.3);
            }
            test.risk += 10000.0 * angle * health / (distanceSq * protectCorner * closer * threatLevel / diamondSpace);
        }
        return test;
    }

    public int getClosestBotCountFrom(Point2D.Double testLoc, Enemy scan) {
        int cbC = 0;
        for (Enemy e : Module.enemies.values()) {
            if (!e.alive || !(testLoc.distance(scan.location) > e.location.distance(scan.location)) || e.name == scan.name) continue;
            ++cbC;
        }
        return cbC;
    }

    public Destination simulate(int testTurns, Point2D.Double estimateLocation, double testHeading) {
        ArrayList<Integer> waveHitBuffer = new ArrayList<Integer>();
        int waveHitCounter = 0;
        double damage = 0.0;
        double normaliseDamage = 0.0;
        Point2D.Double simLocation = bfCenter;
        DRUtils.driveTo(estimateLocation, this.bot);
        this.testSim = sim.futurePos(testTurns, this.bot, 8.0, 10.0);
        int i = 0;
        while (i < this.testSim.length) {
            if (waveHitCounter > 2) break;
            simLocation = new Point2D.Double(this.testSim[i].x, this.testSim[i].y);
            if (this.testSim[i].x < 20.0 || this.testSim[i].y < 20.0 || this.testSim[i].x > Module.bw - 20.0 || this.testSim[i].y > Module.bh - 20.0) {
                return new Destination(simLocation, Double.MAX_VALUE, testHeading, this.testSim);
            }
            int xx = 0;
            while (xx < this.bot.enemyBullets.size()) {
                if (waveHitCounter > 2) break;
                BulletInfoEnemy bullet = this.bot.enemyBullets.get(xx);
                double distanceTraveled = bullet.distanceTraveled + (double)i * bullet.velocity;
                if (bullet.surf && !waveHitBuffer.contains(xx) && Math.abs(distanceTraveled - simLocation.distance(bullet.fireLocation)) < 18.0) {
                    waveHitBuffer.add(xx);
                    double bulletWeight = Module.melee ? 1.0 : 1.0 / Math.pow(++waveHitCounter, 2.0);
                    normaliseDamage += bulletWeight;
                    Point2D.Double left = FastTrig.project(simLocation, FastTrig.absoluteBearing(bullet.fireLocation, simLocation) - 1.5707963267948966, 18.0);
                    Point2D.Double right = FastTrig.project(simLocation, FastTrig.absoluteBearing(bullet.fireLocation, simLocation) + 1.5707963267948966, 18.0);
                    int indexL = BulletInfoEnemy.getBinIndex(bullet, left);
                    int indexM = BulletInfoEnemy.getBinIndex(bullet, simLocation);
                    int indexR = BulletInfoEnemy.getBinIndex(bullet, right);
                    double avgDamage = 0.0;
                    avgDamage += bullet.DCWave[indexL];
                    avgDamage += bullet.DCWave[indexM];
                    avgDamage += bullet.DCWave[indexR];
                    avgDamage += bullet.buffer[indexL];
                    avgDamage += bullet.buffer[indexM];
                    avgDamage += bullet.buffer[indexR];
                    damage += (avgDamage /= 6.0) * bulletWeight;
                }
                ++xx;
            }
            ++i;
        }
        return new Destination(simLocation, damage > 0.0 ? damage / normaliseDamage * 13.0 : 0.0, testHeading, this.testSim);
    }

    public void reduceVelocityForTurnRateDegrees(double degreesPerTurn) {
        this.bot.setMaxVelocity((10.0 - degreesPerTurn) / 0.75);
    }

    @Override
    public void onPaint(Graphics2D g) {
    }

    public void drawRisks(ArrayList<Destination> destinations) {
        double lowestRisk = Double.POSITIVE_INFINITY;
        double highestRisk = Double.NEGATIVE_INFINITY;
        Iterator<Destination> destIterator = destinations.iterator();
        double[] risks = new double[destinations.size()];
        int x = 0;
        while (destIterator.hasNext()) {
            Destination d = destIterator.next();
            risks[x++] = d.risk;
            if (d.risk < lowestRisk) {
                lowestRisk = d.risk;
            }
            if (!(d.risk > highestRisk)) continue;
            highestRisk = d.risk;
        }
        double avg = PathFinderMelee.average(risks);
        double stDev = PathFinderMelee.standardDeviation(risks);
        destIterator = destinations.iterator();
        Graphics2D g = this.bot.getGraphics();
        while (destIterator.hasNext()) {
            Destination d = destIterator.next();
            g.fillOval((int)d.location.x - 1, (int)d.location.y - 1, 2, 2);
            Color color = PathFinderMelee.riskColor(d.risk - lowestRisk, avg - lowestRisk, stDev, false, 2.0);
            g.setColor(color);
            g.fillOval((int)d.location.x - 4, (int)d.location.y - 4, 8, 8);
        }
    }

    public static Color riskColor(double risk, double avg, double stDev, boolean safestYellow, double maxStDev) {
        if (Math.abs(stDev) - Math.abs(avg) < 1.0E-7) {
            return Color.blue;
        }
        if (risk < 1.0E-7 && safestYellow) {
            return Color.yellow;
        }
        return new Color((int)DRUtils.limit(0.0, 255.0 * (risk - (avg - maxStDev * stDev)) / (2.0 * maxStDev * stDev), 255.0), 0, (int)DRUtils.limit(0.0, 255.0 * (avg + maxStDev * stDev - risk) / (2.0 * maxStDev * stDev), 255.0));
    }

    public static double standardDeviation(double[] values) {
        double avg = PathFinderMelee.average(values);
        double sumSquares = 0.0;
        int x = 0;
        while (x < values.length) {
            sumSquares += DRUtils.square(avg - values[x]);
            ++x;
        }
        return Math.sqrt(sumSquares / (double)values.length);
    }

    public static double average(double[] values) {
        double sum = 0.0;
        int x = 0;
        while (x < values.length) {
            sum += values[x];
            ++x;
        }
        return sum / (double)values.length;
    }
}

