/*
 * Decompiled with CFR 0.152.
 */
package jekl;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.FileInputStream;
import java.util.Hashtable;
import java.util.Properties;
import jekl.gunnery.FireManager;
import jekl.intelligence.Enemy;
import jekl.intelligence.Scanner;
import jekl.navigation.MovementManager;
import jekl.util.BotHelp;
import jekl.util.Constants;
import jekl.util.ScoreKeeper;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.Robot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.TeamRobot;
import robocode.WinEvent;

public class Jekyl
extends TeamRobot
implements Constants {
    public boolean DEBUG;
    Enemy target;
    Hashtable targets;
    int wallStrikes = 0;
    int skippedTurns = 0;
    int bulletHitBullet = 0;
    MovementManager navigator;
    FireManager shooter;
    ScoreKeeper scoreKeeper;
    Scanner scanner;
    Properties props;

    public void run() {
        block5: {
            this.target = new Enemy();
            this.targets = new Hashtable();
            this.target.setDistance(100000.0);
            this.setColors(Color.red, Color.lightGray, Color.black);
            this.navigator = new MovementManager(this);
            this.shooter = new FireManager(this);
            this.scanner = new Scanner(this);
            this.scoreKeeper = new ScoreKeeper(this);
            this.skippedTurns = 0;
            this.setAdjustGunForRobotTurn(true);
            this.setAdjustRadarForGunTurn(true);
            this.turnRadarRightRadians(Math.PI * 2);
            this.props = new Properties();
            try {
                this.props.load(new FileInputStream(this.getDataFile("Jekyl.properties")));
            }
            catch (Exception e) {
                if (!this.DEBUG) break block5;
                System.out.print("Failed to load Poperties: ");
                e.printStackTrace();
            }
        }
        this.DEBUG = this.props.getProperty("debug", "false").equalsIgnoreCase("true");
        while (true) {
            this.scanner.doTurn();
            if (!this.props.getProperty("behavior", "normal").equalsIgnoreCase("reference")) {
                this.navigator.doMovement();
            }
            if (!this.props.getProperty("behavior", "normal").equalsIgnoreCase("challenge")) {
                this.shooter.shoot();
            }
            this.scoreKeeper.setMyEnergy(this.getEnergy());
            this.scoreKeeper.setEnemyEnergy(this.getTarget().getEnergy());
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        Enemy en;
        if (this.targets.containsKey(e.getName())) {
            en = (Enemy)this.targets.get(e.getName());
        } else {
            if (this.isTeammate(e.getName())) {
                return;
            }
            en = new Enemy();
            this.targets.put(e.getName(), en);
        }
        double absBearing = (this.getHeadingRadians() + e.getBearingRadians()) % (Math.PI * 2);
        en.setName(e.getName());
        double h = BotHelp.normaliseBearing(e.getHeadingRadians() - en.getHeading());
        en.setChangehead(h /= (double)(this.getTime() - en.getLastScanTime()));
        en.setX(this.getX() + Math.sin(absBearing) * e.getDistance());
        en.setY(this.getY() + Math.cos(absBearing) * e.getDistance());
        en.setBearing(e.getBearingRadians());
        en.setHeading(e.getHeadingRadians());
        en.setAbsBearing(absBearing);
        en.setLastScanTime(this.getTime());
        en.setVelocity(e.getVelocity());
        en.setDistance(e.getDistance());
        en.setEnergy(e.getEnergy());
        en.incrementScanEvents();
        en.incrementCumulativeVelocity(e.getVelocity());
        en.incrementCumulativeDistance(e.getDistance());
        double arcMovement = e.getVelocity() * Math.sin(e.getHeadingRadians() - absBearing);
        en.setArcMovement(arcMovement);
        en.addArcHistory(arcMovement);
        en.appendPattern(arcMovement);
        if (en.getDistance() < this.target.getDistance() || !this.target.isLive()) {
            this.target = en;
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        this.scoreKeeper.onBulletHit(e);
        if (this.isTeammate(e.getName())) {
            return;
        }
        if (this.targets.keySet().contains(e.getName())) {
            Enemy t = (Enemy)this.targets.get(e.getName());
            t.incrementHits();
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.navigator.notifyOfHit();
        this.scoreKeeper.onHitByBullet(e);
    }

    public void onHitRobotEvent(HitRobotEvent e) {
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        ++this.bulletHitBullet;
    }

    public void onRobotDeath(RobotDeathEvent e) {
        if (this.isTeammate(e.getName())) {
            return;
        }
        if (this.targets.keySet().contains(e.getName())) {
            ((Enemy)this.targets.get(e.getName())).setLive(false);
            ((Enemy)this.targets.get(e.getName())).setTurnOfDeath(this.getTime());
            if (this.target.getName().equalsIgnoreCase(e.getName())) {
                this.target.setDistance(10000.0);
            }
        }
    }

    public void onHitWall(HitWallEvent e) {
        ++this.wallStrikes;
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
        ++this.skippedTurns;
    }

    public void onDeath(DeathEvent event) {
        this.scoreKeeper.onDeath(event);
        if (this.DEBUG) {
            this.scoreKeeper.printScore();
            ((Robot)this).out.println("DE Hit percentage: " + (double)this.target.getHits() / (double)this.target.getShotsAt() * 100.0 + " Avg BullPow: " + this.target.getAverageBulletPower());
            ((Robot)this).out.println("Average distance: " + this.target.getAverageDistance());
            ((Robot)this).out.println(">>I have hit " + this.wallStrikes + " walls. I have skipped " + this.skippedTurns + " turns");
        }
        if (this.getRoundNum() + 1 == this.getNumRounds()) {
            System.out.println("ME: " + this.getMyScore() + " HIM: " + this.getEnemyScore() + " PCTG: " + this.getMyScore() / (this.getMyScore() + this.getEnemyScore()));
            this.shooter.saveData();
        }
    }

    public void onWin(WinEvent event) {
        this.scoreKeeper.onWin(event);
        if (this.DEBUG) {
            this.scoreKeeper.printScore();
            ((Robot)this).out.println("WE Hit percentage: " + ((double)this.target.getHits() + 1.0) / (double)this.target.getShotsAt() * 100.0 + " Avg BullPow: " + this.target.getAverageBulletPower());
            ((Robot)this).out.println("Average distance: " + this.target.getAverageDistance());
            ((Robot)this).out.println(">>I have hit " + this.wallStrikes + " walls. I have skipped " + this.skippedTurns + " turns");
        }
        if (this.getRoundNum() + 1 == this.getNumRounds()) {
            System.out.println("ME: " + this.getMyScore() + " HIM: " + this.getEnemyScore() + " PCTG: " + this.getMyScore() / (this.getMyScore() + this.getEnemyScore()));
            this.shooter.saveData();
        }
    }

    public Enemy getTarget() {
        return this.target;
    }

    public Hashtable getTargets() {
        return this.targets;
    }

    public Point2D.Double getCurrentLoc() {
        return new Point2D.Double(this.getX(), this.getY());
    }

    public Properties getProps() {
        return this.props;
    }

    public double getMyScore() {
        return this.scoreKeeper.getMyScore();
    }

    public double getEnemyScore() {
        return this.scoreKeeper.getEnemyScore();
    }

    public double getWinPercentage() {
        return this.getMyScore() / (this.getMyScore() + this.getEnemyScore());
    }
}

