/*
 * Decompiled with CFR 0.152.
 */
package vStar;

import java.awt.Color;
import java.awt.Graphics2D;
import robocode.AdvancedRobot;

class PointCommon {
    private double x;
    private double y;

    public double get_x() {
        return this.x;
    }

    public double get_y() {
        return this.y;
    }

    protected void set_location(PointCommon sample_point) {
        this.x = sample_point.x;
        this.y = sample_point.y;
    }

    public PointCommon() {
    }

    public PointCommon(double x_koord, double y_koord) {
        this.x = x_koord;
        this.y = y_koord;
    }

    public PointCommon(AdvancedRobot tank) {
        this.x = tank.getX();
        this.y = tank.getY();
    }

    public PointCommon(PointCommon copy_from_me) {
        this.x = copy_from_me.x;
        this.y = copy_from_me.y;
    }

    public String as_text() {
        return String.format("%.2f : %.2f", this.x, this.y);
    }

    public double get_heading(PointCommon target) {
        double angle = Math.atan((target.x - this.x) / (target.y - this.y));
        if (target.y - this.y < 0.0) {
            angle += Math.PI;
        }
        return angle;
    }

    public double get_distance_to(PointCommon another_point) {
        return Math.sqrt(Math.pow(this.x - another_point.x, 2.0) + Math.pow(this.y - another_point.y, 2.0));
    }

    public boolean is_in_circle(PointCommon center, double radiuss) {
        return this.get_distance_to(center) < radiuss;
    }

    public boolean is_in_square(PointCommon bottom_left, PointCommon top_right) {
        return this.y < top_right.y && this.y > bottom_left.y && this.x < top_right.x && this.x > bottom_left.x;
    }

    public boolean is_in_battle_field(AdvancedRobot tank, double offset) {
        return this.is_in_square(new PointCommon(offset, offset), new PointCommon(tank.getBattleFieldWidth() - offset, tank.getBattleFieldHeight() - offset));
    }

    public boolean is_in_battle_field(AdvancedRobot tank) {
        return this.is_in_battle_field(tank, 0.0);
    }

    protected void _move_to_direction(double distance, double angle) {
        this.x += distance * Math.sin(angle);
        this.y += distance * Math.cos(angle);
    }

    public void draw_point(Graphics2D graf, Color fill_color, int radius) {
        graf.setColor(fill_color);
        int diameter = 2 * radius;
        graf.fillOval((int)this.x - radius, (int)this.y - radius, diameter, diameter);
    }
}

