/*
 * Decompiled with CFR 0.152.
 */
package rdt.AgentSmith.Guns.GunImplementations;

import rdt.AgentSmith.Guns.Gun;
import rdt.AgentSmith.IRobot;
import rdt.AgentSmith.RobotHistory.RobotHistory;
import rdt.AgentSmith.RobotHistory.RobotSnapshot;
import rdt.AgentSmith.Stats.IStats;
import rdt.AgentSmith.Utils.MathUtils;
import robocode.util.Utils;

public class IterativeLinearWithWallStopping
extends Gun {
    public IterativeLinearWithWallStopping(String ownerName, IRobot robot, RobotHistory targetHistory, IStats stats, long firingTickOffset) {
        super(ownerName + " : Iterative Linear with Wall Stopping", robot, targetHistory, stats, firingTickOffset);
    }

    @Override
    public double GetFiringAngle(double sourceX, double sourceY, long firingTick, double bulletVelocity) {
        double dY;
        double dX;
        double distanceToTargetSq;
        RobotSnapshot snapshot = this.GetFiringSnapshot(firingTick);
        double enemyHeading = snapshot.AbsoluteHeading;
        double enemyVelocity = snapshot.VelocityAlongHeading;
        double battleFieldWidth = this._robot.getBattleFieldWidth();
        double battleFieldHeight = this._robot.getBattleFieldHeight();
        double predictedX = snapshot.LocationX;
        double predictedY = snapshot.LocationY;
        double distanceTravelled = 0.0;
        while (!((distanceTravelled += bulletVelocity) * distanceTravelled > (distanceToTargetSq = (dX = predictedX - sourceX) * dX + (dY = predictedY - sourceY) * dY))) {
            predictedY += MathUtils.FastCos(enemyHeading) * enemyVelocity;
            if (!((predictedX += MathUtils.FastSin(enemyHeading) * enemyVelocity) < 18.0 || predictedY < 18.0 || predictedX > battleFieldWidth - 18.0) && !(predictedY > battleFieldHeight - 18.0)) continue;
            predictedX = Math.min(Math.max(18.0, predictedX), battleFieldWidth - 18.0);
            predictedY = Math.min(Math.max(18.0, predictedY), battleFieldHeight - 18.0);
            break;
        }
        return Utils.normalAbsoluteAngle((double)Math.atan2(predictedX - sourceX, predictedY - sourceY));
    }
}

