/*
 * Decompiled with CFR 0.152.
 */
package learn;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import learn.BotToStudy;
import learn.ISmart;
import learn.Net;
import learn.Utilities;
import robocode.util.Utils;

class SurfHandler {
    ISmart Is;
    Utilities utils;
    BotToStudy enemy;
    Net myNet;
    List<Integer> topology;
    static List<SurfHandler> surfGroup = new ArrayList<SurfHandler>();
    static HashMap<double[], Double> offsetMap = new HashMap();
    static List<double[]> neighborList = new ArrayList<double[]>();
    static double e = Math.E;
    double[] dataPoint = new double[8];
    double velocity;
    double maxEscapeAngle;
    double lastVelocity;
    Point2D.Double position;
    Point2D.Double desiredPosition;
    Point2D.Double shotPosition;
    double heading;
    double distance;
    double distTravelled;
    double bPower;
    double bSpeed;
    double lastShotPower;
    double absBearing;
    double absAngle;
    long shotTime;
    int moveDir;
    boolean isReal;
    int latDirection = 1;
    int lastLatDirection = 1;
    int goDir = 1;
    SurfHandler lastWave;
    SurfHandler currentWave;

    SurfHandler(ISmart type1, Utilities type2, BotToStudy type3) {
        this.Is = type1;
        this.utils = type2;
        this.enemy = type3;
        surfGroup.clear();
        this.myNet = ISmart.moveNet;
        this.topology = ISmart.moveTopology;
    }

    SurfHandler() {
    }

    void update() {
        this.velocity = this.Is.velocity;
        this.position = this.Is.position;
        this.heading = this.Is.heading;
        this.distance = this.enemy.distance;
        this.latDirection = this.velocity != 0.0 ? this.utils.sign(this.velocity) * this.utils.sign(this.enemy.absBearing) : this.lastLatDirection;
        this.lastLatDirection = this.latDirection;
        this.bPower = this.enemy.lastEnergy - this.enemy.energy;
        if (this.bPower <= 3.0 && this.bPower > 0.0) {
            this.spawnWave(this.bPower, true);
            this.lastShotPower = this.bPower;
        }
        this.enemy.lastEnergy = this.enemy.energy;
        this.advanceWaves();
        this.dataPoint[0] = Math.abs(this.velocity) / 8.0;
        this.dataPoint[1] = this.distance / this.Is.greatestDist;
        this.dataPoint[2] = (this.enemy.bearing - this.enemy.lastBearing) / 0.17453292519943295 * 0.5 + 0.5;
        this.dataPoint[3] = this.lastShotPower / 3.0;
        this.dataPoint[4] = (this.velocity - this.lastVelocity) / 2.0 * 0.5 + 0.5;
        this.dataPoint[6] = this.enemy.bearing / Math.PI * 0.5 + 0.5;
        this.dataPoint[5] = 0.0;
        this.currentWave = this.getClosestSurfableWave();
        if (!this.currentWave.equals(this.lastWave)) {
            neighborList = this.utils.getNearestNeighbors(offsetMap.keySet(), this.currentWave.dataPoint, Math.min(offsetMap.keySet().size(), 7) - 1);
        }
        this.lastWave = this.currentWave;
        this.lastVelocity = this.velocity;
        if (!surfGroup.isEmpty()) {
            this.drive(this.getDesiredPosition(this.currentWave));
        } else {
            this.Is.setTurnRightRadians(this.getTurnAmount(this.enemy.absBearingFrom + 1.5707963267948966 - 0.241660973353061 * (double)this.goDir, this.position, this.heading, this.utils.sign(this.velocity)));
            Point2D.Double projectSpot = this.utils.project(this.position, 120 * this.utils.sign(this.velocity), this.heading);
            if (!this.Is.playField.contains(projectSpot) && projectSpot.distance(this.enemy.position) < this.position.distance(this.enemy.position)) {
                this.goDir *= -1;
            }
            this.Is.setMaxVelocity(Math.PI / this.Is.getTurnRemainingRadians());
            this.Is.setAhead(100 * this.goDir);
        }
    }

    void spawnWave(double shotPow, boolean real) {
        SurfHandler sWave = new SurfHandler();
        sWave.velocity = this.Is.getVelocity();
        sWave.shotPosition = this.enemy.position;
        sWave.position = this.Is.position;
        sWave.shotTime = this.Is.getTime();
        sWave.distance = this.enemy.distance;
        sWave.bPower = shotPow;
        sWave.bSpeed = this.utils.bSpeed(this.bPower);
        sWave.latDirection = this.velocity * this.enemy.bearing >= 0.0 ? 1 : -1;
        sWave.maxEscapeAngle = Math.asin(8.0 / sWave.bSpeed) * (double)sWave.latDirection;
        sWave.absBearing = this.enemy.absBearingFrom;
        sWave.absAngle = Utils.normalAbsoluteAngle((double)sWave.absBearing);
        sWave.isReal = real;
        sWave.dataPoint[0] = Math.abs(sWave.velocity) / 8.0;
        sWave.dataPoint[1] = sWave.distance / this.Is.greatestDist;
        sWave.dataPoint[2] = (this.enemy.bearing - this.enemy.lastBearing) / 0.17453292519943295 * 0.5 + 0.5;
        sWave.dataPoint[3] = shotPow / 3.0;
        sWave.dataPoint[4] = (this.velocity - this.lastVelocity) / 2.0 * 0.5 + 0.5;
        sWave.dataPoint[6] = this.enemy.bearing / Math.PI * 0.5 + 0.5;
        sWave.dataPoint[5] = 0.0;
        surfGroup.add(sWave);
    }

    void advanceWaves() {
        int i = 0;
        while (i < surfGroup.size()) {
            SurfHandler wave = surfGroup.get(i);
            boolean discard = this.checkWave(wave);
            if (discard) {
                this.storeEvent(this.Is.position, true);
                --i;
            }
            ++i;
        }
    }

    boolean checkWave(SurfHandler wave) {
        wave.distTravelled = (double)(this.Is.getTime() - wave.shotTime) * wave.bSpeed;
        return wave.distTravelled >= wave.shotPosition.distance(this.position) - 16.0;
    }

    Point2D.Double getDesiredPosition(SurfHandler wave) {
        double[] directions;
        double desiredAngle = Utils.normalRelativeAngle((double)(this.enemy.bearing + 1.5707963267948966 - 0.241660973353061 * (double)this.utils.sign(this.velocity)));
        double IsrnAmount = this.getTurnAmount(desiredAngle, this.position, this.heading, this.utils.sign(this.velocity));
        Point2D.Double idealSpot = this.utils.project(this.position, 120.0 * (double)this.utils.sign(this.velocity), this.heading);
        boolean interrupted = false;
        double projectedVelocity = this.velocity;
        double projectedHeading = this.heading;
        Point2D.Double tempSpot = this.position;
        long itterations = 1L;
        ArrayList<Point2D.Double> spotList = new ArrayList<Point2D.Double>();
        if (this.velocity <= 1.0) {
            spotList.add(this.position);
        }
        double[] dArray = directions = new double[]{-1 * wave.latDirection, 1 * wave.latDirection};
        int n = directions.length;
        int n2 = 0;
        while (n2 < n) {
            double dir = dArray[n2];
            projectedVelocity = this.Is.velocity;
            projectedHeading = this.Is.heading;
            tempSpot = this.Is.position;
            this.velocity = this.Is.velocity;
            itterations = 1L;
            interrupted = false;
            while (!interrupted) {
                desiredAngle = Utils.normalAbsoluteAngle((double)(this.utils.getAbsAngle(wave.shotPosition, tempSpot) + 1.5707963267948966 - 0.241660973353061 * (double)this.utils.sign(projectedVelocity)));
                projectedVelocity += dir * projectedVelocity >= 0.0 ? dir : 2.0 * dir;
                projectedVelocity = this.utils.limit(-8.0, projectedVelocity, 8.0);
                IsrnAmount = this.getTurnAmount(desiredAngle, tempSpot, projectedHeading, this.utils.sign(projectedVelocity));
                double maxIsrn = 0.004363323129985824 * (40.0 - 3.0 * Math.abs(projectedVelocity));
                IsrnAmount = this.utils.limit(-1.0 * maxIsrn, IsrnAmount, maxIsrn);
                projectedHeading = Utils.normalAbsoluteAngle((double)(projectedHeading + IsrnAmount));
                tempSpot = this.utils.project(tempSpot, projectedVelocity, projectedHeading);
                spotList.add(tempSpot);
                double distTrav = wave.distTravelled + wave.bSpeed * (double)itterations;
                if (tempSpot.distance(wave.shotPosition) - 16.0 < distTrav) {
                    interrupted = true;
                }
                ++itterations;
            }
            ++n2;
        }
        double danger = 0.0;
        double minDanger = 100000.0;
        for (Point2D.Double dSpot : spotList) {
            danger = this.getDanger(wave, dSpot);
            if (!(danger < minDanger)) continue;
            minDanger = danger;
            idealSpot = dSpot;
        }
        return idealSpot;
    }

    double getTurnAmount(double desired, Point2D.Double source, double tempHeading, int dir) {
        long itterations = 0L;
        double IsrnAmountTemp = Utils.normalRelativeAngle((double)(desired - tempHeading));
        if (IsrnAmountTemp > 1.5707963267948966 || IsrnAmountTemp < -1.5707963267948966) {
            dir *= -1;
        }
        while (!this.Is.playField.contains(this.utils.project(source, 120.0 * (double)dir, tempHeading + IsrnAmountTemp)) && itterations < 158L) {
            IsrnAmountTemp += 0.01 * (double)dir;
            ++itterations;
        }
        return Utils.normalRelativeAngle((double)IsrnAmountTemp);
    }

    double getDanger(SurfHandler wave, Point2D.Double testSpot) {
        double danger = 0.0;
        double ratio = 0.0;
        double angleFrom = Utils.normalRelativeAngle((double)this.utils.getAbsBearing(wave.shotPosition, testSpot));
        double botWidth = 36.0 / wave.shotPosition.distance(testSpot);
        for (double[] dataKey : neighborList) {
            this.utils.distanceSquared(dataKey, wave.dataPoint);
            double angleFrom2 = this.getThetaForData(dataKey, wave, testSpot);
            ratio = Utils.normalRelativeAngle((double)(angleFrom2 - angleFrom)) / botWidth;
            danger += Math.pow(e, -0.5 * this.utils.sqr(ratio));
        }
        return danger;
    }

    double getThetaForData(double[] key, SurfHandler wave, Point2D.Double spot) {
        return Utils.normalRelativeAngle((double)(offsetMap.get(key) * wave.maxEscapeAngle + wave.absBearing));
    }

    SurfHandler getClosestSurfableWave() {
        SurfHandler closeWave = new SurfHandler();
        double shortestTime = this.Is.greatestDist;
        for (SurfHandler wave : surfGroup) {
            double timeTillHit = (wave.shotPosition.distance(this.position) - wave.distTravelled - wave.bSpeed) / wave.bSpeed;
            if (!(timeTillHit < shortestTime)) continue;
            shortestTime = timeTillHit;
            closeWave = wave;
        }
        return closeWave;
    }

    SurfHandler getClosestSurfWave(Point2D.Double spot) {
        double dist = 0.0;
        double shortestDist = this.Is.greatestDist;
        SurfHandler closeWave = new SurfHandler();
        for (SurfHandler wave : surfGroup) {
            double absoluteDist = spot.distance(wave.shotPosition);
            dist = absoluteDist - wave.distTravelled;
            if (!(Math.abs(dist) < shortestDist)) continue;
            closeWave = wave;
            shortestDist = dist;
        }
        return closeWave;
    }

    void storeEvent(Point2D.Double hitSpot, boolean remove) {
        SurfHandler culprit = this.getClosestSurfWave(hitSpot);
        if (culprit.shotPosition != null) {
            this.storeWave(culprit, hitSpot);
            if (!remove) {
                culprit.dataPoint[5] = 1.0E-5;
            }
            if (remove) {
                surfGroup.remove(surfGroup.indexOf(culprit));
            } else {
                int index = surfGroup.indexOf(culprit);
                surfGroup.set(index, culprit);
            }
        } else {
            this.Is.out.println("dropped A Wave");
        }
    }

    void storeWave(SurfHandler wave, Point2D.Double hitPos) {
        double offset = this.getOffset(wave, hitPos);
        offsetMap.put(wave.dataPoint, offset);
    }

    double getOffset(SurfHandler wave, Point2D.Double hitPos) {
        double resultBearing = this.utils.getAbsAngle(wave.shotPosition, hitPos);
        double bearingDiff = Utils.normalRelativeAngle((double)(resultBearing - wave.absAngle));
        return this.utils.limit(-1.0, bearingDiff / wave.maxEscapeAngle, 1.0);
    }

    void drive(Point2D.Double target) {
        double driveAngle = this.utils.getAbsAngle(this.Is.position, target);
        double deltaTheta = Utils.normalRelativeAngle((double)(driveAngle - this.heading));
        int direction = 1;
        double distance = target.distance(this.Is.position);
        if (deltaTheta > 1.5707963267948966 || deltaTheta < -1.5707963267948966) {
            direction = -1;
        }
        this.moveDir = direction;
        this.Is.setTurnRightRadians(deltaTheta * (double)direction * Math.signum(distance));
        if (Math.signum(distance) == 0.0) {
            this.Is.setTurnRightRadians(this.getTurnAmount(this.enemy.absBearingFrom + 1.5707963267948966, this.Is.position, this.Is.heading, this.utils.sign(this.Is.velocity)));
        }
        this.Is.setAhead(distance * (double)direction);
        this.Is.setMaxVelocity(8.0);
    }
}

