/*
 * Decompiled with CFR 0.152.
 */
package et;

import et.Location;

public class Area
extends Location {
    private Location center;
    private double width = 0.0;
    private double height = 0.0;
    private double diagonal = 0.0;

    public Area(double d, double d2, double d3, double d4) {
        super(d, d2);
        this.width = d3;
        this.height = d4;
        this.diagonal = Math.sqrt(d3 * d3 + d4 * d4);
        this.center = new Location(this.getCenterX(), this.getCenterY());
    }

    public void setRect(double d, double d2, double d3, double d4) {
        super.setLocation(d, d2);
        this.width = d3;
        this.height = d4;
        this.diagonal = Math.sqrt(d3 * d3 + d4 * d4);
    }

    public final int relativeToLocation(Location location, double d) {
        if (location == null) {
            return -1;
        }
        int n = 0;
        int n2 = 0;
        if (location.getX() + d >= this.getX() + this.getWidth()) {
            n = 4;
        } else if (this.getX() >= location.getX() - d) {
            n = 1;
        }
        if (location.getY() + d >= this.getY() + this.getHeight()) {
            n2 = 2;
        } else if (this.getY() >= location.getY() - d) {
            n2 = 8;
        }
        return n + n2;
    }

    public final Location getCenter() {
        this.center.setLocation(this.getCenterX(), this.getCenterY());
        return this.center;
    }

    public final double getCenterX() {
        return super.getX() + this.width / 2.0;
    }

    public final double getCenterY() {
        return super.getY() + this.height / 2.0;
    }

    public final double getHeight() {
        return this.height;
    }

    public final double getWidth() {
        return this.width;
    }

    public final double getDiagonal() {
        return this.diagonal;
    }

    public String toString() {
        return super.toString() + ", (w:" + (int)this.getWidth() + ", h:" + (int)this.getHeight() + ")";
    }
}

