/*
 * Decompiled with CFR 0.152.
 */
package DM.mega;

import DM.mega.Bezier;
import DM.mega.Future;
import DM.mega.HammerToss;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class BanHammer {
    static final int BINS = 73;
    static final int ACCEL_SEGS = 3;
    static final int DIST_SEGS = 5;
    static final int VEL_SEGS = 5;
    static final int WALL_DIST_SEGS = 9;
    static final int HEAD_SEGS = 4;
    static final int B_POWER_SEGS = 3;
    static final int ACCEL_BIN = 0;
    static final int DIST_BIN = 1;
    static final int VEL_BIN = 2;
    static final int WALL_BIN = 3;
    static final int REV_WALL_BIN = 4;
    static final int HEAD_BIN = 5;
    static final int BULLET_BIN = 6;
    private static float[][][][][][][][] stats = new float[3][5][5][9][9][4][3][73];
    private static double[][][][][][][] weights = new double[2][2][2][2][2][2][2];
    private final HashMap<float[], Double> flatMap;
    final List<HammerToss> waves;
    final AdvancedRobot self;
    final Point2D.Double enemyPos;
    final Point2D.Double myCenter;
    private final List<Future> _futures;
    final double distSegSize = 200.0;
    final double wallDistSegSize = 111.11111111111111;
    final double WALL_STICK = 20.0;
    final int MAX_MAP_SIZE = 155;
    final int SHRINK_TARGET = 154;
    final int NUM_NEIGHBORS = 8;
    double[] guessFactors;
    double bPower;
    double oldVelocity;
    double healthDisadvantage;
    double mainAcc = 1.0;
    double flatAcc = 0.9;
    double shotPower;
    double knnConfidence;
    double vcsConfidence;
    double confidence;
    double realAcc;
    double realHits;
    double realShots;
    double eVelocity;
    double maxOffset;
    double minOffset;
    double maxCrimp;
    double minCrimp;
    long timeToShoot;
    long passCount;
    int eDir;
    int eLatDir;
    int mainGunUses;
    int flattenerUses;
    int shots;
    int mainHits;
    int flatHits;
    float currDistSeg;
    float currWallSeg;
    float revWallSeg;
    float currVelSeg;
    float accelSeg;
    float headSeg;
    float bPowerSeg;
    float lastWDSeg;
    float lastRevWDSeg;
    float lastDSeg;
    float lastVSeg;
    float lastASeg;
    float lastHSeg;
    float lastBPSeg;
    boolean usedFlattenerGun;
    boolean isMC;

    public BanHammer(AdvancedRobot advancedRobot, boolean bl) {
        this.self = advancedRobot;
        this.waves = new ArrayList<HammerToss>();
        this.flatMap = new HashMap();
        this.enemyPos = new Point2D.Double(advancedRobot.getBattleFieldWidth() / 2.0, advancedRobot.getBattleFieldHeight() / 2.0);
        this.myCenter = new Point2D.Double(this.enemyPos.x, this.enemyPos.y);
        this._futures = new ArrayList<Future>();
        this.shotPower = 0.1;
        this.eDir = 1;
        this.isMC = bl;
    }

    public Bullet update(ScannedRobotEvent scannedRobotEvent, double d) {
        Bullet bullet;
        this.healthDisadvantage = Math.min(3.0, Math.max(-3.0, (scannedRobotEvent.getEnergy() - this.self.getEnergy()) / 25.0));
        double d2 = 2.0 * Math.atan(18.0 / scannedRobotEvent.getDistance());
        if (this.timeToShoot == this.self.getTime() && this.self.getGunTurnRemainingRadians() <= 0.0 && (this.bPower < this.self.getEnergy() && this.bPower > 0.0 || this.isMC) && this.self.getGunHeat() == 0.0) {
            bullet = this.self.setFireBullet(this.bPower);
            this.shotPower = this.bPower;
            if (bullet != null) {
                this.waves.add(new HammerToss(this.self.getX(), this.self.getY(), d, Rules.getBulletSpeed((double)this.shotPower), this.self.getTime(), this.eLatDir, this.currDistSeg, this.currVelSeg, this.accelSeg, this.currWallSeg, this.revWallSeg, this.headSeg, this.bPowerSeg, true, this.guessFactors[0], this.guessFactors[1], this.minCrimp, this.maxCrimp, this.minOffset, this.maxOffset));
                if (this.usedFlattenerGun) {
                    ++this.flattenerUses;
                } else {
                    ++this.mainGunUses;
                }
            }
        } else {
            bullet = null;
        }
        Iterator<HammerToss> iterator = this.waves.iterator();
        while (iterator.hasNext()) {
            HammerToss hammerToss = iterator.next();
            if (!hammerToss.checkHit(this.enemyPos, this.self.getTime())) continue;
            iterator.remove();
            this.storeWave(hammerToss, this.enemyPos);
            ++this.passCount;
        }
        this.confidence = this.vcsConfidence;
        if (this.flatAcc > this.mainAcc) {
            this.confidence = this.knnConfidence;
        }
        this.bPower = 1.9 - 0.1 * (this.healthDisadvantage + 2.0);
        if (this.self.getEnergy() < 3.0) {
            this.bPower = 0.1;
        } else if (this.self.getEnergy() < 7.0) {
            this.bPower = 0.2;
        } else if (this.self.getEnergy() < 12.0) {
            this.bPower = 0.4;
        } else if (this.self.getEnergy() < 16.0) {
            this.bPower -= 1.0;
        }
        if (scannedRobotEvent.getDistance() < 105.0) {
            this.bPower = (1.0 - (scannedRobotEvent.getDistance() - 36.0) / 100.0) * (3.0 - this.bPower) + this.bPower;
        }
        if (scannedRobotEvent.getEnergy() < (16.0 + Rules.getBulletDamage((double)this.bPower)) / 2.0) {
            this.bPower = (scannedRobotEvent.getEnergy() + 2.0) / 6.0;
            if (scannedRobotEvent.getEnergy() <= 4.0) {
                this.bPower = Math.max(0.1, scannedRobotEvent.getEnergy() / 4.0);
            }
        }
        this.bPower = this.limit(0.0, Math.min(this.bPower, this.self.getEnergy() - 0.1), 3.0);
        if (this.isMC) {
            this.bPower = Math.min(this.self.getEnergy(), 3.0);
        }
        this.myCenter.x = this.self.getX();
        this.myCenter.y = this.self.getY();
        this.enemyPos.x = this.myCenter.x + Math.sin(d) * scannedRobotEvent.getDistance();
        this.enemyPos.y = this.myCenter.y + Math.cos(d) * scannedRobotEvent.getDistance();
        this.eDir = scannedRobotEvent.getVelocity() == 0.0 ? this.eDir : (scannedRobotEvent.getVelocity() > 0.0 ? 1 : -1);
        this.eVelocity = scannedRobotEvent.getVelocity();
        this.eLatDir = Math.sin(scannedRobotEvent.getHeadingRadians() - d) * this.eVelocity == 0.0 ? this.eLatDir : (Math.sin(scannedRobotEvent.getHeadingRadians() - d) * scannedRobotEvent.getVelocity() > 0.0 ? 1 : -1);
        this.guessFactors = this.decideGun(scannedRobotEvent, d, d2);
        double d3 = this.guessFactors[0];
        this.usedFlattenerGun = false;
        if (this.flatAcc > this.mainAcc) {
            this.usedFlattenerGun = true;
            d3 = this.guessFactors[1];
        }
        double d4 = (double)this.eLatDir * d3 * Math.asin(8.0 / (20.0 - 3.0 * this.bPower));
        this.self.setTurnGunLeftRadians(Utils.normalRelativeAngle((double)(this.self.getGunHeadingRadians() - d - d4)));
        this.timeToShoot = this.self.getTime() + 1L;
        return bullet;
    }

    private double[] decideGun(ScannedRobotEvent scannedRobotEvent, double d, double d2) {
        int n;
        double d3 = this.eDir < 0 ? Math.PI + scannedRobotEvent.getHeadingRadians() : scannedRobotEvent.getHeadingRadians();
        Point2D.Double[] doubleArray = this.getMaxPosAndCrimps();
        if (this.eDir < 0) {
            this.maxOffset = this.calcOffset(doubleArray[0], d);
            this.minOffset = this.calcOffset(doubleArray[1], d);
            this.maxCrimp = this.calcOffset(doubleArray[2], d);
            this.minCrimp = this.calcOffset(doubleArray[3], d);
        } else {
            this.maxOffset = this.calcOffset(doubleArray[1], d);
            this.minOffset = this.calcOffset(doubleArray[0], d);
            this.maxCrimp = this.calcOffset(doubleArray[3], d);
            this.minCrimp = this.calcOffset(doubleArray[2], d);
        }
        this.currDistSeg = (float)Math.min(4.0, scannedRobotEvent.getDistance() / 200.0);
        this.currVelSeg = (float)(Math.abs(scannedRobotEvent.getVelocity()) / 1.6199999999999999);
        this.accelSeg = Math.min(Double.compare(Math.abs(scannedRobotEvent.getVelocity()), Math.abs(this.oldVelocity)) + 1, 2);
        this.headSeg = (float)Math.min(3.0, Math.abs(Math.sin(scannedRobotEvent.getHeadingRadians() - d)) * 4.0);
        double d4 = Utils.normalAbsoluteAngle((double)d3) < Math.PI ? (this.self.getBattleFieldWidth() - this.enemyPos.x) / Math.cos(1.5707963267948966 - d3) : this.enemyPos.x / Math.cos(4.71238898038469 - d3);
        double d5 = Math.abs(Utils.normalRelativeAngle((double)d3)) < 1.5707963267948966 ? (this.self.getBattleFieldHeight() - this.enemyPos.y) / Math.cos(d3) : this.enemyPos.y / Math.cos(Math.PI - d3);
        this.currWallSeg = Math.max(0.0f, Math.min(8.0f, (float)(Math.min(d4, d5) / 111.11111111111111)));
        d3 += Math.PI;
        d3 = Utils.normalRelativeAngle((double)d3);
        double d6 = Utils.normalAbsoluteAngle((double)d3) < Math.PI ? (this.self.getBattleFieldWidth() - this.enemyPos.x) / Math.cos(1.5707963267948966 - d3) : this.enemyPos.x / Math.cos(4.71238898038469 - d3);
        double d7 = Math.abs(Utils.normalRelativeAngle((double)d3)) < 1.5707963267948966 ? (this.self.getBattleFieldHeight() - this.enemyPos.y) / Math.cos(d3) : this.enemyPos.y / Math.cos(Math.PI - Utils.normalAbsoluteAngle((double)d3));
        this.revWallSeg = Math.max(0.0f, Math.min(8.0f, (float)(Math.min(d6, d7) / 111.11111111111111)));
        this.bPowerSeg = (float)(this.bPower / 3.01 * 3.0);
        this.oldVelocity = scannedRobotEvent.getVelocity();
        float[] fArray = stats[(int)this.accelSeg][(int)this.currDistSeg][(int)this.currVelSeg][(int)this.currWallSeg][(int)this.revWallSeg][(int)this.headSeg][(int)this.bPowerSeg];
        int n2 = (int)(d2 / (2.0 * Math.asin(8.0 / Rules.getBulletSpeed((double)this.bPower))) * 73.0);
        if ((n2 & 1) == 0) {
            ++n2;
        }
        int n3 = 63;
        double d8 = 0.0;
        double d9 = 0.0;
        for (n = 0; n < 73; ++n) {
            d9 += (double)fArray[n];
        }
        for (n = 0; n < 73; ++n) {
            double d10 = 0.0;
            for (int i = n - (n2 - 1) / 2; i <= n + (n2 - 1) / 2; ++i) {
                d10 += (double)fArray[this.limit(0, i, 72)];
            }
            if (!(d10 > d8)) continue;
            d8 = d10;
            n3 = n;
        }
        this.vcsConfidence = d8 / Math.max(0.01, d9);
        double d11 = (double)(n3 - 36) / 36.0;
        d11 = d11 < this.minCrimp ? this.minOffset * (d11 - this.minCrimp) + this.minCrimp : (d11 > this.maxCrimp ? this.maxOffset * (d11 - this.maxCrimp) + this.maxCrimp : d11);
        float[] fArray4 = new float[]{this.accelSeg, this.currDistSeg, this.currVelSeg, this.currWallSeg, this.revWallSeg, this.headSeg, this.bPowerSeg};
        List list = this.flatMap.keySet().stream().sorted((fArray2, fArray3) -> Double.compare(this.manDistBetween((float[])fArray2, fArray4), this.manDistBetween((float[])fArray3, fArray4))).limit(8L).collect(Collectors.toList());
        double d12 = d2 / Math.asin(8.0 / Rules.getBulletSpeed((double)this.bPower)) / 2.0;
        double d13 = 0.0;
        double d14 = 0.0;
        d9 = 8.0;
        for (int i = 0; i < 73; ++i) {
            double d15 = 0.0;
            double d16 = 1.0;
            for (float[] fArray5 : list) {
                double d17 = this.flatMap.get(fArray5);
                for (int j = i - (n2 - 1) / 2; j <= i + (n2 - 1) / 2; ++j) {
                    double d18 = (double)(j - 36) / 36.0;
                    d15 += Math.exp(-0.5 * ((d18 - d17) * (d18 - d17) / (d12 * d12))) * d16;
                }
                d16 *= 0.9;
            }
            if (!(d15 > d13)) continue;
            d13 = d15;
            d14 = (double)(i - 36) / 36.0;
        }
        d14 = d14 < this.minCrimp ? this.minOffset * (d14 - this.minCrimp) + this.minCrimp : (d14 > this.maxCrimp ? this.maxOffset * (d14 - this.maxCrimp) + this.maxCrimp : d14);
        this.knnConfidence = d13 / Math.max(1.0E-5, d9);
        this.lastDSeg = this.currDistSeg;
        this.lastVSeg = this.currVelSeg;
        this.lastASeg = this.accelSeg;
        this.lastWDSeg = this.currWallSeg;
        this.lastRevWDSeg = this.revWallSeg;
        this.lastHSeg = this.headSeg;
        this.lastBPSeg = this.bPowerSeg;
        return new double[]{d11, d14};
    }

    private void storeWave(HammerToss hammerToss, Point2D.Double double_) {
        double d = Math.atan2(this.enemyPos.x - hammerToss.sourceX(), this.enemyPos.y - hammerToss.sourceY());
        double d2 = Utils.normalRelativeAngle((double)(d - hammerToss.groundHeading));
        double d3 = Math.max(-1.0, Math.min(1.0, d2 / hammerToss.mEA)) * (double)hammerToss.dir;
        d3 = d3 > hammerToss.maxCrimp ? (d3 - hammerToss.maxCrimp) / hammerToss.maxFactor + hammerToss.maxCrimp : (d3 < hammerToss.minCrimp ? (d3 - hammerToss.minCrimp) / hammerToss.minFactor + hammerToss.minCrimp : d3);
        int n = (int)Math.round(36.0 * (d3 + 1.0));
        double d4 = 2.0 * Math.atan(18.0 / this.enemyPos.distance(new Point2D.Double(hammerToss.sourceX(), hammerToss.sourceY())));
        double d5 = 2.0 * hammerToss.mEA / 73.0;
        double d6 = d4 / d5;
        double d7 = d6 / 2.0;
        int n2 = (int)Math.ceil(d6);
        ++this.shots;
        if (Math.abs(Utils.normalRelativeAngle((double)(hammerToss.mainGunFactor * hammerToss.mEA * (double)hammerToss.dir - d3 * hammerToss.mEA * (double)hammerToss.dir))) < d4 / 2.0) {
            ++this.mainHits;
        }
        if (Math.abs(Utils.normalRelativeAngle((double)(hammerToss.flatGunFactor * hammerToss.mEA * (double)hammerToss.dir - d3 * hammerToss.mEA * (double)hammerToss.dir))) < d4 / 2.0) {
            ++this.flatHits;
        }
        this.mainAcc = (double)this.mainHits / (double)this.shots;
        this.flatAcc = (double)this.flatHits / (double)this.shots;
        for (int i = Math.max(0, n - (n2 - 1)); i < Math.min(73, n + (n2 - 1) + 1); ++i) {
            double d8 = Math.exp(-0.5 * ((double)((i - n) * (i - n)) / (d7 * d7)));
            for (int j = Math.max(0, (int)hammerToss.accelSeg - 1); j < Math.min(3, (int)hammerToss.accelSeg + 2); ++j) {
                int n3 = Math.abs((int)hammerToss.accelSeg - j);
                for (int k = Math.max(0, (int)hammerToss.distSeg - 1); k < Math.min(5, (int)hammerToss.distSeg + 2); ++k) {
                    int n4 = Math.abs(k - (int)hammerToss.distSeg);
                    for (int i2 = Math.max(0, (int)hammerToss.velSeg - 1); i2 < Math.min(5, (int)hammerToss.velSeg + 2); ++i2) {
                        int n5 = Math.abs(i2 - (int)hammerToss.velSeg);
                        for (int i3 = Math.max(0, (int)hammerToss.wallSpaceSeg - 1); i3 < Math.min(9, (int)hammerToss.wallSpaceSeg + 2); ++i3) {
                            int n6 = Math.abs(i3 - (int)hammerToss.wallSpaceSeg);
                            for (int i4 = Math.max(0, (int)hammerToss.revWallSeg - 1); i4 < Math.min(9, (int)hammerToss.revWallSeg + 2); ++i4) {
                                int n7 = Math.abs(i4 - (int)hammerToss.revWallSeg);
                                for (int i5 = Math.max(0, (int)hammerToss.headSeg - 1); i5 < Math.min(4, (int)hammerToss.headSeg + 2); ++i5) {
                                    int n8 = Math.abs(i5 - (int)hammerToss.headSeg);
                                    for (int i6 = Math.max(0, (int)hammerToss.bPowerSeg - 1); i6 < Math.min(3, (int)hammerToss.bPowerSeg + 2); ++i6) {
                                        int n9 = Math.abs(i6 - (int)hammerToss.bPowerSeg);
                                        float[] fArray = stats[j][k][i2][i3][i4][i5][i6];
                                        int n10 = i;
                                        fArray[n10] = fArray[n10] + (float)(weights[n3][n4][n5][n6][n7][n8][n9] * d8);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        this.flatMap.put(new float[]{this.self.getRoundNum(), this.self.getTime(), hammerToss.accelSeg, hammerToss.distSeg, hammerToss.velSeg, hammerToss.wallSpaceSeg, hammerToss.revWallSeg, hammerToss.headSeg, hammerToss.bPowerSeg}, d3);
    }

    public void rackOneUp() {
        this.realHits += 1.0;
    }

    float manDistBetween(float[] fArray, float[] fArray2) {
        return 2.0f * Math.abs(fArray[2] - fArray2[0]) + Math.abs(fArray[3] - fArray2[1]) + Math.abs(fArray[4] - fArray2[2]) + Math.abs(fArray[5] - fArray2[3]) + Math.abs(fArray[6] - fArray2[4]) + Math.abs(fArray[7] - fArray2[5]) / 2.0f + Math.abs(fArray[8] - fArray2[6]);
    }

    double limit(double d, double d2, double d3) {
        return Math.max(d, Math.min(d2, d3));
    }

    int limit(int n, int n2, int n3) {
        return Math.max(n, Math.min(n2, n3));
    }

    double sign(double d) {
        return Double.compare(d, 0.0);
    }

    private double calcOffset(Point2D.Double double_, double d) {
        double d2 = Math.asin(8.0 / Rules.getBulletSpeed((double)this.bPower));
        double d3 = Math.atan2(double_.x - this.myCenter.x, double_.y - this.myCenter.y);
        return this.limit(-1.0, Utils.normalRelativeAngle((double)(d3 - d)) / d2, 1.0) * (double)this.eLatDir;
    }

    private Point2D.Double[] getMaxPosAndCrimps() {
        Point2D.Double double_ = new Point2D.Double(this.enemyPos.x, this.enemyPos.y);
        Point2D.Double double_2 = new Point2D.Double(this.enemyPos.x, this.enemyPos.y);
        double d = Rules.getBulletSpeed((double)this.bPower);
        Point2D.Double double_3 = new Point2D.Double(this.enemyPos.x, this.enemyPos.y);
        Point2D.Double double_4 = new Point2D.Double(this.enemyPos.x, this.enemyPos.y);
        this._futures.clear();
        if (Math.abs(this.eVelocity) <= 2.0) {
            this._futures.add(new Future(this.enemyPos.x, this.enemyPos.y, 0.0));
        }
        for (double d2 = -1.0; d2 <= 1.0; d2 += 2.0) {
            Point2D.Double double_5 = (Point2D.Double)this.enemyPos.clone();
            double d3 = this.eVelocity;
            double d4 = Math.atan2(this.enemyPos.x - this.myCenter.x, this.enemyPos.y - this.myCenter.y);
            double d5 = this.eDir;
            double d6 = this.eLatDir;
            double d7 = d4 + 1.5707963267948966 * d6;
            d7 += d5 < 0.0 ? Math.PI : 0.0;
            boolean bl = false;
            int n = 1;
            while ((double)n < 90.9090909090909 && !new Ellipse2D.Double(this.myCenter.x - d * (double)n, this.myCenter.y - d * (double)n, 2.0 * d * (double)n, 2.0 * d * (double)n).intersects(new Rectangle2D.Double(double_5.x - 18.0, double_5.y - 18.0, 36.0, 36.0))) {
                d3 += d2 * d3 > 0.0 ? d2 : 2.0 * d2;
                d3 = this.limit(-8.0, d3, 8.0);
                d5 = d3 == 0.0 ? d5 : this.sign(d3);
                d6 = d5 * this.sign(Utils.normalRelativeAngle((double)(d7 - d4)));
                d7 = Utils.normalRelativeAngle((double)(d4 + 1.5707963267948966 * d6));
                double d8 = this.wallSmooth(double_5, d7 += d5 < 0.0 ? Math.PI : 0.0, d2 * this.sign(Utils.normalRelativeAngle((double)(d7 - d4))), (int)d2);
                if (!bl && Math.abs(d7 - d8) <= 0.06981317007977318) {
                    if (d2 < 0.0) {
                        double_4.x = double_5.x;
                        double_4.y = double_5.y;
                    } else {
                        double_3.x = double_5.x;
                        double_3.y = double_5.y;
                    }
                } else {
                    bl = true;
                }
                double_5 = this.project(double_5, d8, d3);
                d4 = Math.atan2(double_5.x - this.myCenter.x, double_5.y - this.myCenter.y);
                this._futures.add(new Future(double_5.x, double_5.y, d2));
                ++n;
            }
            if (d2 == -1.0) {
                double_.x = double_5.x;
                double_.y = double_5.y;
                continue;
            }
            double_2.x = double_5.x;
            double_2.y = double_5.y;
        }
        return new Point2D.Double[]{double_, double_2, double_4, double_3};
    }

    private double wallSmooth(Point2D.Double double_, double d, double d2, int n) {
        for (int i = 0; !Bezier.playTains(this.project(double_, d, 20.0 * (double)n)) && i < 314; ++i) {
            d += 0.01 * d2;
        }
        return d;
    }

    private Point2D.Double project(Point2D.Double double_, double d, double d2) {
        return new Point2D.Double(double_.x + Math.sin(d) * d2, double_.y + Math.cos(d) * d2);
    }

    public void onPaint(Graphics2D graphics2D) {
        int n;
        long l = this.self.getTime();
        graphics2D.setColor(Color.BLUE);
        for (HammerToss hammerToss : this.waves) {
            if (!hammerToss.isReal) continue;
            double d = hammerToss.velocity * (double)(l - hammerToss.fireTime);
            graphics2D.draw(new Ellipse2D.Double(hammerToss.sourceX() - d, hammerToss.sourceY() - d, 2.0 * d, 2.0 * d));
        }
        Object object = stats[(int)this.lastASeg][(int)this.lastDSeg][(int)this.lastVSeg][(int)this.lastWDSeg][(int)this.lastRevWDSeg][(int)this.lastHSeg][(int)this.lastBPSeg];
        double d = 0.0;
        for (n = 0; n < 73; ++n) {
            if (!((double)object[n] > d)) continue;
            d = (double)object[n];
        }
        if (!Double.isNaN(d) && !Double.isInfinite(d) && Double.compare(d, 0.0) != 0) {
            graphics2D.setColor(new Color((int)this.limit(0.0, this.vcsConfidence * 255.0, 255.0), 128, 128));
            for (n = 0; n < 73; ++n) {
                graphics2D.fill(new Rectangle2D.Double(0.0 + (double)n * 2.3013698630136985, 0.0, 2.3013698630136985, (double)object[n] / d * 100.0));
            }
        }
        graphics2D.setColor(Color.YELLOW.brighter());
        graphics2D.draw(new Rectangle2D.Double(0.0, 0.0, 168.0, 100.0));
        graphics2D.draw(new Line2D.Double(84.0, 0.0, 84.0, 100.0));
    }

    public void reset() {
        this.waves.clear();
        if (this.flatMap.size() > 155) {
            System.out.println("Clearing " + (this.flatMap.size() - 154) + " gun datums");
            List list = this.flatMap.keySet().stream().sorted((fArray, fArray2) -> {
                int n = Double.compare(fArray[0], fArray2[0]);
                if (n == 0) {
                    return Double.compare(fArray[1], fArray2[1]);
                }
                return n;
            }).limit(this.flatMap.size() - 154).collect(Collectors.toList());
            for (float[] fArray3 : list) {
                this.flatMap.remove(fArray3);
            }
        }
        System.out.println("VCS Gun uses     : " + this.mainGunUses + " acc: %" + (double)Math.round(this.mainAcc * 10000.0) / 100.0);
        System.out.println("KNN Gun uses     : " + this.flattenerUses + " acc %" + (double)Math.round(this.flatAcc * 10000.0) / 100.0);
        System.out.println("My Real acc      :  %" + (double)Math.round(this.realHits / Double.max(1.0, this.shots) * 10000.0) / 100.0);
    }

    static {
        for (int i = 0; i < weights.length; ++i) {
            for (int j = 0; j < weights[i].length; ++j) {
                for (int k = 0; k < weights[i][j].length; ++k) {
                    for (int i2 = 0; i2 < weights[i][j][k].length; ++i2) {
                        for (int i3 = 0; i3 < weights[i][j][k][i2].length; ++i3) {
                            for (int i4 = 0; i4 < weights[i][j][k][i2][i3].length; ++i4) {
                                for (int i5 = 0; i5 < weights[i][j][k][i2][i3][i4].length; ++i5) {
                                    BanHammer.weights[i][j][k][i2][i3][i4][i5] = Math.exp(-0.2 * (double)(i + j + k + i2 + i3 + i4 + i5));
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

