/*
 * Decompiled with CFR 0.152.
 */
package am;

import java.awt.geom.Rectangle2D;

final class VirtualBullet {
    int gunStrategy;
    double startX;
    double startY;
    double absoluteBearingRadians;
    double startTime;
    double firePower;

    VirtualBullet(int gunStrategy, double startX, double startY, double absoluteBearingRadians, double startTime, double firePower) {
        this.gunStrategy = gunStrategy;
        this.startX = startX;
        this.startY = startY;
        this.absoluteBearingRadians = absoluteBearingRadians;
        this.startTime = startTime;
        this.firePower = firePower;
    }

    public String toString() {
        return "gunStrategy= " + this.gunStrategy + "  startX = " + this.startX + "  startY = " + this.startY + "  startTime = " + this.startTime + "  absoluteBearingRadians = " + this.absoluteBearingRadians + "  firePower = " + this.firePower;
    }

    public double getDistance(double now) {
        return (now - this.startTime) * (20.0 - 3.0 * this.firePower);
    }

    public double getX(double now) {
        return this.startX + Math.sin(this.absoluteBearingRadians) * this.getDistance(now);
    }

    public double getY(double now) {
        return this.startY + Math.cos(this.absoluteBearingRadians) * this.getDistance(now);
    }

    public boolean targetHitted(Rectangle2D enemy, double now) {
        double fraction = 0.0;
        while (fraction < 1.05) {
            if (enemy.contains(this.getX(now + fraction), this.getY(now + fraction))) {
                return true;
            }
            fraction += 0.1;
        }
        return false;
    }

    public double range(double enemyX, double enemyY, double now) {
        double x = enemyX - this.getX(now);
        double y = enemyY - this.getY(now);
        return Math.sqrt(x * x + y * y);
    }

    public double range(double fromX, double fromY, double toX, double toY) {
        double x = toX - fromX;
        double y = toY - fromX;
        return Math.sqrt(x * x + y * y);
    }
}

