/*
 * Decompiled with CFR 0.152.
 */
package bigpete;

import bigpete.VirtualBullet;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import java.util.List;

public class VirtualBulletList {
    final int wall_margin = 0;
    private List<VirtualBullet> bullet_list = new LinkedList<VirtualBullet>();
    private Rectangle battle_field;

    VirtualBulletList(double width, double height) {
        this.battle_field = new Rectangle(0, 0, (int)width - 0, (int)height - 0);
    }

    public void addBullet(double vel_in, double head_in, Point2D enemy_in, Point2D target_in, double time_in) {
        this.bullet_list.add(new VirtualBullet(vel_in, head_in, enemy_in, target_in, time_in));
    }

    public void update(double current_time, Point2D robot_position) {
        for (int i = 0; i < this.bullet_list.size(); ++i) {
            VirtualBullet tmp = this.getBullet(i);
            tmp.move(current_time);
            if (this.battle_field.contains(tmp.getPosition()) && !tmp.gonePast(robot_position)) continue;
            this.remove(i);
            --i;
        }
    }

    public int getNumber() {
        return this.bullet_list.size();
    }

    public VirtualBullet getBullet(int i) {
        return this.bullet_list.get(i);
    }

    public void remove(int i) {
        this.bullet_list.remove(i);
    }
}

