/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.data;

import dmh.robocode.data.Location;
import dmh.robocode.data.Movement;
import dmh.robocode.utils.Geometry;
import java.util.ArrayList;
import java.util.List;

public class DynamicMovementSequence
implements Cloneable {
    private List<Movement> moves = new ArrayList<Movement>();
    private long timeAtEndOfCurrentMoves = 0L;

    public DynamicMovementSequence() {
    }

    public DynamicMovementSequence(Movement movement, long timeSeen) {
        this.add(movement, timeSeen);
    }

    public int getLength() {
        return this.moves.size();
    }

    public Movement getLatest() {
        int index = this.moves.size() - 1;
        if (index < 0) {
            return null;
        }
        return this.moves.get(index);
    }

    public Movement getPrevious() {
        int index = this.moves.size() - 2;
        if (index < 0) {
            return null;
        }
        return this.moves.get(index);
    }

    public Movement getAtTime(long time) {
        int index = (int)((long)(this.getLength() - 1) - (this.timeAtEndOfCurrentMoves - time));
        if (index >= 0 && index < this.getLength()) {
            return this.moves.get(index);
        }
        return null;
    }

    public void add(Movement movement, long timeSeen) {
        if (timeSeen != this.timeAtEndOfCurrentMoves + 1L && this.timeAtEndOfCurrentMoves != 0L) {
            this.moves.clear();
        }
        this.moves.add(movement);
        this.timeAtEndOfCurrentMoves = timeSeen;
    }

    public boolean areUpToDate(long timeNow) {
        return this.timeAtEndOfCurrentMoves == timeNow;
    }

    public int getConsistentMoveCount(int maxMoves) {
        int moveIndex;
        if (this.moves.size() <= 2) {
            return 0;
        }
        int sameMoves = 0;
        Movement previousMove = this.moves.get(moveIndex - 1);
        for (moveIndex = Math.max(1, this.moves.size() - maxMoves); moveIndex < this.moves.size(); ++moveIndex) {
            Movement nextMove = this.moves.get(moveIndex);
            if (nextMove.equals(previousMove)) {
                ++sameMoves;
            }
            previousMove = nextMove;
        }
        return sameMoves;
    }

    public Movement getAverageMove(int maxMoves) {
        if (this.moves.isEmpty()) {
            return null;
        }
        Location zeroStart = new Location(0.0, 0.0);
        Location location = new Location(zeroStart);
        int moveCount = 0;
        for (int moveIndex = Math.max(0, this.moves.size() - maxMoves); moveIndex < this.moves.size(); ++moveIndex) {
            ++moveCount;
            Movement thisMove = this.moves.get(moveIndex);
            location = Geometry.getLocationAtBearing(location, thisMove.getRelativeBearing(), thisMove.getDistance());
        }
        double totalDistance = Geometry.getDistanceBetweenLocations(zeroStart, location);
        double overallBearing = Geometry.getBearingBetweenLocations(zeroStart, location);
        return new Movement(overallBearing / (double)moveCount, totalDistance / (double)moveCount);
    }

    public Movement getAverageMoveCRAP(int maxMoves) {
        if (this.moves.isEmpty()) {
            return null;
        }
        int moveCount = 0;
        double turnTotal = 0.0;
        double distanceTotal = 0.0;
        for (int moveIndex = Math.max(0, this.moves.size() - maxMoves); moveIndex < this.moves.size(); ++moveIndex) {
            ++moveCount;
            turnTotal += this.moves.get(moveIndex).getRelativeBearing();
            distanceTotal += this.moves.get(moveIndex).getDistance();
        }
        return new Movement(turnTotal / (double)moveCount, distanceTotal / (double)moveCount);
    }

    public int countSameMovement(int maxMoves, Movement expectedMove) {
        if (this.moves.size() <= 2) {
            return 0;
        }
        int sameMoves = 0;
        for (int moveIndex = Math.max(1, this.moves.size() - maxMoves); moveIndex < this.moves.size(); ++moveIndex) {
            if (!this.moves.get(moveIndex).equals(expectedMove)) continue;
            ++sameMoves;
        }
        return sameMoves;
    }

    public DynamicMovementSequence cloneMovementsSince(long time) {
        int startFromIndex;
        DynamicMovementSequence clone = new DynamicMovementSequence();
        clone.timeAtEndOfCurrentMoves = this.timeAtEndOfCurrentMoves;
        for (int i = startFromIndex = (int)Math.max(0L, (long)(this.moves.size() - 1) - this.timeAtEndOfCurrentMoves + time); i < this.moves.size(); ++i) {
            clone.moves.add(this.moves.get(i));
        }
        return clone;
    }
}

