/*
 * Decompiled with CFR 0.152.
 */
package gimp;

import gimp.Enemy;
import gimp.GravPoint;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.TeamRobot;
import robocode.WinEvent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GimpBot
extends TeamRobot {
    Hashtable targets;
    Enemy target;
    ArrayList Teammates;
    ArrayList Enemies;
    final double PI = Math.PI;
    int direction;
    double firePower;
    double midpointstrength;
    int midpointcount;

    public void run() {
        this.targets = new Hashtable();
        this.target = new Enemy();
        this.Teammates = new ArrayList();
        this.Enemies = new ArrayList();
        this.target.distance = 100000.0;
        this.setColors(Color.black, Color.red, Color.black);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.turnRadarRightRadians(Math.PI * 2);
        while (true) {
            this.antiGravMove();
            this.doFirePower();
            this.doScanner();
            this.doGun();
            this.fire(this.firePower);
            this.execute();
        }
    }

    void doFirePower() {
        this.firePower = 400.0 / this.target.distance;
        if (this.firePower > (double)3) {
            this.firePower = 3;
        }
    }

    void antiGravMove() {
        double ang;
        double force;
        GravPoint p;
        double xforce = 0.0;
        double yforce = 0.0;
        Enumeration e = this.targets.elements();
        while (e.hasMoreElements()) {
            Enemy en = (Enemy)e.nextElement();
            if (!en.live) continue;
            p = this.isTeammate(en.name) ? new GravPoint(en.x, en.y, -3000.0) : new GravPoint(en.x, en.y, -1000.0);
            force = p.power / Math.pow(this.getRange(this.getX(), this.getY(), p.x, p.y), 2);
            ang = this.normaliseBearing(1.5707963267948966 - Math.atan2(this.getY() - p.y, this.getX() - p.x));
            xforce += Math.sin(ang) * force;
            yforce += Math.cos(ang) * force;
        }
        ++this.midpointcount;
        if (this.midpointcount > 5) {
            this.midpointcount = 0;
            this.midpointstrength = Math.random() * 2000.0 - 1000.0;
        }
        p = new GravPoint(this.getBattleFieldWidth() / (double)2, this.getBattleFieldHeight() / (double)2, this.midpointstrength);
        force = p.power / Math.pow(this.getRange(this.getX(), this.getY(), p.x, p.y), 1.5);
        ang = this.normaliseBearing(1.5707963267948966 - Math.atan2(this.getY() - p.y, this.getX() - p.x));
        xforce += Math.sin(ang) * force;
        yforce += Math.cos(ang) * force;
        xforce += 5000.0 / Math.pow(this.getRange(this.getX(), this.getY(), this.getBattleFieldWidth(), this.getY()), 3);
        yforce += 5000.0 / Math.pow(this.getRange(this.getX(), this.getY(), this.getX(), this.getBattleFieldHeight()), 3);
        this.goTo(this.getX() - (xforce -= 5000.0 / Math.pow(this.getRange(this.getX(), this.getY(), 0.0, this.getY()), 3)), this.getY() - (yforce -= 5000.0 / Math.pow(this.getRange(this.getX(), this.getY(), this.getX(), 0.0), 3)));
    }

    void goTo(double x, double y) {
        double dist = 20.0;
        double angle = Math.toDegrees(this.absbearing(this.getX(), this.getY(), x, y));
        double r = this.turnTo(angle);
        this.setAhead(dist * r);
    }

    int turnTo(double angle) {
        int dir;
        double ang = this.normaliseBearing(this.getHeading() - angle);
        if (ang > 90.0) {
            ang -= 180.0;
            dir = -1;
        } else if (ang < -90.0) {
            ang += 180.0;
            dir = -1;
        } else {
            dir = 1;
        }
        this.setTurnLeft(ang);
        return dir;
    }

    void doScanner() {
        this.setTurnRadarLeftRadians(Math.PI * 2);
    }

    void doGun() {
        long time = this.getTime() + (long)((int)Math.round(this.getRange(this.getX(), this.getY(), this.target.x, this.target.y) / (20.0 - (double)3 * this.firePower)));
        Point2D.Double p = this.target.guessPosition(time);
        double gunOffset = this.getGunHeadingRadians() - (1.5707963267948966 - Math.atan2(p.y - this.getY(), p.x - this.getX()));
        this.setTurnGunLeftRadians(this.normaliseBearing(gunOffset));
    }

    double normaliseBearing(double ang) {
        if (ang > Math.PI) {
            ang -= Math.PI * 2;
        }
        if (ang < -Math.PI) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    double normaliseHeading(double ang) {
        if (ang > Math.PI * 2) {
            ang -= Math.PI * 2;
        }
        if (ang < 0.0) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    public double getRange(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = Math.sqrt(xo * xo + yo * yo);
        return h;
    }

    public double absbearing(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = this.getRange(x1, y1, x2, y2);
        if (xo > 0.0 && yo > 0.0) {
            return Math.asin(xo / h);
        }
        if (xo > 0.0 && yo < 0.0) {
            return Math.PI - Math.asin(xo / h);
        }
        if (xo < 0.0 && yo < 0.0) {
            return Math.PI + Math.asin(-xo / h);
        }
        if (xo < 0.0 && yo > 0.0) {
            return Math.PI * 2 - Math.asin(-xo / h);
        }
        return 0.0;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        Enemy en;
        if (this.targets.containsKey(e.getName())) {
            en = (Enemy)this.targets.get(e.getName());
        } else {
            en = new Enemy();
            this.targets.put(e.getName(), en);
        }
        double absbearing_rad = (this.getHeadingRadians() + e.getBearingRadians()) % (Math.PI * 2);
        en.name = e.getName();
        double h = this.normaliseBearing(e.getHeadingRadians() - en.heading);
        en.changehead = h /= (double)(this.getTime() - en.ctime);
        en.x = this.getX() + Math.sin(absbearing_rad) * e.getDistance();
        en.y = this.getY() + Math.cos(absbearing_rad) * e.getDistance();
        en.bearing = e.getBearingRadians();
        en.heading = e.getHeadingRadians();
        en.ctime = this.getTime();
        en.speed = e.getVelocity();
        en.distance = e.getDistance();
        en.live = true;
        if (this.isTeammate(en.name) && !this.Teammates.contains(en)) {
            this.Teammates.add(en);
        } else if (!this.Enemies.contains(en)) {
            this.Enemies.add(en);
        }
        if (!(!(en.distance < this.target.distance) && this.target.live || this.isTeammate(e.getName()))) {
            this.target = en;
            try {
                this.broadcastMessage((Serializable)((Object)e.getName()));
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        Enemy en = (Enemy)this.targets.get(e.getName());
        en.live = false;
    }

    public void onWin(WinEvent e) {
        int x = 0;
        while (x < 50) {
            this.antiGravMove();
            ++x;
        }
        this.stop();
        while (true) {
            this.setTurnRight(1000.0);
            this.setTurnRadarRight(10000.0);
            this.setTurnGunLeft(1000.0);
            this.execute();
        }
    }

    private final /* synthetic */ void this() {
        this.PI = Math.PI;
        this.direction = 1;
        this.midpointstrength = 0.0;
        this.midpointcount = 0;
    }

    public GimpBot() {
        this.this();
    }
}

