/*
 * Decompiled with CFR 0.152.
 */
package lundal;

import java.awt.Color;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Mark8
extends AdvancedRobot {
    public static double TAU = Math.PI * 2;
    private EnemyStats[] stats = new EnemyStats[5];
    private EnemyStats newStats = null;
    private boolean goingCW = false;
    private double deltaHeading = 0.0;
    private boolean fireNextTurn = false;
    private double bulletHit = 0.0;
    private boolean swappedLast = false;
    private double bulletHits = 0.0;

    public void run() {
        this.setColors(new Color(128, 32, 0), new Color(128, 32, 0), new Color(32, 8, 0), new Color(255, 128, 0), new Color(255, 0, 0));
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        while (true) {
            this.processNewStats();
            this.processRadar();
            this.processMovement();
            this.processShooting();
            this.execute();
        }
    }

    private void processNewStats() {
        this.stats[this.indexForTurn((long)this.getTime())] = this.newStats;
        this.newStats = null;
    }

    private void processRadar() {
        EnemyStats es = this.statsForTurn(this.getTime());
        if (es == null) {
            this.setTurnRadarRightRadians(TAU / 8.0);
            return;
        }
        double radarHeading = this.getRadarHeadingRadians();
        double radarDelta = Utils.normalRelativeAngle((double)(radarHeading - es.bearing));
        double newheading = radarDelta > 0.0 ? es.bearing - TAU / 20.0 : es.bearing + TAU / 20.0;
        double delta = Utils.normalRelativeAngle((double)(newheading - radarHeading));
        this.setTurnRadarRightRadians(delta);
    }

    private void processMovement() {
        double nextY;
        double nextX;
        EnemyStats es = this.statsForTurn(this.getTime());
        EnemyStats es1 = this.statsForTurn(this.getTime() - 1L);
        this.deltaHeading = 0.0;
        boolean originalCW = this.goingCW;
        if (es != null) {
            double eEL;
            if (es1 != null && (eEL = es1.energy - es.energy - this.bulletHit) > 0.1 && eEL <= 3.0) {
                if (!this.swappedLast || this.bulletHits < 3.0) {
                    this.goingCW = !this.goingCW;
                }
                this.swappedLast = !this.swappedLast;
            }
            double preferredHeading = Utils.normalRelativeAngle((double)(es.bearing - TAU / 4.0));
            double minDistance = 300.0;
            double maxDistance = 400.0;
            double adjustmentAngle = TAU / 16.0;
            if (es.distance < minDistance) {
                preferredHeading -= adjustmentAngle * Math.signum(this.getVelocity());
            }
            if (es.distance > maxDistance) {
                preferredHeading += adjustmentAngle * Math.signum(this.getVelocity());
            }
            if (!this.closeToWall(this.getX(), this.getY(), 36.0)) {
                this.deltaHeading = Utils.normalRelativeAngle((double)(preferredHeading - this.getHeadingRadians())) * 3.0;
            }
        }
        if (this.closeToWall(nextX = this.getNextX(this.getX(), this.getVelocity(), this.getHeadingRadians() + this.limit(this.deltaHeading, -10.0, 10.0)), nextY = this.getNextY(this.getY(), this.getVelocity(), this.getHeadingRadians() + this.limit(this.deltaHeading, -10.0, 10.0)), 36.0) && Math.abs(this.getVelocity()) > 6.0) {
            this.goingCW = !originalCW;
        }
        this.setTurnRightRadians(this.deltaHeading);
        this.setAhead(this.goingCW ? 100 : -100);
    }

    private void processShooting() {
        double bF = 3.0;
        double bV = Rules.getBulletSpeed((double)bF);
        if (this.fireNextTurn) {
            this.setFire(bF);
            this.fireNextTurn = false;
        }
        EnemyStats es = this.statsForTurn(this.getTime());
        EnemyStats es1 = this.statsForTurn(this.getTime() - 1L);
        EnemyStats es2 = this.statsForTurn(this.getTime() - 2L);
        EnemyStats es3 = this.statsForTurn(this.getTime() - 3L);
        EnemyStats es4 = this.statsForTurn(this.getTime() - 2L);
        if (es == null || es1 == null) {
            return;
        }
        double rXN = this.getNextX(this.getX(), this.getVelocity(), this.getHeadingRadians() + this.limit(this.deltaHeading, -10.0, 10.0));
        double rYN = this.getNextY(this.getY(), this.getVelocity(), this.getHeadingRadians() + this.limit(this.deltaHeading, -10.0, 10.0));
        double eX = es.x;
        double eY = es.y;
        double eV = es.velocity;
        double eVD = eV - es1.velocity;
        double eH = es.heading;
        double eHD = eH - es1.heading;
        if (eVD != 0.0) {
            return;
        }
        if (es2 != null && es3 != null && es4 != null) {
            double eHD1 = es1.heading - es2.heading;
            double eHD2 = es2.heading - es3.heading;
            double eHD3 = es3.heading - es4.heading;
            eHD = (eHD + eHD1 + eHD2 + eHD3) / 4.0;
            eH = (es.heading + es1.heading + es2.heading + es3.heading + es4.heading) / 5.0 + 2.0 * eHD;
        }
        int maxTurns = 50;
        int i = 1;
        while (i <= maxTurns) {
            double eXN = this.getNextX(eX, eV, eH += eHD);
            double eYN = this.getNextY(eY, eV, eH);
            if (!this.closeToWall(eX, eY, 18.0)) {
                eX = eXN;
                eY = eYN;
            }
            double dist2 = Math.sqrt((eX - rXN) * (eX - rXN) + (eY - rYN) * (eY - rYN));
            double bullet2 = bV * (double)i;
            double bullet2N = bV * (double)(i + 1);
            if (bullet2 < dist2 + 4.0 && dist2 - 4.0 < bullet2N) {
                double gunAngle = this.angleFromAtoB(rXN, rYN, eX, eY);
                double deltaAim = Utils.normalRelativeAngle((double)(gunAngle - this.getGunHeadingRadians()));
                this.setTurnGunRightRadians(deltaAim);
                if (Math.abs(deltaAim) < Rules.GUN_TURN_RATE_RADIANS / 2.0 && this.getGunHeat() <= this.getGunCoolingRate()) {
                    this.fireNextTurn = true;
                }
            }
            ++i;
        }
        this.bulletHit = 0.0;
    }

    public void onBulletHit(BulletHitEvent e) {
        this.bulletHit = Rules.getBulletDamage((double)e.getBullet().getPower());
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.bulletHits += 1.0;
    }

    private double getNextX(double currentX, double velocity, double heading) {
        return currentX + velocity * Math.sin(heading);
    }

    private double getNextY(double currentY, double velocity, double heading) {
        return currentY + velocity * Math.cos(heading);
    }

    private double angleFromAtoB(double aX, double aY, double bX, double bY) {
        double dx = bX - aX;
        double dy = bY - aY;
        double angle = -Math.atan(dy / dx) + TAU / 4.0;
        if (dx < 0.0) {
            angle += TAU / 2.0;
        }
        return angle;
    }

    private boolean closeToWall(double x, double y, double distance) {
        if (x < distance) {
            return true;
        }
        if (x > this.getBattleFieldWidth() - distance) {
            return true;
        }
        if (y < distance) {
            return true;
        }
        return y > this.getBattleFieldHeight() - distance;
    }

    private double limit(double val, double min, double max) {
        return Math.max(min, Math.min(val, max));
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        EnemyStats es = new EnemyStats();
        es.distance = e.getDistance();
        es.bearing = this.getHeadingRadians() + e.getBearingRadians();
        es.heading = e.getHeadingRadians();
        es.velocity = e.getVelocity();
        es.energy = e.getEnergy();
        es.x = this.getX() + es.distance * Math.sin(es.bearing);
        es.y = this.getY() + es.distance * Math.cos(es.bearing);
        this.newStats = es;
    }

    private int indexForTurn(long turn) {
        return (int)((turn + 5L) % 5L);
    }

    private EnemyStats statsForTurn(long time) {
        return this.stats[this.indexForTurn(time)];
    }

    class EnemyStats {
        double distance;
        double bearing;
        double heading;
        double velocity;
        double energy;
        double x;
        double y;

        EnemyStats() {
        }
    }
}

