/*
 * Decompiled with CFR 0.152.
 */
package gtf.robocode;

import gtf.robocode.Point;

public class Util {
    public static double toHeading(double dx, double dy) {
        double heading = dy == 0.0 ? (dx >= 0.0 ? 90.0 : 270.0) : Math.toDegrees(Math.atan(dx / dy));
        if (dy < 0.0) {
            heading += 180.0;
        }
        return heading % 360.0;
    }

    public static double normalize(double angle) {
        if ((angle %= 360.0) > 180.0) {
            angle -= 360.0;
        }
        if (angle < -180.0) {
            angle += 360.0;
        }
        return angle;
    }

    public static double normalize(double oldAngle, double newAngle) {
        return Util.normalize(newAngle - oldAngle);
    }

    public static Point linearIntercept(double dx, double dy, double vx, double vy, double bulletSpeed) {
        double time;
        double distance2 = dx * dx + dy * dy;
        double dotprod = dx * vx + dy * vy;
        double v2 = vx * vx + vy * vy;
        double b2 = bulletSpeed * bulletSpeed;
        if (v2 == b2) {
            time = -distance2 / (2.0 * dotprod);
        } else {
            double discriminant = dotprod * dotprod + distance2 * (b2 - v2);
            if (discriminant < 0.0) {
                return null;
            }
            double time1 = (dotprod + Math.sqrt(discriminant)) / (b2 - v2);
            double time2 = (dotprod - Math.sqrt(discriminant)) / (b2 - v2);
            if (time1 < 0.0 && time2 < 0.0) {
                return null;
            }
            time = time1 > 0.0 && time2 > 0.0 ? Math.min(time1, time2) : Math.max(time1, time2);
        }
        if (time < 0.0) {
            return null;
        }
        double interceptX = dx + vx * time;
        double interceptY = dy + vy * time;
        System.out.println("" + interceptX + ", " + interceptY);
        return new Point(time, interceptX, interceptY);
    }

    public static double norm(double x, double y) {
        return Math.sqrt(x * x + y * y);
    }

    public static double toBearingRadians(double theta) {
        double a = theta % (Math.PI * 2);
        if (a < 0.0) {
            a += Math.PI * 2;
        }
        return a;
    }

    public static double bulletSpeed(double power) {
        return 20.0 - 3.0 * power;
    }
}

