/*
 * Decompiled with CFR 0.152.
 */
package gtf.robocode.forcefield;

import gtf.robocode.Vector2D;
import gtf.robocode.forcefield.ForceField;

public class WallField
extends ForceField {
    private static final double MARGIN = 1.0;
    private static final double STRENGTH = 40000.0;
    private final double arenaWidth;
    private final double arenaHeight;
    private final ForceField WALL_W;
    private final ForceField WALL_E;
    private final ForceField WALL_S;
    private final ForceField WALL_N;
    private final ForceField SumField;

    public WallField(double arenaWidth, double arenaHeight) {
        this.arenaWidth = arenaWidth;
        this.arenaHeight = arenaHeight;
        this.WALL_W = this.getWallWest();
        this.WALL_N = this.getWallNorth();
        this.WALL_E = this.getWallEast();
        this.WALL_S = this.getWallSouth();
        this.SumField = this.WALL_W.plus(this.WALL_E.plus(this.WALL_N.plus(this.WALL_S)));
    }

    public Vector2D getVector2D(double x, double y) {
        return this.SumField.getVector2D(x, y);
    }

    private ForceField getWallWest() {
        return new ForceField(){

            public Vector2D getVector2D(double x, double y) {
                return new Vector2D(40000.0 / ((x += 1.0) * x), 0.0);
            }
        };
    }

    private ForceField getWallEast() {
        return new ForceField(){

            public Vector2D getVector2D(double x, double y) {
                double xx = WallField.this.arenaWidth + 1.0 - x;
                return new Vector2D(-40000.0 / (xx * xx), 0.0);
            }
        };
    }

    private ForceField getWallNorth() {
        return new ForceField(){

            public Vector2D getVector2D(double x, double y) {
                double yy = WallField.this.arenaHeight + 1.0 - y;
                return new Vector2D(0.0, -40000.0 / (yy * yy));
            }
        };
    }

    private ForceField getWallSouth() {
        return new ForceField(){

            public Vector2D getVector2D(double x, double y) {
                return new Vector2D(0.0, 40000.0 / ((y += 1.0) * y));
            }
        };
    }
}

