/*
 * Decompiled with CFR 0.152.
 */
package rdt.Wraith.Guns.GunImplementations.Segmented.GuessFactor;

import rdt.Wraith.Guns.GunImplementations.Segmented.GuessFactor.KernelDensity;
import rdt.Wraith.Guns.GunImplementations.Segmented.GuessFactor.PeakDensity;
import rdt.Wraith.Profiling.Profiler;
import rdt.Wraith.Utils.MathUtils;

public abstract class KernelDensityFunctionBase {
    protected final double _bandwidth;
    protected final double _halfBandwidth;

    public KernelDensityFunctionBase(double bandwidth) {
        this._bandwidth = bandwidth;
        this._halfBandwidth = this._bandwidth * 0.5;
    }

    public final void RecalculateKernelDensity(double[] guessFactors, double[] weights, int numGuessFactors, KernelDensity kernelDensity) {
        Profiler.StartScope("RecalculateKernelDensity");
        int numDivisions = kernelDensity.Values.length;
        for (int division = 0; division < numDivisions; ++division) {
            kernelDensity.Values[division] = 0.0;
        }
        double divisionWidth = 1.0 / (double)numDivisions;
        double halfDivisionWidth = divisionWidth * 0.5;
        int divisionsToWrite = (int)Math.ceil(this._halfBandwidth / divisionWidth);
        assert (divisionsToWrite >= 0);
        double maxValue = 0.0;
        for (int guessFactorIndex = 0; guessFactorIndex < numGuessFactors; ++guessFactorIndex) {
            double gF = guessFactors[guessFactorIndex];
            double weight = weights[guessFactorIndex];
            double gF01 = MathUtils.GuessFactorTo01(gF);
            double divisionIndexDouble = gF01 * (double)(numDivisions - 1);
            int divisionIndex = (int)Math.floor(divisionIndexDouble + 0.5);
            assert ((double)divisionIndex == Math.floor(divisionIndexDouble + 0.5)) : divisionIndex + "/" + Math.floor(divisionIndexDouble + 0.5);
            assert (divisionIndex >= 0 && divisionIndex < numDivisions);
            int startDivision = Math.max(divisionIndex - divisionsToWrite, 0);
            int endDivision = Math.min(divisionIndex + divisionsToWrite, numDivisions - 1);
            assert (startDivision <= divisionIndex);
            assert (endDivision >= divisionIndex);
            for (int division = startDivision; division <= endDivision; ++division) {
                double divisionCenter01 = (double)division * divisionWidth + halfDivisionWidth;
                double percentage01 = Math.min(1.0, Math.max(0.0, Math.abs(divisionCenter01 - gF01) / this._halfBandwidth));
                double valueToAdd = this.KernelDensityFuncValueAtBandwidthPercentage(percentage01) * weight;
                int n = division;
                kernelDensity.Values[n] = kernelDensity.Values[n] + valueToAdd;
                maxValue = Math.max(maxValue, kernelDensity.Values[division]);
            }
        }
        assert (numGuessFactors <= 0 || maxValue > 0.0) : "Max value is " + maxValue + " but we have " + numGuessFactors + " guess factors ...";
        kernelDensity.MaxKernelDensity = maxValue;
        double total = 0.0;
        for (int division = 0; division < numDivisions; ++division) {
            total += kernelDensity.Values[division];
        }
        kernelDensity.Mean = total / (double)numDivisions;
        double totalSquareDifferences = 0.0;
        for (int division = 0; division < numDivisions; ++division) {
            double diff = kernelDensity.Values[division] - kernelDensity.Mean;
            totalSquareDifferences += diff * diff;
        }
        kernelDensity.StdDeviation = Math.sqrt(totalSquareDifferences / (double)numDivisions);
        kernelDensity.FirstStdDeviation = kernelDensity.Mean + kernelDensity.StdDeviation;
        kernelDensity.ResetPeaks();
        boolean trackingPeak = false;
        int peakStart = -1;
        int peakMaxDivision = 0;
        double peakMax = 0.0;
        for (int division = 0; division < numDivisions; ++division) {
            double val = kernelDensity.Values[division];
            if (!trackingPeak) {
                if (!(val >= kernelDensity.FirstStdDeviation)) continue;
                peakStart = division;
                peakMax = val;
                peakMaxDivision = division;
                trackingPeak = true;
                continue;
            }
            if (val >= kernelDensity.FirstStdDeviation) {
                peakMax = Math.max(peakMax, val);
                peakMaxDivision = division;
                continue;
            }
            int peakEnd = division - 1;
            PeakDensity toFill = kernelDensity.GetPeakToFill(peakMax);
            if (toFill != null) {
                toFill.StartDivision = peakStart;
                toFill.EndDivision = peakEnd;
                toFill.MaxValue = peakMax;
                toFill.MaxValueDivision = peakMaxDivision;
                toFill.Valid = true;
            }
            trackingPeak = false;
        }
        if (trackingPeak) {
            int peakEnd = numDivisions - 1;
            PeakDensity toFill = kernelDensity.GetPeakToFill(peakMax);
            if (toFill != null) {
                toFill.StartDivision = peakStart;
                toFill.EndDivision = peakEnd;
                toFill.MaxValue = peakMax;
                toFill.MaxValueDivision = peakMaxDivision;
                toFill.Valid = true;
            }
        }
        kernelDensity.SortPeaks();
        Profiler.EndScope();
    }

    protected abstract double KernelDensityFuncValueAtBandwidthPercentage(double var1);
}

