/*
 * Decompiled with CFR 0.152.
 */
package rdt.Wraith.RobotSnapshots;

import rdt.Wraith.RobotSnapshots.RobotSnapshot;
import rdt.Wraith.Utils.MathUtils;

public class RobotSnapshots {
    private static final int _maxSnapshots = 1024;
    private static final int _bitMask = 1023;
    private RobotSnapshot[] _snapshots = new RobotSnapshot[1024];
    private int _round = 0;

    public RobotSnapshots() {
        assert (MathUtils.IsPowerOfTwo(1024));
        for (int index = 0; index < 1024; ++index) {
            this._snapshots[index] = new RobotSnapshot();
        }
    }

    public int Capacity() {
        return 1024;
    }

    public void OnRoundStart(int round) {
        this._round = round;
    }

    public RobotSnapshot Read(long tick) {
        RobotSnapshot readSnapshot = this._snapshots[(int)tick & 0x3FF];
        assert (readSnapshot.Tick == tick) : "Snapshot tick is " + readSnapshot.Tick + " accessing tick " + tick;
        assert (readSnapshot.Round == this._round) : "Snapshot round is " + readSnapshot.Round + " actual round is " + this._round;
        return readSnapshot;
    }

    public RobotSnapshot Write(long tick) {
        return this._snapshots[(int)tick & 0x3FF];
    }
}

