/*
 * Decompiled with CFR 0.152.
 */
package rdt.Wraith.Utils;

import rdt.Wraith.IRobot;

public final class FastOutsideOfBattlefield {
    private static final int _outsideBattlefieldOffset = 1000;
    private final double[] _outsideBattlefield;
    private final int _width;

    public FastOutsideOfBattlefield(IRobot robot, int padding) {
        int battlefieldWidth = (int)Math.round(robot.getBattleFieldWidth());
        int battlefieldHeight = (int)Math.round(robot.getBattleFieldHeight());
        int maxOffsetX = 2000 + battlefieldWidth;
        int maxOffsetY = 2000 + battlefieldHeight;
        int minInsideX = 1000 + padding;
        int maxInsideX = 1000 + battlefieldWidth - padding;
        int minInsideY = 1000 + padding;
        int maxInsideY = 1000 + battlefieldHeight - padding;
        this._outsideBattlefield = new double[maxOffsetX * maxOffsetY];
        this._width = maxOffsetX;
        for (int x = 0; x < maxOffsetX; ++x) {
            for (int y = 0; y < maxOffsetY; ++y) {
                double outsideBattlefield = 1.0;
                if (x > minInsideX && y > minInsideY && x < maxInsideX && y < maxInsideY) {
                    outsideBattlefield = 0.0;
                }
                this._outsideBattlefield[y * this._width + x] = outsideBattlefield;
            }
        }
    }

    public final double Check(double x, double y) {
        return this._outsideBattlefield[((int)y + 1000) * this._width + ((int)x + 1000)];
    }
}

