/*
 * Decompiled with CFR 0.152.
 */
package florent.XSeries.movement;

import florent.XSeries.Configuration;
import florent.XSeries.movement.MovementStrategy;
import florent.XSeries.movement.antigravity.CenterPoint;
import florent.XSeries.movement.antigravity.CornerPoint;
import florent.XSeries.movement.antigravity.EnemyPoint;
import florent.XSeries.movement.antigravity.GravEntity;
import florent.XSeries.movement.antigravity.GravLine;
import florent.XSeries.movement.antigravity.GravPoint;
import florent.XSeries.movement.antigravity.GravZone;
import florent.XSeries.movement.antigravity.MyPoint;
import florent.XSeries.movement.wavesurfing.GFLog;
import florent.XSeries.radar.Enemy;
import florent.XSeries.radar.EnemyBuilder;
import florent.XSeries.radar.EnemyTracker;
import florent.XSeries.radar.Tracker;
import florent.XSeries.utils.Force;
import florent.XSeries.utils.RobocodeTools;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.TeamRobot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntiGravity
extends MovementStrategy
implements EnemyTracker,
EnemyBuilder {
    private static final int ZONENUMBER = 4;
    private TeamRobot me;
    private Point2D.Double location;
    private ConcurrentHashMap<String, Enemy> enemies;
    private HashMap<String, GFLog> logs;
    public ArrayList<GravEntity> points;
    public ArrayList<GravLine> LOS;
    public GravZone[] zones;
    private Tracker tracker;
    private Rectangle2D.Double safeBF;
    private int score;
    private CenterPoint center;
    private Force theForce;

    public AntiGravity(TeamRobot me) {
        this.me = me;
        this.points = new ArrayList(200);
        this.LOS = new ArrayList(10);
        this.logs = new HashMap();
        this.location = new Point2D.Double(me.getX(), me.getY());
        Enemy.me = me;
        this.tracker = Tracker.getInstance();
        this.tracker.addBuilder(this);
        this.enemies = this.tracker.getEnemies();
        this.safeBF = new Rectangle2D.Double(20.0, 20.0, Configuration.battleFieldWidth - 40.0, Configuration.battleFieldHeigth - 40.0);
    }

    @Override
    public void endRound() {
    }

    @Override
    public void initRound() {
        this.initPoints();
    }

    @Override
    public void onBulletHit(BulletHitEvent e) {
        Enemy enemy = this.tracker.getEnemy(e.getName());
        if (enemy.point != null) {
            enemy.point.point = enemy.location;
        }
    }

    @Override
    public void onHitByBullet(HitByBulletEvent e) {
        Enemy enemy = this.tracker.getEnemy(e.getName());
        if (enemy.point != null) {
            enemy.point.point = enemy.location;
        }
    }

    @Override
    public void onBulletHitBullet(BulletHitBulletEvent e) {
        Enemy enemy = this.tracker.getEnemy(e.getHitBullet().getName());
        if (enemy.point != null) {
            enemy.point.point = enemy.location;
        }
    }

    @Override
    public void onHitRobot(HitRobotEvent e) {
        Enemy enemy = this.tracker.getEnemy(e.getName());
        if (enemy.point != null && !this.tracker.isDead(enemy)) {
            enemy.point.point = enemy.location;
        }
    }

    @Override
    public void onRobotDeath(RobotDeathEvent e) {
        Enemy enemy = this.tracker.getEnemy(e.getName());
        this.points.remove(enemy.point);
    }

    @Override
    public void onScannedRobot(ScannedRobotEvent e) {
        Enemy enemy = this.tracker.getEnemy(e.getName());
        if (enemy.point != null) {
            enemy.point.point = enemy.location;
        }
    }

    private GFLog getLog(String key) {
        if (this.logs.containsKey(key)) {
            return this.logs.get(key);
        }
        GFLog log = new GFLog(key);
        this.logs.put(key, log);
        return log;
    }

    private void initPoints() {
        this.points.clear();
        this.zones = new GravZone[4];
        int zoneCpt = 0;
        double minX = 0.0;
        double minY = 0.0;
        double maxX = this.me.getBattleFieldWidth();
        double maxY = this.me.getBattleFieldHeight();
        double centerX = (maxX - minX) / 2.0;
        double centerY = (maxY - minY) / 2.0;
        GravPoint point = this.center = new CenterPoint(new Point2D.Double(centerX, centerY));
        this.points.add(point);
        point = new CornerPoint(new Point2D.Double(minX, minY));
        this.points.add(point);
        this.zones[zoneCpt] = new GravZone(point, minX, minY, centerX, centerY);
        point = new CornerPoint(new Point2D.Double(minX, maxY));
        this.points.add(point);
        this.zones[++zoneCpt] = new GravZone(point, minX, centerY, centerX, centerY);
        point = new CornerPoint(new Point2D.Double(maxX, maxY));
        this.points.add(point);
        this.zones[++zoneCpt] = new GravZone(point, centerX, centerY, centerX, centerY);
        point = new CornerPoint(new Point2D.Double(maxX, minY));
        this.points.add(point);
        this.zones[++zoneCpt] = new GravZone(point, centerX, minY, centerX, centerY);
        ++zoneCpt;
        GravLine wall = new GravLine(Configuration.EastWall);
        this.points.add(wall);
        wall = new GravLine(Configuration.WestWall);
        this.points.add(wall);
        wall = new GravLine(Configuration.NorthWall);
        this.points.add(wall);
        wall = new GravLine(Configuration.SouthWall);
        this.points.add(wall);
        point = MyPoint.getInstance();
        point.point = new Point2D.Double(this.me.getX(), this.me.getY());
        this.points.add(point);
    }

    @Override
    public void onMainLoop() {
        this.location.setLocation(this.me.getX(), this.me.getY());
        this.points.removeAll(this.LOS);
        this.LOS.clear();
        for (Enemy enemy : this.enemies.values()) {
            if (enemy.target == null) continue;
            GravLine line = new GravLine(new Line2D.Double(enemy.location.x, enemy.location.y, enemy.target.location.x, enemy.target.location.y));
            line.LOS = true;
            this.LOS.add(line);
        }
        this.points.addAll(this.LOS);
        this.center.strength = this.me.getOthers() == 1 ? 0.0 : (this.me.getOthers() > 6 ? 0.0 : (this.me.getOthers() > 5 ? 100.0 : 200.0));
        Force force = new Force(new Point2D.Double(this.location.x, this.location.y), new Point2D.Double(this.location.x, this.location.y));
        for (GravEntity ent : this.points) {
            force.add(ent.getForce(this.location));
        }
        force.multiplyMagnitude(10.0);
        if (!this.safeBF.contains(force.end)) {
            force.end.x = Math.max(this.safeBF.getMinX(), Math.min(this.safeBF.getMaxX(), force.end.x));
            force.end.y = Math.max(this.safeBF.getMinY(), Math.min(this.safeBF.getMaxY(), force.end.y));
        }
        this.theForce = new Force(force.origin, force.end);
        double theta = RobocodeTools.absoluteBearing(this.location, force.end) - this.me.getHeadingRadians();
        this.me.setAhead(Math.cos(theta) * 100.0);
        this.me.setTurnRightRadians(Math.tan(theta));
    }

    @Override
    public ConcurrentHashMap<String, Enemy> getEnemies() {
        return this.enemies;
    }

    @Override
    public void onPaint(Graphics2D e) {
        int i = 0;
        while (i < this.points.size()) {
            this.points.get(i).onPaint(e);
            ++i;
        }
        if (this.theForce != null) {
            e.setColor(Color.WHITE);
            e.draw(new Line2D.Double(this.theForce.origin.x, Configuration.battleFieldHeigth - this.theForce.origin.y, this.theForce.end.x, Configuration.battleFieldHeigth - this.theForce.end.y));
        }
    }

    @Override
    public void onEnemyCreation(Enemy enemy) {
        enemy.logMelee = enemy.logDuel = enemy.logDuel == null ? this.getLog("duel " + enemy.name) : enemy.logDuel;
        EnemyPoint enemyPoint = new EnemyPoint(enemy);
        this.points.remove(enemyPoint);
        if (!this.tracker.isDead(enemy)) {
            this.points.add(enemyPoint);
        }
        enemy.points = this.points;
        enemy.point = enemyPoint;
    }

    @Override
    public void execCondition() {
        this.score = this.me.getOthers() > 1 ? 100 : 0;
    }

    @Override
    public int getScore() {
        return this.score;
    }

    public void addGravEntity(GravEntity entity) {
        this.points.add(entity);
    }

    public void removeGravEntity(GravEntity entity) {
        this.points.remove(entity);
    }
}

