/*
 * Decompiled with CFR 0.152.
 */
package starpkg;

import java.awt.Color;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import starpkg.BattleArea;
import starpkg.BulletList;
import starpkg.EnemyMoveAnalyser;
import starpkg.EnemyShootAnalyser;
import starpkg.EnemyStatus;
import starpkg.GunCtrl;
import starpkg.HelperTools;
import starpkg.MoveCtrl;
import starpkg.MyStatus;
import starpkg.RadarCtrl;
import starpkg.TargetPredict;

public class StarViewerZ
extends AdvancedRobot {
    HelperTools tools = new HelperTools();
    MyStatus status = new MyStatus(this);
    BattleArea battleArea = new BattleArea(this);
    EnemyStatus enemy = new EnemyStatus(this);
    BulletList bulletList = new BulletList(this);
    EnemyMoveAnalyser enemyAnalyser = new EnemyMoveAnalyser(this);
    TargetPredict predict = new TargetPredict(this);
    MoveCtrl moveCtrl = new MoveCtrl(this);
    RadarCtrl radarCtrl = new RadarCtrl(this);
    GunCtrl gunCtrl = new GunCtrl(this);
    EnemyShootAnalyser shootAnalyser = new EnemyShootAnalyser(this);
    public boolean win = false;
    public boolean startGun = false;

    public void InitRobot() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.battleArea.GetBattleAreaInfo();
        this.setMaxVelocity(8.0);
        this.setColors(new Color(80, 255, 0), new Color(90, 255, 90), new Color(90, 255, 90));
        this.setTurnRadarRight(720.0);
        this.out.println("AI: Ready! GO!");
    }

    public void run() {
        this.InitRobot();
        while (true) {
            this.status.Update();
            if (this.status.totalEnemy > 0) {
                this.moveCtrl.Move();
                this.radarCtrl.SetRadar();
                if (!this.startGun) {
                    if (this.getTime() > 10L) {
                        this.startGun = true;
                    }
                } else {
                    this.gunCtrl.SetGun();
                    if (this.status.totalEnemy <= 1) {
                        this.shootAnalyser.OneEnemyUpdate();
                    }
                }
                this.execute();
                continue;
            }
            if (!this.win) {
                this.win = true;
                this.enemy.Save1v1Enemy();
            }
            this.setTurnRadarLeft(100.0);
            this.setTurnLeft(100.0);
            this.setTurnGunRight(100.0);
            this.setAhead(100.0);
            this.setMaxVelocity(2.0);
            this.fire(0.1);
            this.execute();
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        this.bulletList.CheckBullet();
    }

    public void onBulletHit(BulletHitEvent e) {
        this.bulletList.CheckBullet();
        if (this.status.totalEnemy <= 1 && e.getName() == this.enemy.enemyMain.name) {
            this.shootAnalyser.curEnemyEnergy = e.getEnergy();
        }
    }

    public void onBulletMissed(BulletMissedEvent e) {
        this.bulletList.CheckBullet();
    }

    public void onDeath(DeathEvent e) {
        if (this.status.totalEnemy <= 1) {
            this.enemy.Save1v1Enemy();
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.shootAnalyser.OnHitByBullet(e);
    }

    public void onHitRobot(HitRobotEvent e) {
        if (this.moveCtrl.pointMoveStart) {
            this.moveCtrl.PointMoveStop();
        }
    }

    public void onHitWall(HitWallEvent e) {
    }

    public void onRobotDeath(RobotDeathEvent e) {
        if (this.status.totalEnemy > 1) {
            this.enemy.OnRobotDeath(e.getName());
            this.moveCtrl.MoreMoveBestPoint();
            this.moveCtrl.moveAwayCtrl = 10L;
        }
        ++this.moveCtrl.moveAwayPtr;
        this.moveCtrl.AddMoveAwayDist();
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.enemy.OnScanned(e);
        if (this.status.totalEnemy > 1) {
            this.radarCtrl.OnScan(e.getName());
        }
    }

    public void onWin(WinEvent e) {
    }
}

