/*
 * Decompiled with CFR 0.152.
 */
package mue;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mue.BulletData;
import mue.BulletDetectionListener;
import mue.Knowledge;
import mue.Util;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.RobocodeFileWriter;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.TeamRobot;
import robocode.WinEvent;

abstract class RobotBase
extends TeamRobot
implements BulletDetectionListener {
    private static long skippedTurns = 0L;
    private static long turns = 1L;
    private static boolean silent = false;
    private static int rounds = 0;
    private Knowledge knowledge;
    private boolean endOfRound;

    protected void init() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.knowledge = new Knowledge(this);
        this.knowledge.addBulletDetectionListener(this);
        this.endOfRound = false;
    }

    public void run() {
        try {
            this.init();
            this.action();
        }
        catch (RuntimeException runtimeException) {
            try {
                PrintWriter printWriter = new PrintWriter((Writer)new RobocodeFileWriter(this.getLogFile().getAbsolutePath(), true));
                this.printWarnings(printWriter);
                printWriter.println("encountered exception: " + runtimeException.getMessage());
                runtimeException.printStackTrace(printWriter);
                printWriter.close();
                if (printWriter.checkError()) {
                    System.out.println("run: could not write to file.");
                }
                throw runtimeException;
            }
            catch (IOException iOException) {
                System.out.println("run: error while writing to file: " + iOException.getMessage());
            }
        }
    }

    protected abstract void action();

    public void execute() {
        this.knowledge.execute();
        super.execute();
        this.knowledge.startTick();
    }

    protected double setTurn(double d) {
        double d2 = Util.relativeAngle(this.getHeading(), d);
        this.setTurnRight(d2);
        return d2;
    }

    protected double setTurnGun(double d) {
        double d2 = Util.relativeAngle(this.getGunHeading(), d);
        this.setTurnGunRight(d2);
        return d2;
    }

    protected double setTurnRadar(double d) {
        double d2 = Util.relativeAngle(this.getRadarHeading(), d);
        this.setTurnRadarRight(d2);
        return d2;
    }

    protected double setTurnRadians(double d) {
        double d2 = Util.relativeAngleRadians(this.getHeadingRadians(), d);
        this.setTurnRightRadians(d2);
        return d2;
    }

    protected double setTurnGunRadians(double d) {
        double d2 = Util.relativeAngleRadians(this.getGunHeadingRadians(), d);
        this.setTurnGunRightRadians(d2);
        return d2;
    }

    protected double setTurnRadarRadians(double d) {
        double d2 = Util.relativeAngleRadians(this.getRadarHeadingRadians(), d);
        this.setTurnRadarRightRadians(d2);
        return d2;
    }

    protected final boolean isInsideField(double d, double d2) {
        return d >= 18.0 && d2 >= 18.0 && d <= this.getBattleFieldWidth() - 18.0 && d2 <= this.getBattleFieldHeight() - 18.0;
    }

    protected final void setSilent(boolean bl) {
        silent = bl;
    }

    protected final boolean isSilent() {
        return silent;
    }

    public void print(String string) {
        if (!silent) {
            this.out.print(string);
        }
    }

    public void println(String string) {
        if (!silent) {
            this.out.println(string);
        }
    }

    protected final long getSkippedTurns() {
        return skippedTurns;
    }

    public final Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void onSkippedTurn(SkippedTurnEvent skippedTurnEvent) {
        ++skippedTurns;
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
        this.knowledge.update(scannedRobotEvent);
    }

    public void onRobotDeath(RobotDeathEvent robotDeathEvent) {
        this.knowledge.update(robotDeathEvent);
    }

    public void onBulletHit(BulletHitEvent bulletHitEvent) {
        this.knowledge.update(bulletHitEvent);
    }

    public void onHitByBullet(HitByBulletEvent hitByBulletEvent) {
        this.knowledge.update(hitByBulletEvent);
    }

    public void onBulletHitBullet(BulletHitBulletEvent bulletHitBulletEvent) {
        this.knowledge.update(bulletHitBulletEvent);
    }

    public void onBulletDetected(BulletData bulletData) {
    }

    public void onHitRobot(HitRobotEvent hitRobotEvent) {
        this.knowledge.update(hitRobotEvent);
    }

    public void onWin(WinEvent winEvent) {
        if (!this.endOfRound) {
            this.onEndOfRound();
            if (this.getRoundNum() == this.getNumRounds() - 1) {
                this.onEndOfBattle();
            }
            this.endOfRound = true;
        }
    }

    public void onDeath(DeathEvent deathEvent) {
        if (!this.endOfRound) {
            this.onEndOfRound();
            if (this.getRoundNum() == this.getNumRounds() - 1) {
                this.onEndOfBattle();
            }
            this.endOfRound = true;
        }
    }

    protected void onEndOfRound() {
        turns += this.getTime();
        ++rounds;
    }

    protected File getLogFile() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n >= 0 && n < string.length() - 1) {
            string = string.substring(n + 1);
        }
        return this.getDataFile(string + ".log");
    }

    protected void onEndOfBattle() {
        this.println("skipped turns: " + skippedTurns + " (" + (double)skippedTurns * 100.0 / (double)turns + "%)");
        if (rounds != this.getNumRounds()) {
            Util.addWarning("missed " + (this.getNumRounds() - rounds) + " rounds!");
        }
        if (Util.getWarnings().size() > 0) {
            try {
                PrintWriter printWriter = new PrintWriter((Writer)new RobocodeFileWriter(this.getLogFile().getAbsolutePath(), true));
                this.printWarnings(printWriter);
                printWriter.close();
                if (printWriter.checkError()) {
                    System.out.println("onEndOfBattle: could not write to file.");
                }
            }
            catch (IOException iOException) {
                System.out.println("onEndOfBattle: error while writing to file: " + iOException.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List readFile(String string) throws IOException, FileNotFoundException {
        File file = this.getDataFile(string);
        BufferedReader bufferedReader = null;
        try {
            if (!file.exists()) {
                List list = null;
                return list;
            }
            bufferedReader = new BufferedReader(new FileReader(file));
            ArrayList<String> arrayList = new ArrayList<String>(100);
            while (bufferedReader.ready()) {
                arrayList.add(bufferedReader.readLine());
            }
            ArrayList<String> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeFile(String string, List list) throws IOException {
        File file = this.getDataFile(string);
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter((Writer)new RobocodeFileWriter(file));
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                printWriter.println(iterator.next());
            }
        }
        finally {
            printWriter.close();
        }
    }

    protected void printWarnings(PrintWriter printWriter) {
        Iterator iterator = Util.getWarnings().iterator();
        if (iterator.hasNext()) {
            printWriter.println("warnings: ");
        }
        while (iterator.hasNext()) {
            printWriter.println("  " + (String)iterator.next());
            iterator.remove();
        }
    }
}

