/*
 * Decompiled with CFR 0.152.
 */
package rdt.Radar;

import rdt.AgentSmith.AgentSmith;
import rdt.RobotData.RobotData;
import rdt.RobotData.RobotDataSnapshot;
import rdt.SubsystemMode;
import rdt.Targeting.Targeting;
import robocode.util.Utils;

public class RadarOneVOneMode
extends SubsystemMode {
    public RadarOneVOneMode() {
        this.Initialise("One V One");
    }

    @Override
    public void UpdateHighestPriority() {
        RobotData currentTarget = Targeting.GetCurrentTarget();
        RobotDataSnapshot snapshot = currentTarget.Snapshots.get(0);
        double radarOffset = Utils.normalRelativeAngle((double)(snapshot.AbsoluteAngleFromTarget - AgentSmith.Instance().getRadarHeadingRadians()));
        AgentSmith.Instance().setTurnRadarRightRadians(radarOffset * 2.0);
    }

    @Override
    public float GetPriority() {
        RobotData currentTarget = Targeting.GetCurrentTarget();
        if (currentTarget == null) {
            return 0.0f;
        }
        if (!currentTarget.Valid) {
            return 0.0f;
        }
        if (AgentSmith.Instance().getTime() - currentTarget.TickLastUpdated > 8L) {
            return 0.0f;
        }
        if (AgentSmith.Instance().getOthers() == 1 && Targeting.GetCurrentTarget().Valid) {
            return 1.0f;
        }
        return 0.0f;
    }

    @Override
    public void Shutdown() {
    }

    @Override
    public void Update() {
    }

    @Override
    public void OnRoundStart() {
    }

    public void OnRoundEnd() {
    }
}

