/*
 * Decompiled with CFR 0.152.
 */
package ds.movement;

import ds.Hud;
import ds.PluggableRobot;
import ds.Utils;
import ds.Versatile;
import ds.constant.ConstantManager;
import ds.gun.BulletWave;
import ds.gun.IVirtualBullet;
import ds.gun.VirtualBullet;
import ds.movement.AntiGravityObject;
import ds.movement.EnemyTargetManager;
import ds.movement.HorizontalLine;
import ds.movement.IMovementManager;
import ds.movement.MovingAntiGravityObject;
import ds.movement.MovingPerpendicularAntiGravityObject;
import ds.movement.TargetTrackerAntiGravityObject;
import ds.movement.Vector2D;
import ds.movement.VerticalLine;
import ds.targeting.ITargetManager;
import ds.targeting.IVirtualBot;
import ds.targeting.TargetException;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import robocode.Rules;

public class MovementManager
implements IMovementManager {
    private PluggableRobot m_owner;
    private ArrayList<AntiGravityObject> m_agObjects;
    private ITargetManager m_targetManager;
    private Vector2D m_moveVector;
    private Double m_BulletGravity;
    private double m_BulletGravityType;
    private EnemyTargetManager m_enemyTargetManager;
    private ArrayList<BulletWave> m_waves;
    private static int BINS = 37;
    private double[] m_surfStats = new double[BINS];
    private double m_surfStatsMax = 0.5;
    private double m_vbTakens = 0.0;

    public MovementManager(Versatile owner, ITargetManager targetManager) {
        int x = 0;
        while (x < BINS) {
            this.m_surfStats[x] = 0.0;
            ++x;
        }
        this.m_waves = new ArrayList();
        this.m_moveVector = new Vector2D(0.0, 0.0);
        this.m_enemyTargetManager = new EnemyTargetManager(owner);
        ConstantManager cm = ConstantManager.getInstance();
        this.m_BulletGravity = cm.getDoubleConstant("movement.BulletGravity");
        this.m_BulletGravityType = cm.getDoubleConstant("movement.BulletGravityType").longValue();
        this.m_targetManager = targetManager;
        this.m_owner = owner;
        this.m_agObjects = new ArrayList();
        double cornersGravity = cm.getDoubleConstant("movement.cornerGravity");
        double cornersGravityType = cm.getDoubleConstant("movement.cornerGravityType").longValue();
        this.m_agObjects.add(new AntiGravityObject(0.0, 0.0, cornersGravity, cornersGravityType));
        this.m_agObjects.add(new AntiGravityObject(this.m_owner.getBattleFieldWidth(), 0.0, cornersGravity, cornersGravityType));
        this.m_agObjects.add(new AntiGravityObject(this.m_owner.getBattleFieldWidth(), this.m_owner.getBattleFieldHeight(), cornersGravity, cornersGravityType));
        this.m_agObjects.add(new AntiGravityObject(0.0, this.m_owner.getBattleFieldHeight(), cornersGravity, cornersGravityType));
        double centerGravity = cm.getDoubleConstant("movement.centerGravity");
        double centerGravityType = cm.getDoubleConstant("movement.centerGravityType").longValue();
        this.m_agObjects.add(new AntiGravityObject(this.m_owner.getCenter().getX(), this.m_owner.getCenter().getY(), centerGravity, centerGravityType));
        double targetGravity = cm.getDoubleConstant("movement.targetGravity");
        double targetGravityType = cm.getDoubleConstant("movement.targetGravityType").longValue();
        this.m_agObjects.add(new TargetTrackerAntiGravityObject(this.m_targetManager, targetGravity, targetGravityType));
        double wallsGravity = cm.getDoubleConstant("movement.wallsGravity");
        double wallsGravityType = cm.getDoubleConstant("movement.wallsGravityType").longValue();
        this.m_agObjects.add(new VerticalLine(0.0, wallsGravity * 1.33, wallsGravityType));
        this.m_agObjects.add(new VerticalLine(this.m_owner.getBattleFieldWidth(), wallsGravity, wallsGravityType));
        this.m_agObjects.add(new HorizontalLine(0.0, wallsGravity * 1.33, wallsGravityType));
        this.m_agObjects.add(new HorizontalLine(this.m_owner.getBattleFieldHeight(), wallsGravity, wallsGravityType));
    }

    @Override
    public void Act() {
        try {
            IVirtualBot target = this.m_targetManager.getCurrentTarget();
            if (target.getTimeSinceLastShot() == 0) {
                double angleHot = 0.0;
                double angleLinear = 0.0;
                Point2D.Double targetPosition = this.m_targetManager.getCurrentTarget().getPosition();
                Point2D.Double myPosition = this.m_owner.getPosition();
                Point2D.Double myNextPosition = new Point2D.Double(this.m_owner.getX() - Math.sin(this.m_owner.getHeading()) * this.m_owner.getVelocity(), this.m_owner.getY() - Math.cos(this.m_owner.getHeading()) * this.m_owner.getVelocity());
                MovingPerpendicularAntiGravityObject bulletTracker = new MovingPerpendicularAntiGravityObject(target, this.m_BulletGravity, this.m_BulletGravityType);
                double angle = this.absbearing(targetPosition, myNextPosition);
                VirtualBullet vb = new VirtualBullet(null, null, target.getPosition(), angle += Math.random() * Math.PI / 16.0 - 0.09817477042468103, target.getLastShotPower());
                bulletTracker.setMovingObject(vb);
                vb.update();
                this.m_agObjects.add(bulletTracker);
                angleHot = angle;
                bulletTracker = new MovingPerpendicularAntiGravityObject(target, this.m_BulletGravity, this.m_BulletGravityType);
                double hotAngle = this.absbearing(targetPosition, myNextPosition);
                double angle2 = hotAngle + Math.asin(this.m_owner.getVelocity() / Rules.getBulletSpeed((double)target.getLastShotPower()) * Math.sin(this.m_owner.getHeadingRadians() - hotAngle));
                VirtualBullet vb2 = new VirtualBullet(null, null, target.getPosition(), angle2 += Math.random() * Math.PI / 16.0 - 0.09817477042468103, target.getLastShotPower());
                bulletTracker.setMovingObject(vb2);
                vb2.update();
                this.m_agObjects.add(bulletTracker);
                angleLinear = angle2;
                double distanceBetweenBullets = Math.tan(Math.abs(angleHot - angleLinear)) * myNextPosition.distance(targetPosition);
                if (distanceBetweenBullets < 80.0) {
                    MovingPerpendicularAntiGravityObject bulletTracker2 = new MovingPerpendicularAntiGravityObject(target, this.m_BulletGravity / 3.0, this.m_BulletGravityType);
                    double andleMedian = (angleHot + angleLinear) / 2.0;
                    vb2 = new VirtualBullet(null, null, target.getPosition(), andleMedian, target.getLastShotPower());
                    bulletTracker2.setMovingObject(vb2);
                    vb2.update();
                    this.m_agObjects.add(bulletTracker2);
                }
                BulletWave bw = new BulletWave(this.m_owner.getRoundNum(), this.m_owner.getTime(), true);
                this.m_waves.add(bw);
                double maxEscapeAngle = 2.0 * Math.asin(8.0 / (20.0 - 3.0 * target.getLastShotPower()));
                double direction = this.isLeft(target.getPosition(), myNextPosition, myPosition) ? 1 : -1;
                angleHot = this.absbearing(targetPosition, myNextPosition);
                int i = -18;
                while (i <= 18) {
                    double bulletDanger = this.m_surfStats[i + 18] / (this.m_surfStatsMax + 1.0E-5);
                    double bulletGravity = bulletDanger * this.m_BulletGravity;
                    double step = maxEscapeAngle / 37.0;
                    double angle3 = direction * (double)i * step + angleHot;
                    VirtualBullet vb3 = new VirtualBullet(null, null, target.getPosition(), angle3, target.getLastShotPower());
                    vb3.update();
                    bw.addBullet(vb3);
                    if (bulletDanger > 0.95) {
                        vb3 = new VirtualBullet(null, null, target.getPosition(), angle3, target.getLastShotPower());
                        vb3.update();
                        MovingPerpendicularAntiGravityObject bulletTracker3 = new MovingPerpendicularAntiGravityObject(target, bulletGravity, this.m_BulletGravityType);
                        bulletTracker3.setMovingObject(vb3);
                        this.m_agObjects.add(bulletTracker3);
                    }
                    ++i;
                }
            }
        }
        catch (TargetException target) {
            // empty catch block
        }
        this.m_moveVector = new Vector2D(0.0, 0.0);
        Point2D.Double referent = new Point2D.Double(this.m_owner.getX(), this.m_owner.getY());
        int i = 0;
        while (i < this.m_agObjects.size()) {
            AntiGravityObject ago = this.m_agObjects.get(i);
            if (MovingAntiGravityObject.class.isAssignableFrom(ago.getClass())) {
                MovingAntiGravityObject mago = (MovingAntiGravityObject)ago;
                mago.updatePosition();
                if (mago.isOutOfBattlefield()) {
                    this.m_agObjects.remove(mago);
                    --i;
                }
            }
            ++i;
        }
        for (BulletWave wave : this.m_waves) {
            for (VirtualBullet vb : wave.getBullets()) {
                vb.update();
            }
        }
        Point2D.Double myPosition = this.m_owner.getPosition();
        for (BulletWave wave : this.m_waves) {
            int index = 0;
            for (VirtualBullet vb : wave.getBullets()) {
                if (vb.getCurrentPosition().distance(myPosition) < 40.0) {
                    vb.setHit(true);
                }
                ++index;
            }
        }
        Iterator<BulletWave> itBW = this.m_waves.iterator();
        while (itBW.hasNext()) {
            BulletWave wave = itBW.next();
            VirtualBullet vb1 = wave.getBullets().get(0);
            if (!(vb1.travelDistance() - 40.0 > vb1.getStartPosition().distance(this.m_owner.getPosition()))) continue;
            int firstHit = -1;
            int lastHit = -1;
            int i2 = 0;
            for (VirtualBullet vb : wave.getBullets()) {
                if (vb.hasHit()) {
                    if (firstHit == -1) {
                        firstHit = i2;
                    }
                } else if (firstHit != -1 && lastHit == -1) {
                    lastHit = i2;
                }
                ++i2;
            }
            if (firstHit != -1 && lastHit == -1) {
                lastHit = i2 - 1;
            }
            if (firstHit != -1 && lastHit != -1) {
                int index = (lastHit + firstHit) / 2;
                this.m_surfStatsMax = 0.0;
                int x = 0;
                while (x < BINS) {
                    this.m_surfStats[x] = Utils.rollingAvg(this.m_surfStats[x], 1.0 / (Math.pow(index - x, 2.0) + 1.0), Math.min(this.m_vbTakens, 200.0), 1.0);
                    if (this.m_surfStats[x] > this.m_surfStatsMax) {
                        this.m_surfStatsMax = this.m_surfStats[x];
                    }
                    ++x;
                }
                this.m_vbTakens += 1.0;
            }
            itBW.remove();
        }
        for (AntiGravityObject ago : this.m_agObjects) {
            this.m_moveVector.add(ago.getForceVector(referent));
        }
        if (this.m_moveVector.getR() <= 20.0) {
            try {
                Point2D.Double targetPosition = this.m_targetManager.getCurrentTarget().getPosition();
                Point2D.Double myposition = new Point2D.Double(this.m_owner.getX(), this.m_owner.getY());
                double angle = this.absbearing(targetPosition, myposition);
                angle += 1.5707963267948966 - this.m_owner.getHeadingRadians();
                angle = robocode.util.Utils.normalRelativeAngle((double)angle);
                this.m_owner.setTurnRightRadians(angle);
                this.m_owner.setAhead(0.0);
            }
            catch (TargetException targetException) {}
        } else {
            this.goTo(new Point2D.Double(this.m_moveVector.getX() + this.m_owner.getX(), this.m_moveVector.getY() + this.m_owner.getY()));
        }
    }

    private void goTo(Point2D point) {
        Point2D.Double location = new Point2D.Double(this.m_owner.getX(), this.m_owner.getY());
        double distance = location.distance(point);
        double angle = robocode.util.Utils.normalRelativeAngle((double)(this.absbearing(location, point) - this.m_owner.getHeadingRadians()));
        if (Math.abs(angle) > 1.5707963267948966) {
            distance *= -1.0;
            angle = angle > 0.0 ? (angle -= Math.PI) : (angle += Math.PI);
        }
        this.m_owner.setTurnRightRadians(angle);
        this.m_owner.setAhead(distance);
    }

    public double absbearing(Point2D pt1, Point2D pt2) {
        double xo = pt2.getX() - pt1.getX();
        double yo = pt2.getY() - pt1.getY();
        double h = pt1.distance(pt2);
        if (xo > 0.0 && yo > 0.0) {
            return Math.asin(xo / h);
        }
        if (xo > 0.0 && yo < 0.0) {
            return Math.PI - Math.asin(xo / h);
        }
        if (xo < 0.0 && yo < 0.0) {
            return Math.PI + Math.asin(-xo / h);
        }
        if (xo < 0.0 && yo > 0.0) {
            return Math.PI * 2 - Math.asin(-xo / h);
        }
        return 0.0;
    }

    @Override
    public void paint(Hud hud, long tick) {
        hud.setColor(Color.gray);
        for (BulletWave bw : this.m_waves) {
            for (IVirtualBullet iVirtualBullet : bw.getBullets()) {
                if (iVirtualBullet.hasHit()) {
                    hud.setColor(Color.red);
                } else {
                    hud.setColor(new Color(15, 15, 15));
                }
                hud.drawFilledCircle(iVirtualBullet.getCurrentPosition().getX(), iVirtualBullet.getCurrentPosition().getY(), 2.5);
            }
        }
        hud.setColor(Color.white);
        hud.drawLine(this.m_owner.getX(), this.m_owner.getY(), this.m_owner.getX() + this.m_moveVector.getX(), this.m_owner.getY() + this.m_moveVector.getY());
        hud.setColor(Color.cyan);
        Point2D.Double referent = new Point2D.Double(this.m_owner.getX(), this.m_owner.getY());
        for (AntiGravityObject ago : this.m_agObjects) {
            Vector2D forceVector = ago.getForceVector(referent);
            double X = ago.getPosition().getX();
            double Y = ago.getPosition().getY();
            double X2 = X + forceVector.getX();
            double Y2 = Y + forceVector.getY();
            hud.drawLine(X, Y, X2, Y2);
            hud.drawCircle(X, Y, 2.0);
        }
        hud.setColor(Color.lightGray);
        hud.drawLine(50.0, 100.0, 50.0, 150.0);
        hud.drawLine(50.0, 100.0, 230.0, 100.0);
        int i = 1;
        while (i < BINS) {
            double d = this.m_surfStats[i - 1] / (this.m_surfStatsMax + 1.0E-7);
            double vnext = this.m_surfStats[i] / (this.m_surfStatsMax + 1.0E-7);
            hud.drawLine(50 + (i - 1) * 5, 100.0 + d * 50.0, 50 + i * 5, 100.0 + vnext * 50.0);
            ++i;
        }
    }

    private Point2D.Double fastWallSmooth(Point2D.Double orbitCenter, Point2D.Double position, Vector2D vStick) {
        double MARGIN = 30.0;
        Point2D.Double projected = new Point2D.Double(position.x + vStick.getX(), position.y + vStick.getY());
        double direction = this.isLeft(position, orbitCenter, projected) ? 1 : -1;
        double distanceToOrbitCenter = orbitCenter.distance(position);
        double stickLength = vStick.getR();
        double fieldWidth = this.m_owner.getBattleFieldWidth();
        double fieldHeight = this.m_owner.getBattleFieldHeight();
        double stick = Math.min(stickLength, distanceToOrbitCenter);
        double stickSquared = this.square(stick);
        int LEFT = -1;
        int RIGHT = 1;
        int TOP = 1;
        int BOTTOM = -1;
        int topOrBottomWall = 0;
        int leftOrRightWall = 0;
        if (projected.x >= 30.0 && projected.x <= fieldWidth - 30.0 && projected.y >= 30.0 && projected.y <= fieldHeight - 30.0) {
            return projected;
        }
        if (projected.x > fieldWidth - 30.0 || position.x > fieldWidth - stick - 30.0) {
            leftOrRightWall = RIGHT;
        } else if (projected.x < 30.0 || position.x < stick + 30.0) {
            leftOrRightWall = LEFT;
        }
        if (projected.y > fieldHeight - 30.0 || position.y > fieldHeight - stick - 30.0) {
            topOrBottomWall = TOP;
        } else if (projected.y < 30.0 || position.y < stick + 30.0) {
            topOrBottomWall = BOTTOM;
        }
        if (topOrBottomWall == TOP) {
            if (leftOrRightWall == LEFT) {
                if (direction > 0.0) {
                    return new Point2D.Double(position.x + direction * Math.sqrt(stickSquared - this.square(fieldHeight - 30.0 - position.y)), fieldHeight - 30.0);
                }
                return new Point2D.Double(30.0, position.y + direction * Math.sqrt(stickSquared - this.square(position.x - 30.0)));
            }
            if (leftOrRightWall == RIGHT) {
                if (direction > 0.0) {
                    return new Point2D.Double(fieldWidth - 30.0, position.y - direction * Math.sqrt(stickSquared - this.square(fieldWidth - 30.0 - position.x)));
                }
                return new Point2D.Double(position.x + direction * Math.sqrt(stickSquared - this.square(fieldHeight - 30.0 - position.y)), fieldHeight - 30.0);
            }
            return new Point2D.Double(position.x + direction * Math.sqrt(stickSquared - this.square(fieldHeight - 30.0 - position.y)), fieldHeight - 30.0);
        }
        if (topOrBottomWall == BOTTOM) {
            if (leftOrRightWall == LEFT) {
                if (direction > 0.0) {
                    return new Point2D.Double(30.0, position.y + direction * Math.sqrt(stickSquared - this.square(position.x - 30.0)));
                }
                return new Point2D.Double(position.x - direction * Math.sqrt(stickSquared - this.square(position.y - 30.0)), 30.0);
            }
            if (leftOrRightWall == RIGHT) {
                if (direction > 0.0) {
                    return new Point2D.Double(position.x - direction * Math.sqrt(stickSquared - this.square(position.y - 30.0)), 30.0);
                }
                return new Point2D.Double(fieldWidth - 30.0, position.y - direction * Math.sqrt(stickSquared - this.square(fieldWidth - 30.0 - position.x)));
            }
            return new Point2D.Double(position.x - direction * Math.sqrt(stickSquared - this.square(position.y - 30.0)), 30.0);
        }
        if (leftOrRightWall == LEFT) {
            return new Point2D.Double(30.0, position.y + direction * Math.sqrt(stickSquared - this.square(position.x - 30.0)));
        }
        if (leftOrRightWall == RIGHT) {
            return new Point2D.Double(fieldWidth - 30.0, position.y - direction * Math.sqrt(stickSquared - this.square(fieldWidth - 30.0 - position.x)));
        }
        throw new RuntimeException("This code should be unreachable. position = " + position.x + ", " + position.y + "  orbitCenter = " + orbitCenter.x + ", " + orbitCenter.y + " direction = " + direction);
    }

    private static Point2D.Double projectPoint(Point2D.Double origin, double angle, double distance) {
        return new Point2D.Double(origin.x + distance * Math.sin(angle), origin.y + distance * Math.cos(angle));
    }

    private static double absoluteAngle(Point2D.Double origin, Point2D.Double target) {
        return Math.atan2(target.x - origin.x, target.y - origin.y);
    }

    private double square(double x) {
        return x * x;
    }

    private boolean isLeft(Point2D.Double a, Point2D.Double b, Point2D.Double c) {
        return (b.x - a.x) * (c.y - a.y) - (b.y - a.y) * (c.x - a.x) > 0.0;
    }
}

