/*
 * Decompiled with CFR 0.152.
 */
package fwb;

import MGAM.BotMaster;
import MGAM.Enemy;
import MGAM.EnemySelection;
import MGAM.Vec2D;
import fwb.FWBBotInfo;
import java.awt.Color;
import java.awt.Graphics2D;

public class RandomSelection
extends EnemySelection {
    public RandomSelection(BotMaster bot) {
        super(bot);
    }

    @Override
    public void select() {
        int numOpponents = this.bot.getOthers();
        if (numOpponents == 0 || BotMaster.enemies.size() == 0) {
            this.bot.enemy = null;
            return;
        }
        Enemy selected = null;
        Math.random();
        BotMaster.enemies.size();
        double bestTarget = 0.0;
        int maxNumClosestToShot = 0;
        this.bot.plannedShot = false;
        for (Enemy target : BotMaster.enemies.values()) {
            if (target.bDead) continue;
            double targetWeight = 0.0;
            Vec2D targetPos = ((FWBBotInfo)target.botInfo).getPosition();
            Vec2D myPos = ((FWBBotInfo)this.bot.self.botInfo).getPosition();
            double dist = targetPos.distance(myPos);
            double distScore = Math.min(1.0 - dist / BotMaster.battlefieldWidth, 1.0);
            if (dist < 250.0) {
                targetWeight += distScore * 10.0;
            }
            if (dist < 150.0) {
                targetWeight += 500.0 + 500.0 * (1.0 - dist / 250.0);
            }
            Vec2D targetHeading = new Vec2D(Math.sin(target.botInfo.dHeadingRad), Math.cos(target.botInfo.dHeadingRad));
            Vec2D targetDir = targetPos.subtract(myPos);
            targetDir = targetDir.normalize();
            double gunHeadingDot = Math.abs(targetDir.dotProduct(targetHeading));
            double targetOrientationWeight = gunHeadingDot * 4.0;
            if (dist < 500.0 && gunHeadingDot > 0.8) {
                targetWeight += targetOrientationWeight;
            }
            int clumpCount = 0;
            for (Enemy otherTarget : BotMaster.enemies.values()) {
                Vec2D otherTargetPos = ((FWBBotInfo)otherTarget.botInfo).getPosition();
                double botDistances = otherTargetPos.distance(targetPos);
                if (!(botDistances < 175.0)) continue;
                ++clumpCount;
            }
            if (clumpCount >= 4) {
                targetWeight += 20.0;
            }
            if (target.botInfo.dEnergy == 0.0) {
                targetWeight += 1.0;
            }
            Line meToTarget = new Line(myPos, targetPos);
            Vec2D targetPerp = new Vec2D(targetDir.y, -targetDir.x);
            int numCloseToShot = 0;
            for (Enemy otherTank : BotMaster.enemies.values()) {
                Line otherToShot;
                Vec2D intersectToShot;
                Vec2D otherTargetPos;
                Vec2D shotToOtherTank;
                double distToShot;
                if (otherTank.botInfo.dEnergy == 0.0 || otherTank.bDead || !((distToShot = (shotToOtherTank = (otherTargetPos = ((FWBBotInfo)otherTank.botInfo).getPosition()).subtract(intersectToShot = meToTarget.Intersect(otherToShot = new Line(otherTargetPos, otherTargetPos.add(targetPerp))))).magnitude()) < 275.0)) continue;
                ++numCloseToShot;
            }
            if (numCloseToShot > maxNumClosestToShot) {
                maxNumClosestToShot = numCloseToShot;
                if (selected == null) {
                    selected = target;
                }
            }
            if (numCloseToShot >= 4) {
                targetWeight += 20.0;
            }
            if (!(targetWeight > bestTarget)) continue;
            bestTarget = targetWeight;
            selected = target;
            this.bot.plannedShot = true;
        }
        this.bot.enemy = selected;
        this.bot.chumpShot = false;
        if (this.bot.enemy != null && this.bot.enemy.botInfo.dEnergy == 0.0) {
            this.bot.chumpShot = true;
        }
    }

    @Override
    public void onPaint(Graphics2D g) {
        if (this.bot.enemy != null) {
            g.setColor(new Color(255, 255, 0, 128));
            g.drawLine((int)this.bot.enemy.botInfo.dX, (int)this.bot.enemy.botInfo.dY, (int)this.bot.getX(), (int)this.bot.getY());
            g.fillRect((int)this.bot.enemy.botInfo.dX - 18, (int)this.bot.enemy.botInfo.dY - 18, 36, 36);
        }
    }

    public class Line {
        Vec2D p1;
        Vec2D p2;

        public Line(Vec2D point1, Vec2D point2) {
            this.p1 = point1;
            this.p2 = point2;
        }

        public Line() {
            this.p1 = new Vec2D(0.0, 0.0);
            this.p2 = new Vec2D(0.0, 0.0);
        }

        public Vec2D Intersect(Line line) {
            Vec2D temp = new Vec2D(0.0, 0.0);
            temp.x = ((this.p1.x * this.p2.y - this.p1.y * this.p2.x) * (line.p1.x - line.p2.x) - (this.p1.x - this.p2.x) * (line.p1.x * line.p2.y - line.p1.y * line.p2.x)) / ((this.p1.x - this.p2.x) * (line.p1.y - line.p2.y) - (this.p1.y - this.p2.y) * (line.p1.x - line.p2.x));
            temp.y = ((this.p1.x * this.p2.y - this.p1.y * this.p2.x) * (line.p1.y - line.p2.y) - (this.p1.y - this.p2.y) * (line.p1.x * line.p2.y - line.p1.y * line.p2.x)) / ((this.p1.x - this.p2.x) * (line.p1.y - line.p2.y) - (this.p1.y - this.p2.y) * (line.p1.x - line.p2.x));
            return temp;
        }
    }
}

